/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor.asm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.IAsmLanguage;
import org.eclipse.cdt.internal.ui.editor.asm.AsmLabelRule;
import org.eclipse.cdt.internal.ui.editor.asm.AsmWordDetector;
import org.eclipse.cdt.internal.ui.text.AbstractCScanner;
import org.eclipse.cdt.internal.ui.text.util.CWhitespaceDetector;
import org.eclipse.cdt.ui.text.ITokenStoreFactory;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordPatternRule;
import org.eclipse.jface.text.rules.WordRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsmCodeScanner
extends AbstractCScanner {
    private static String[] fgTokenProperties = new String[]{"asm_directive", "asm_label", "c_keyword", "c_single_line_comment", "c_default"};
    private IAsmLanguage fAsmLanguage;

    public AsmCodeScanner(ITokenStoreFactory factory, IAsmLanguage asmLanguage) {
        super(factory.createTokenStore(fgTokenProperties));
        this.fAsmLanguage = asmLanguage;
        this.setRules(this.createRules());
    }

    protected List<IRule> createRules() {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        IToken token = this.getToken("c_single_line_comment");
        char[] lineCommentChars = this.fAsmLanguage.getLineCommentCharacters();
        int i = 0;
        while (i < lineCommentChars.length) {
            rules.add((IRule)new EndOfLineRule(new String(new char[]{lineCommentChars[i]}), token));
            ++i;
        }
        rules.add((IRule)new WhitespaceRule((IWhitespaceDetector)new CWhitespaceDetector()));
        IToken other = this.getToken("c_default");
        token = this.getToken("asm_label");
        AsmLabelRule labelRule = new AsmLabelRule(new AsmWordDetector(false), token, other);
        rules.add(labelRule);
        token = this.getToken("asm_directive");
        String[] keywords = this.fAsmLanguage.getDirectiveKeywords();
        WordRule wordRule = new WordRule((IWordDetector)new AsmWordDetector('.'), other);
        int i2 = 0;
        while (i2 < keywords.length) {
            wordRule.addWord(keywords[i2], token);
            ++i2;
        }
        rules.add((IRule)wordRule);
        token = this.getToken("c_keyword");
        WordPatternRule regPattern = new WordPatternRule((IWordDetector)new AsmWordDetector('%', '\u0000'), "%", null, token);
        rules.add((IRule)regPattern);
        this.setDefaultReturnToken(other);
        return rules;
    }
}

