/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.navigator;

import java.util.Iterator;
import org.eclipse.cdt.internal.ui.cview.CViewMessages;
import org.eclipse.cdt.internal.ui.navigator.AbstractCNavigatorActionGroup;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.BuildAction;

public class CNavigatorBuildActionGroup
extends AbstractCNavigatorActionGroup {
    private BuildAction fCleanAction;
    final String BUILD_GROUP_MARKER = "buildGroup";
    final String BUILD_GROUP_MARKER_END = "end-buildGroup";

    public CNavigatorBuildActionGroup(IViewPart viewPart) {
        super(viewPart);
    }

    public void fillActionBars(IActionBars actionBars) {
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean isProjectSelection = true;
        boolean hasOpenProjects = false;
        boolean hasClosedProjects = false;
        boolean hasBuilder = true;
        Iterator resources = selection.iterator();
        while (resources.hasNext() && (!hasOpenProjects || !hasClosedProjects || hasBuilder || isProjectSelection)) {
            IResource res;
            Object next = resources.next();
            IProject project = null;
            if (next instanceof IProject) {
                project = (IProject)next;
            } else if (next instanceof IAdaptable && (res = (IResource)((IAdaptable)next).getAdapter(IResource.class)) instanceof IProject) {
                project = (IProject)res;
            }
            if (project == null) {
                isProjectSelection = false;
                continue;
            }
            if (project.isOpen()) {
                hasOpenProjects = true;
                if (!hasBuilder || this.hasBuilder(project)) continue;
                hasBuilder = false;
                continue;
            }
            hasClosedProjects = true;
            hasBuilder = false;
        }
        if (!selection.isEmpty() && isProjectSelection && hasBuilder) {
            this.fCleanAction.selectionChanged(selection);
            if (this.fCleanAction.isEnabled()) {
                if (menu.find("org.eclipse.ui.BuildAction") != null) {
                    menu.insertAfter("org.eclipse.ui.BuildAction", (IAction)this.fCleanAction);
                } else {
                    menu.insertAfter("group.build", (IAction)this.fCleanAction);
                }
            }
        }
        menu.appendToGroup("group.build", (IContributionItem)new Separator("buildGroup"));
        menu.appendToGroup("buildGroup", (IContributionItem)new GroupMarker("end-buildGroup"));
    }

    boolean hasBuilder(IProject project) {
        try {
            ICommand[] commands = project.getDescription().getBuildSpec();
            if (commands.length > 0) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    protected void makeActions() {
        this.fCleanAction = new BuildAction((IShellProvider)this.getViewPart().getSite(), 15);
        this.fCleanAction.setText(CViewMessages.getString("CleanAction.label"));
    }

    public void updateActionBars() {
    }
}

