/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.cdt.internal.ui.preferences.formatter.SnippetPreview;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WhiteSpaceOptions {
    private final SnippetPreview.PreviewSnippet FOR_PREVIEW = new SnippetPreview.PreviewSnippet(2, "for (int i= 0, j= argc; i < argc; i++, j--) {}");
    private final SnippetPreview.PreviewSnippet WHILE_PREVIEW = new SnippetPreview.PreviewSnippet(2, "while (condition) {} do {} while (condition);");
    private final SnippetPreview.PreviewSnippet CATCH_PREVIEW = new SnippetPreview.PreviewSnippet(2, "try { number= Math::parseInt(value); } catch (Math::Exception e) {}");
    private final SnippetPreview.PreviewSnippet IF_PREVIEW = new SnippetPreview.PreviewSnippet(2, "if (condition) { return foo; } else {return bar;}");
    private final SnippetPreview.PreviewSnippet SWITCH_PREVIEW = new SnippetPreview.PreviewSnippet(2, "switch (number) { case RED: return GREEN; case GREEN: return BLUE; case BLUE: return RED; default: return BLACK;}");
    private final SnippetPreview.PreviewSnippet METHOD_DECL_PREVIEW = new SnippetPreview.PreviewSnippet(4, "void foo() throw(E0, E1) {}void bar(int x, int y) throw(E0, E1) {}");
    private final SnippetPreview.PreviewSnippet INITIALIZER_LIST_PREVIEW = new SnippetPreview.PreviewSnippet(2, "int array[]= {1, 2, 3};");
    private final SnippetPreview.PreviewSnippet ARRAY_PREVIEW = new SnippetPreview.PreviewSnippet(2, "int array[]= {1, 2, 3};\narray [2] = 0;\nint * parray= new int[3];delete[] parray;");
    private final SnippetPreview.PreviewSnippet METHOD_CALL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "foo();\nbar(x, y);");
    private final SnippetPreview.PreviewSnippet LABEL_PREVIEW = new SnippetPreview.PreviewSnippet(2, "label: for (int i= 0; i<argc; i++) goto label;");
    private final SnippetPreview.PreviewSnippet SEMICOLON_PREVIEW = new SnippetPreview.PreviewSnippet(2, "int a= 4; foo(); bar(x, y);");
    private final SnippetPreview.PreviewSnippet CONDITIONAL_PREVIEW = new SnippetPreview.PreviewSnippet(8, "bool value= condition ? true : false;");
    private final SnippetPreview.PreviewSnippet CLASS_DECL_PREVIEW = new SnippetPreview.PreviewSnippet(8, "class MyClass : Base1, Base2 {};");
    private final SnippetPreview.PreviewSnippet OPERATOR_PREVIEW = new SnippetPreview.PreviewSnippet(2, "int a= -4 + -9; b= a++ / --number; c += 4; bool value= true && false;");
    private final SnippetPreview.PreviewSnippet CAST_PREVIEW = new SnippetPreview.PreviewSnippet(2, "char * s= ((char *)object);");
    private final SnippetPreview.PreviewSnippet EXPRESSION_LIST_PREVIEW = new SnippetPreview.PreviewSnippet(2, "a= 0, b= 1, c= 2, d= 3;");
    private final SnippetPreview.PreviewSnippet DECLARATOR_LIST_PREVIEW = new SnippetPreview.PreviewSnippet(2, "int a=0,b=1,c=2,d=3;");
    private final SnippetPreview.PreviewSnippet BLOCK_PREVIEW = new SnippetPreview.PreviewSnippet(2, "if (true) { return 1; } else { return 2; }");
    private final SnippetPreview.PreviewSnippet PAREN_EXPR_PREVIEW = new SnippetPreview.PreviewSnippet(2, "result= (a *( b +  c + d) * (e + f));");
    private final SnippetPreview.PreviewSnippet TEMPLATES_PREVIEW = new SnippetPreview.PreviewSnippet(8, "template<typename T1,typename T2> class map {};\nmap<int,int> m;");

    public List<InnerNode> createTreeBySyntaxElem(Map<String, String> workingValues) {
        ArrayList<InnerNode> roots = new ArrayList<InnerNode>();
        InnerNode element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_opening_paren);
        this.createBeforeOpenParenTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterOpenParenTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_closing_paren);
        this.createBeforeClosingParenTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterCloseParenTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_opening_brace);
        this.createBeforeOpenBraceTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterOpenBraceTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_closing_brace);
        this.createBeforeClosingBraceTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterCloseBraceTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_opening_bracket);
        this.createBeforeOpenBracketTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterOpenBracketTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_closing_bracket);
        this.createBeforeClosingBracketTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_operator);
        this.createBeforeOperatorTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterOperatorTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_comma);
        this.createBeforeCommaTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterCommaTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_colon);
        this.createBeforeColonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterColonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_semicolon);
        this.createBeforeSemicolonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterSemicolonTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_question_mark);
        this.createBeforeQuestionTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_before));
        this.createAfterQuestionTree(workingValues, WhiteSpaceOptions.createChild(element, workingValues, FormatterMessages.WhiteSpaceOptions_after));
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_parens);
        this.createBetweenEmptyParenTree(workingValues, element);
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_braces);
        this.createBetweenEmptyBracesTree(workingValues, element);
        roots.add(element);
        element = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_brackets);
        this.createBetweenEmptyBracketsTree(workingValues, element);
        roots.add(element);
        return roots;
    }

    public List<InnerNode> createAltTree(Map<String, String> workingValues) {
        ArrayList<InnerNode> roots = new ArrayList<InnerNode>();
        InnerNode parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_opening_paren);
        this.createBeforeOpenParenTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_opening_paren);
        this.createAfterOpenParenTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_closing_paren);
        this.createBeforeClosingParenTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_closing_paren);
        this.createAfterCloseParenTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_parens);
        this.createBetweenEmptyParenTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_opening_brace);
        this.createBeforeOpenBraceTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_opening_brace);
        this.createAfterOpenBraceTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_closing_brace);
        this.createBeforeClosingBraceTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_closing_brace);
        this.createAfterCloseBraceTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_braces);
        this.createBetweenEmptyBracesTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_opening_bracket);
        this.createBeforeOpenBracketTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_opening_bracket);
        this.createAfterOpenBracketTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_closing_bracket);
        this.createBeforeClosingBracketTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_between_empty_brackets);
        this.createBetweenEmptyBracketsTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_opening_angle_bracket);
        this.createBeforeOpenAngleBracketTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_opening_angle_bracket);
        this.createAfterOpenAngleBracketTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_closing_angle_bracket);
        this.createBeforeClosingAngleBracketTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_closing_angle_bracket);
        this.createAfterClosingAngleBracketTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_operator);
        this.createBeforeOperatorTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_operator);
        this.createAfterOperatorTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_comma);
        this.createBeforeCommaTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_comma);
        this.createAfterCommaTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_colon);
        this.createAfterColonTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_colon);
        this.createBeforeColonTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_semicolon);
        this.createBeforeSemicolonTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_semicolon);
        this.createAfterSemicolonTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_before_question_mark);
        this.createBeforeQuestionTree(workingValues, parent);
        parent = this.createParentNode(roots, workingValues, FormatterMessages.WhiteSpaceOptions_after_question_mark);
        this.createAfterQuestionTree(workingValues, parent);
        return roots;
    }

    private InnerNode createParentNode(List<InnerNode> roots, Map<String, String> workingValues, String text) {
        InnerNode parent = new InnerNode(null, workingValues, text);
        roots.add(parent);
        return parent;
    }

    public ArrayList<InnerNode> createTreeByJavaElement(Map<String, String> workingValues) {
        InnerNode declarations = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceTabPage_declarations);
        this.createClassTree(workingValues, declarations);
        this.createDeclaratorListTree(workingValues, declarations);
        this.createMethodDeclTree(workingValues, declarations);
        this.createLabelTree(workingValues, declarations);
        InnerNode statements = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceTabPage_statements);
        WhiteSpaceOptions.createOption(statements, workingValues, FormatterMessages.WhiteSpaceOptions_before_semicolon, "org.eclipse.cdt.core.formatter.insert_space_before_semicolon", this.SEMICOLON_PREVIEW);
        this.createBlockTree(workingValues, statements);
        this.createIfStatementTree(workingValues, statements);
        this.createForStatementTree(workingValues, statements);
        this.createSwitchStatementTree(workingValues, statements);
        this.createDoWhileTree(workingValues, statements);
        this.createTryStatementTree(workingValues, statements);
        InnerNode expressions = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceTabPage_expressions);
        this.createFunctionCallTree(workingValues, expressions);
        this.createAssignmentTree(workingValues, expressions);
        this.createInitializerListTree(workingValues, expressions);
        this.createOperatorTree(workingValues, expressions);
        this.createParenthesizedExpressionTree(workingValues, expressions);
        this.createTypecastTree(workingValues, expressions);
        this.createConditionalTree(workingValues, expressions);
        this.createExpressionListTree(workingValues, expressions);
        InnerNode arrays = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceTabPage_arrays);
        this.createArrayTree(workingValues, arrays);
        InnerNode templates = new InnerNode(null, workingValues, FormatterMessages.WhiteSpaceTabPage_templates);
        this.createTemplateArgumentTree(workingValues, templates);
        this.createTemplateParameterTree(workingValues, templates);
        ArrayList<InnerNode> roots = new ArrayList<InnerNode>();
        roots.add(declarations);
        roots.add(statements);
        roots.add(expressions);
        roots.add(arrays);
        roots.add(templates);
        return roots;
    }

    private void createBeforeQuestionTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_conditional, "org.eclipse.cdt.core.formatter.insert_space_before_question_in_conditional", this.CONDITIONAL_PREVIEW);
    }

    private void createBeforeSemicolonTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.cdt.core.formatter.insert_space_before_semicolon_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_statements, "org.eclipse.cdt.core.formatter.insert_space_before_semicolon", this.SEMICOLON_PREVIEW);
    }

    private void createBeforeColonTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_conditional, "org.eclipse.cdt.core.formatter.insert_space_before_colon_in_conditional", this.CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_label, "org.eclipse.cdt.core.formatter.insert_space_before_colon_in_labeled_statement", this.LABEL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_base_clause, "org.eclipse.cdt.core.formatter.insert_space_before_colon_in_base_clause", this.CLASS_DECL_PREVIEW);
        InnerNode switchStatement = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch);
        WhiteSpaceOptions.createOption(switchStatement, workingValues, FormatterMessages.WhiteSpaceOptions_case, "org.eclipse.cdt.core.formatter.insert_space_before_colon_in_case", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(switchStatement, workingValues, FormatterMessages.WhiteSpaceOptions_default, "org.eclipse.cdt.core.formatter.insert_space_before_colon_in_default", this.SWITCH_PREVIEW);
    }

    private void createBeforeCommaTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode invocation = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_arguments);
        WhiteSpaceOptions.createOption(invocation, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.cdt.core.formatter.insert_space_before_comma_in_method_invocation_arguments", this.METHOD_CALL_PREVIEW);
        InnerNode decl = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_parameters);
        WhiteSpaceOptions.createOption(decl, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.cdt.core.formatter.insert_space_before_comma_in_method_declaration_parameters", this.METHOD_DECL_PREVIEW);
        InnerNode lists = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_lists);
        WhiteSpaceOptions.createOption(lists, workingValues, FormatterMessages.WhiteSpaceOptions_declarator_list, "org.eclipse.cdt.core.formatter.insert_space_before_comma_in_declarator_list", this.DECLARATOR_LIST_PREVIEW);
        WhiteSpaceOptions.createOption(lists, workingValues, FormatterMessages.WhiteSpaceOptions_expression_list, "org.eclipse.cdt.core.formatter.insert_space_before_comma_in_expression_list", this.EXPRESSION_LIST_PREVIEW);
        WhiteSpaceOptions.createOption(lists, workingValues, FormatterMessages.WhiteSpaceOptions_initializer_list, "org.eclipse.cdt.core.formatter.insert_space_before_comma_in_array_initializer", this.INITIALIZER_LIST_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_template_parameters, "org.eclipse.cdt.core.formatter.insert_space_before_comma_in_template_parameters", this.TEMPLATES_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_template_arguments, "org.eclipse.cdt.core.formatter.insert_space_before_comma_in_template_arguments", this.TEMPLATES_PREVIEW);
    }

    private void createBeforeOperatorTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_assignment_operator, "org.eclipse.cdt.core.formatter.insert_space_before_assignment_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_unary_operator, "org.eclipse.cdt.core.formatter.insert_space_before_unary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_binary_operator, "org.eclipse.cdt.core.formatter.insert_space_before_binary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_prefix_operator, "org.eclipse.cdt.core.formatter.insert_space_before_prefix_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_postfix_operator, "org.eclipse.cdt.core.formatter.insert_space_before_postfix_operator", this.OPERATOR_PREVIEW);
    }

    private void createBeforeClosingBracketTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_arrays, "org.eclipse.cdt.core.formatter.insert_space_before_closing_bracket", this.ARRAY_PREVIEW);
    }

    private void createBeforeClosingAngleBracketTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_template_parameters, "org.eclipse.cdt.core.formatter.insert_space_before_closing_angle_bracket_in_template_parameters", this.TEMPLATES_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_template_arguments, "org.eclipse.cdt.core.formatter.insert_space_before_closing_angle_bracket_in_template_arguments", this.TEMPLATES_PREVIEW);
    }

    private void createBeforeOpenBracketTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_arrays, "org.eclipse.cdt.core.formatter.insert_space_before_opening_bracket", this.ARRAY_PREVIEW);
    }

    private void createBeforeOpenAngleBracketTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_template_parameters, "org.eclipse.cdt.core.formatter.insert_space_before_opening_angle_bracket_in_template_parameters", this.TEMPLATES_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_template_arguments, "org.eclipse.cdt.core.formatter.insert_space_before_opening_angle_bracket_in_template_arguments", this.TEMPLATES_PREVIEW);
    }

    private void createBeforeClosingBraceTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_initializer_list, "org.eclipse.cdt.core.formatter.insert_space_before_closing_brace_in_array_initializer", this.CLASS_DECL_PREVIEW);
    }

    private void createBeforeOpenBraceTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_class_decl, "org.eclipse.cdt.core.formatter.insert_space_before_opening_brace_in_type_declaration", this.CLASS_DECL_PREVIEW);
        InnerNode functionDecl = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_member_function_declaration);
        WhiteSpaceOptions.createOption(functionDecl, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.cdt.core.formatter.insert_space_before_opening_brace_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_initializer_list, "org.eclipse.cdt.core.formatter.insert_space_before_opening_brace_in_array_initializer", this.INITIALIZER_LIST_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_block, "org.eclipse.cdt.core.formatter.insert_space_before_opening_brace_in_block", this.BLOCK_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch, "org.eclipse.cdt.core.formatter.insert_space_before_opening_brace_in_switch", this.SWITCH_PREVIEW);
    }

    private void createBeforeClosingParenTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_catch, "org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_catch", this.CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_if, "org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_if", this.IF_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch, "org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_switch", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_while, "org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_while", this.WHILE_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_cast, "org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_cast", this.CAST_PREVIEW);
        InnerNode decl = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_member_function_declaration);
        WhiteSpaceOptions.createOption(decl, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_method_invocation", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_paren_expr, "org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_parenthesized_expression", this.PAREN_EXPR_PREVIEW);
    }

    private void createBeforeOpenParenTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_catch, "org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_catch", this.CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_if, "org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_if", this.IF_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch, "org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_switch", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_while, "org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_while", this.WHILE_PREVIEW);
        InnerNode decls = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_member_function_declaration);
        WhiteSpaceOptions.createOption(decls, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_method_invocation", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_paren_expr, "org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_parenthesized_expression", this.PAREN_EXPR_PREVIEW);
    }

    private void createAfterQuestionTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_conditional, "org.eclipse.cdt.core.formatter.insert_space_after_question_in_conditional", this.CONDITIONAL_PREVIEW);
    }

    private void createAfterSemicolonTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.cdt.core.formatter.insert_space_after_semicolon_in_for", this.FOR_PREVIEW);
    }

    private void createAfterColonTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_conditional, "org.eclipse.cdt.core.formatter.insert_space_after_colon_in_conditional", this.CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_label, "org.eclipse.cdt.core.formatter.insert_space_after_colon_in_labeled_statement", this.LABEL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_base_clause, "org.eclipse.cdt.core.formatter.insert_space_after_colon_in_base_clause", this.CLASS_DECL_PREVIEW);
    }

    private void createAfterCommaTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode invocation = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_arguments);
        WhiteSpaceOptions.createOption(invocation, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.cdt.core.formatter.insert_space_after_comma_in_method_invocation_arguments", this.METHOD_CALL_PREVIEW);
        InnerNode decl = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_parameters);
        WhiteSpaceOptions.createOption(decl, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.cdt.core.formatter.insert_space_after_comma_in_method_declaration_parameters", this.METHOD_DECL_PREVIEW);
        InnerNode lists = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_lists);
        WhiteSpaceOptions.createOption(lists, workingValues, FormatterMessages.WhiteSpaceOptions_declarator_list, "org.eclipse.cdt.core.formatter.insert_space_after_comma_in_declarator_list", this.DECLARATOR_LIST_PREVIEW);
        WhiteSpaceOptions.createOption(lists, workingValues, FormatterMessages.WhiteSpaceOptions_expression_list, "org.eclipse.cdt.core.formatter.insert_space_after_comma_in_expression_list", this.EXPRESSION_LIST_PREVIEW);
        WhiteSpaceOptions.createOption(lists, workingValues, FormatterMessages.WhiteSpaceOptions_initializer_list, "org.eclipse.cdt.core.formatter.insert_space_after_comma_in_array_initializer", this.INITIALIZER_LIST_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_template_parameters, "org.eclipse.cdt.core.formatter.insert_space_after_comma_in_template_parameters", this.TEMPLATES_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_template_arguments, "org.eclipse.cdt.core.formatter.insert_space_after_comma_in_template_arguments", this.TEMPLATES_PREVIEW);
    }

    private void createAfterOperatorTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_assignment_operator, "org.eclipse.cdt.core.formatter.insert_space_after_assignment_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_unary_operator, "org.eclipse.cdt.core.formatter.insert_space_after_unary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_binary_operator, "org.eclipse.cdt.core.formatter.insert_space_after_binary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_prefix_operator, "org.eclipse.cdt.core.formatter.insert_space_after_prefix_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_postfix_operator, "org.eclipse.cdt.core.formatter.insert_space_after_postfix_operator", this.OPERATOR_PREVIEW);
    }

    private void createAfterOpenBracketTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_arrays, "org.eclipse.cdt.core.formatter.insert_space_after_opening_bracket", this.ARRAY_PREVIEW);
    }

    private void createAfterOpenAngleBracketTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_template_parameters, "org.eclipse.cdt.core.formatter.insert_space_after_opening_angle_bracket_in_template_parameters", this.TEMPLATES_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_template_arguments, "org.eclipse.cdt.core.formatter.insert_space_after_opening_angle_bracket_in_template_arguments", this.TEMPLATES_PREVIEW);
    }

    private void createAfterOpenBraceTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_initializer_list, "org.eclipse.cdt.core.formatter.insert_space_after_opening_brace_in_array_initializer", this.INITIALIZER_LIST_PREVIEW);
    }

    private void createAfterCloseBraceTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_block, "org.eclipse.cdt.core.formatter.insert_space_after_closing_brace_in_block", this.BLOCK_PREVIEW);
    }

    private void createAfterCloseParenTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_cast, "org.eclipse.cdt.core.formatter.insert_space_after_closing_paren_in_cast", this.CAST_PREVIEW);
    }

    private void createAfterClosingAngleBracketTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_template_parameters, "org.eclipse.cdt.core.formatter.insert_space_after_closing_angle_bracket_in_template_parameters", this.TEMPLATES_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_template_arguments, "org.eclipse.cdt.core.formatter.insert_space_after_closing_angle_bracket_in_template_arguments", this.TEMPLATES_PREVIEW);
    }

    private void createAfterOpenParenTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_catch, "org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_catch", this.CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_for, "org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_if, "org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_if", this.IF_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_switch, "org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_switch", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_while, "org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_while", this.WHILE_PREVIEW);
        InnerNode decls = WhiteSpaceOptions.createChild(parent, workingValues, FormatterMessages.WhiteSpaceOptions_member_function_declaration);
        WhiteSpaceOptions.createOption(decls, workingValues, FormatterMessages.WhiteSpaceOptions_method, "org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_type_cast, "org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_cast", this.CAST_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_method_invocation", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_paren_expr, "org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_parenthesized_expression", this.PAREN_EXPR_PREVIEW);
    }

    private void createBetweenEmptyParenTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_decl, "org.eclipse.cdt.core.formatter.insert_space_between_empty_parens_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_method_call, "org.eclipse.cdt.core.formatter.insert_space_between_empty_parens_in_method_invocation", this.METHOD_CALL_PREVIEW);
    }

    private void createBetweenEmptyBracketsTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_arrays, "org.eclipse.cdt.core.formatter.insert_space_between_empty_brackets", this.ARRAY_PREVIEW);
    }

    private void createBetweenEmptyBracesTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceOptions_initializer_list, "org.eclipse.cdt.core.formatter.insert_space_between_empty_braces_in_array_initializer", this.INITIALIZER_LIST_PREVIEW);
    }

    private InnerNode createClassTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_classes);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_classes_before_opening_brace_of_a_class, "org.eclipse.cdt.core.formatter.insert_space_before_opening_brace_in_type_declaration", this.CLASS_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_classes_before_colon_of_base_clause, "org.eclipse.cdt.core.formatter.insert_space_before_colon_in_base_clause", this.CLASS_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_classes_after_colon_of_base_clause, "org.eclipse.cdt.core.formatter.insert_space_after_colon_in_base_clause", this.CLASS_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_classes_before_comma_base_types, "org.eclipse.cdt.core.formatter.insert_space_before_comma_in_base_types", this.CLASS_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_classes_after_comma_base_types, "org.eclipse.cdt.core.formatter.insert_space_after_comma_in_base_types", this.CLASS_DECL_PREVIEW);
        return root;
    }

    private InnerNode createAssignmentTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_assignments);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_assignments_before_assignment_operator, "org.eclipse.cdt.core.formatter.insert_space_before_assignment_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_assignments_after_assignment_operator, "org.eclipse.cdt.core.formatter.insert_space_after_assignment_operator", this.OPERATOR_PREVIEW);
        return root;
    }

    private InnerNode createOperatorTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_operators);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_before_binary_operators, "org.eclipse.cdt.core.formatter.insert_space_before_binary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_after_binary_operators, "org.eclipse.cdt.core.formatter.insert_space_after_binary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_before_unary_operators, "org.eclipse.cdt.core.formatter.insert_space_before_unary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_after_unary_operators, "org.eclipse.cdt.core.formatter.insert_space_after_unary_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_before_prefix_operators, "org.eclipse.cdt.core.formatter.insert_space_before_prefix_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_after_prefix_operators, "org.eclipse.cdt.core.formatter.insert_space_after_prefix_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_before_postfix_operators, "org.eclipse.cdt.core.formatter.insert_space_before_postfix_operator", this.OPERATOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_operators_after_postfix_operators, "org.eclipse.cdt.core.formatter.insert_space_after_postfix_operator", this.OPERATOR_PREVIEW);
        return root;
    }

    private InnerNode createMethodDeclTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_methods);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_between_empty_parens, "org.eclipse.cdt.core.formatter.insert_space_between_empty_parens_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_brace, "org.eclipse.cdt.core.formatter.insert_space_before_opening_brace_in_method_declaration", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma_in_params, "org.eclipse.cdt.core.formatter.insert_space_before_comma_in_method_declaration_parameters", this.METHOD_DECL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma_in_params, "org.eclipse.cdt.core.formatter.insert_space_after_comma_in_method_declaration_parameters", this.METHOD_DECL_PREVIEW);
        return root;
    }

    private InnerNode createDeclaratorListTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_declarator_list);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_declarator_list_before_comma, "org.eclipse.cdt.core.formatter.insert_space_before_comma_in_declarator_list", this.DECLARATOR_LIST_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_declarator_list_after_comma, "org.eclipse.cdt.core.formatter.insert_space_after_comma_in_declarator_list", this.EXPRESSION_LIST_PREVIEW);
        return root;
    }

    private InnerNode createExpressionListTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_expression_list);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_expression_list_before_comma, "org.eclipse.cdt.core.formatter.insert_space_before_comma_in_expression_list", this.EXPRESSION_LIST_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_expression_list_after_comma, "org.eclipse.cdt.core.formatter.insert_space_after_comma_in_expression_list", this.EXPRESSION_LIST_PREVIEW);
        return root;
    }

    private InnerNode createInitializerListTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_initializer_list);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_brace, "org.eclipse.cdt.core.formatter.insert_space_before_opening_brace_in_array_initializer", this.INITIALIZER_LIST_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_brace, "org.eclipse.cdt.core.formatter.insert_space_after_opening_brace_in_array_initializer", this.INITIALIZER_LIST_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_brace, "org.eclipse.cdt.core.formatter.insert_space_before_closing_brace_in_array_initializer", this.INITIALIZER_LIST_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma, "org.eclipse.cdt.core.formatter.insert_space_before_comma_in_array_initializer", this.INITIALIZER_LIST_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma, "org.eclipse.cdt.core.formatter.insert_space_after_comma_in_array_initializer", this.INITIALIZER_LIST_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_between_empty_braces, "org.eclipse.cdt.core.formatter.insert_space_between_empty_braces_in_array_initializer", this.INITIALIZER_LIST_PREVIEW);
        return root;
    }

    private InnerNode createArrayTree(Map<String, String> workingValues, InnerNode parent) {
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_bracket, "org.eclipse.cdt.core.formatter.insert_space_before_opening_bracket", this.ARRAY_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_bracket, "org.eclipse.cdt.core.formatter.insert_space_after_opening_bracket", this.ARRAY_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_bracket, "org.eclipse.cdt.core.formatter.insert_space_before_closing_bracket", this.ARRAY_PREVIEW);
        WhiteSpaceOptions.createOption(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_between_empty_brackets, "org.eclipse.cdt.core.formatter.insert_space_between_empty_brackets", this.ARRAY_PREVIEW);
        return parent;
    }

    private InnerNode createFunctionCallTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_calls);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_method_invocation", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_method_invocation", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_method_invocation", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_between_empty_parens, "org.eclipse.cdt.core.formatter.insert_space_between_empty_parens_in_method_invocation", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_before_comma_in_method_args, "org.eclipse.cdt.core.formatter.insert_space_before_comma_in_method_invocation_arguments", this.METHOD_CALL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_calls_after_comma_in_method_args, "org.eclipse.cdt.core.formatter.insert_space_after_comma_in_method_invocation_arguments", this.METHOD_CALL_PREVIEW);
        return root;
    }

    private InnerNode createBlockTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_blocks);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_brace, "org.eclipse.cdt.core.formatter.insert_space_before_opening_brace_in_block", this.BLOCK_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_closing_brace, "org.eclipse.cdt.core.formatter.insert_space_after_closing_brace_in_block", this.BLOCK_PREVIEW);
        return root;
    }

    private InnerNode createSwitchStatementTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_switch);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_switch_before_case_colon, "org.eclipse.cdt.core.formatter.insert_space_before_colon_in_case", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_switch_before_default_colon, "org.eclipse.cdt.core.formatter.insert_space_before_colon_in_default", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_brace, "org.eclipse.cdt.core.formatter.insert_space_before_opening_brace_in_switch", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_switch", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_switch", this.SWITCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_switch", this.SWITCH_PREVIEW);
        return root;
    }

    private InnerNode createDoWhileTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_do);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_while", this.WHILE_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_while", this.WHILE_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_while", this.WHILE_PREVIEW);
        return root;
    }

    private InnerNode createTryStatementTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_try);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_catch", this.CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_catch", this.CATCH_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_catch", this.CATCH_PREVIEW);
        return root;
    }

    private InnerNode createIfStatementTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_if);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_if", this.IF_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_if", this.IF_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_if", this.IF_PREVIEW);
        return root;
    }

    private InnerNode createForStatementTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_for);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_semicolon, "org.eclipse.cdt.core.formatter.insert_space_before_semicolon_in_for", this.FOR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_semicolon, "org.eclipse.cdt.core.formatter.insert_space_after_semicolon_in_for", this.FOR_PREVIEW);
        return root;
    }

    private InnerNode createLabelTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_labels);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_colon, "org.eclipse.cdt.core.formatter.insert_space_before_colon_in_labeled_statement", this.LABEL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_colon, "org.eclipse.cdt.core.formatter.insert_space_after_colon_in_labeled_statement", this.LABEL_PREVIEW);
        return root;
    }

    private InnerNode createTemplateArgumentTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_template_arguments);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_angle_bracket, "org.eclipse.cdt.core.formatter.insert_space_before_opening_angle_bracket_in_template_arguments", this.TEMPLATES_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_angle_bracket, "org.eclipse.cdt.core.formatter.insert_space_after_opening_angle_bracket_in_template_arguments", this.TEMPLATES_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma, "org.eclipse.cdt.core.formatter.insert_space_before_comma_in_template_arguments", this.TEMPLATES_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma, "org.eclipse.cdt.core.formatter.insert_space_after_comma_in_template_arguments", this.TEMPLATES_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_angle_bracket, "org.eclipse.cdt.core.formatter.insert_space_before_closing_angle_bracket_in_template_arguments", this.TEMPLATES_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_closing_angle_bracket, "org.eclipse.cdt.core.formatter.insert_space_after_closing_angle_bracket_in_template_arguments", this.TEMPLATES_PREVIEW);
        return root;
    }

    private InnerNode createTemplateParameterTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_template_parameters);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_angle_bracket, "org.eclipse.cdt.core.formatter.insert_space_before_opening_angle_bracket_in_template_parameters", this.TEMPLATES_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_angle_bracket, "org.eclipse.cdt.core.formatter.insert_space_after_opening_angle_bracket_in_template_parameters", this.TEMPLATES_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_comma, "org.eclipse.cdt.core.formatter.insert_space_before_comma_in_template_parameters", this.TEMPLATES_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_comma, "org.eclipse.cdt.core.formatter.insert_space_after_comma_in_template_parameters", this.TEMPLATES_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_angle_bracket, "org.eclipse.cdt.core.formatter.insert_space_before_closing_angle_bracket_in_template_parameters", this.TEMPLATES_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_closing_angle_bracket, "org.eclipse.cdt.core.formatter.insert_space_after_closing_angle_bracket_in_template_parameters", this.TEMPLATES_PREVIEW);
        return root;
    }

    private InnerNode createConditionalTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_conditionals);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_question, "org.eclipse.cdt.core.formatter.insert_space_before_question_in_conditional", this.CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_question, "org.eclipse.cdt.core.formatter.insert_space_after_question_in_conditional", this.CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_colon, "org.eclipse.cdt.core.formatter.insert_space_before_colon_in_conditional", this.CONDITIONAL_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_colon, "org.eclipse.cdt.core.formatter.insert_space_after_colon_in_conditional", this.CONDITIONAL_PREVIEW);
        return root;
    }

    private InnerNode createTypecastTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_typecasts);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_cast", this.CAST_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_cast", this.CAST_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_closing_paren, "org.eclipse.cdt.core.formatter.insert_space_after_closing_paren_in_cast", this.CAST_PREVIEW);
        return root;
    }

    private InnerNode createParenthesizedExpressionTree(Map<String, String> workingValues, InnerNode parent) {
        InnerNode root = new InnerNode(parent, workingValues, FormatterMessages.WhiteSpaceTabPage_parenexpr);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_opening_paren, "org.eclipse.cdt.core.formatter.insert_space_before_opening_paren_in_parenthesized_expression", this.PAREN_EXPR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_after_opening_paren, "org.eclipse.cdt.core.formatter.insert_space_after_opening_paren_in_parenthesized_expression", this.PAREN_EXPR_PREVIEW);
        WhiteSpaceOptions.createOption(root, workingValues, FormatterMessages.WhiteSpaceTabPage_before_closing_paren, "org.eclipse.cdt.core.formatter.insert_space_before_closing_paren_in_parenthesized_expression", this.PAREN_EXPR_PREVIEW);
        return root;
    }

    private static InnerNode createChild(InnerNode root, Map<String, String> workingValues, String message) {
        return new InnerNode(root, workingValues, message);
    }

    private static OptionNode createOption(InnerNode root, Map<String, String> workingValues, String message, String key, SnippetPreview.PreviewSnippet snippet) {
        return new OptionNode(root, workingValues, message, key, snippet);
    }

    public static void makeIndexForNodes(List<? extends Node> tree, List<Node> flatList) {
        for (Node node : tree) {
            node.index = flatList.size();
            flatList.add(node);
            WhiteSpaceOptions.makeIndexForNodes(node.getChildren(), flatList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InnerNode
    extends Node {
        public InnerNode(InnerNode parent, Map<String, String> workingValues, String messageKey) {
            super(parent, workingValues, messageKey);
        }

        @Override
        public void setChecked(boolean checked) {
            for (Object element : this.fChildren) {
                ((Node)element).setChecked(checked);
            }
        }

        public void add(Node child) {
            this.fChildren.add(child);
        }

        @Override
        public List<SnippetPreview.PreviewSnippet> getSnippets() {
            ArrayList<SnippetPreview.PreviewSnippet> snippets = new ArrayList<SnippetPreview.PreviewSnippet>(this.fChildren.size());
            for (Object element : this.fChildren) {
                List<SnippetPreview.PreviewSnippet> childSnippets = ((Node)element).getSnippets();
                for (SnippetPreview.PreviewSnippet snippet : childSnippets) {
                    if (snippets.contains(snippet)) continue;
                    snippets.add(snippet);
                }
            }
            return snippets;
        }

        @Override
        public void getCheckedLeafs(List<OptionNode> list) {
            for (Node element : this.fChildren) {
                element.getCheckedLeafs(list);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Node {
        private final InnerNode fParent;
        private final String fName;
        public int index;
        protected final Map<String, String> fWorkingValues;
        protected final ArrayList<Node> fChildren;

        public Node(InnerNode parent, Map<String, String> workingValues, String message) {
            if (workingValues == null || message == null) {
                throw new IllegalArgumentException();
            }
            this.fParent = parent;
            this.fWorkingValues = workingValues;
            this.fName = message;
            this.fChildren = new ArrayList();
            if (this.fParent != null) {
                this.fParent.add(this);
            }
        }

        public abstract void setChecked(boolean var1);

        public boolean hasChildren() {
            return !this.fChildren.isEmpty();
        }

        public List<Node> getChildren() {
            return Collections.unmodifiableList(this.fChildren);
        }

        public InnerNode getParent() {
            return this.fParent;
        }

        public final String toString() {
            return this.fName;
        }

        public abstract List<SnippetPreview.PreviewSnippet> getSnippets();

        public abstract void getCheckedLeafs(List<OptionNode> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OptionNode
    extends Node {
        private final String fKey;
        private final ArrayList<SnippetPreview.PreviewSnippet> fSnippets;

        public OptionNode(InnerNode parent, Map<String, String> workingValues, String messageKey, String key, SnippetPreview.PreviewSnippet snippet) {
            super(parent, workingValues, messageKey);
            this.fKey = key;
            this.fSnippets = new ArrayList(1);
            this.fSnippets.add(snippet);
        }

        @Override
        public void setChecked(boolean checked) {
            this.fWorkingValues.put(this.fKey, checked ? "insert" : "do not insert");
        }

        public boolean getChecked() {
            return "insert".equals(this.fWorkingValues.get(this.fKey));
        }

        @Override
        public List<SnippetPreview.PreviewSnippet> getSnippets() {
            return this.fSnippets;
        }

        @Override
        public void getCheckedLeafs(List<OptionNode> list) {
            if (this.getChecked()) {
                list.add(this);
            }
        }
    }
}

