/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.implementmethod;

import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateParameter;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompoundStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTemplateDeclaration;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.InsertLocation;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.Messages;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.MethodDefinitionInsertLocationFinder;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ParameterHandler;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ParameterInfo;
import org.eclipse.cdt.internal.ui.refactoring.utils.DefinitionFinder;
import org.eclipse.cdt.internal.ui.refactoring.utils.NameHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.NodeHelper;
import org.eclipse.cdt.internal.ui.refactoring.utils.SelectionHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class ImplementMethodRefactoring
extends CRefactoring {
    private IASTSimpleDeclaration methodDeclaration;
    private InsertLocation insertLocation;
    private ParameterHandler parameterHandler = new ParameterHandler(this);
    private IASTDeclaration createdMethodDefinition;
    private CPPASTFunctionDeclarator createdMethodDeclarator;

    public ImplementMethodRefactoring(IFile file, ISelection selection, ICElement element) {
        super(file, selection, element);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        super.checkInitialConditions((IProgressMonitor)sm.newChild(6));
        this.methodDeclaration = SelectionHelper.findFirstSelectedDeclaration(this.region, this.unit);
        if (!NodeHelper.isMethodDeclaration(this.methodDeclaration)) {
            this.initStatus.addFatalError(Messages.ImplementMethodRefactoring_NoMethodSelected);
            return this.initStatus;
        }
        if (this.isProgressMonitorCanceld((IProgressMonitor)sm, this.initStatus)) {
            return this.initStatus;
        }
        sm.worked(1);
        if (DefinitionFinder.getDefinition(this.methodDeclaration, this.file) != null) {
            this.initStatus.addFatalError(Messages.ImplementMethodRefactoring_MethodHasImpl);
            return this.initStatus;
        }
        if (this.isProgressMonitorCanceld((IProgressMonitor)sm, this.initStatus)) {
            return this.initStatus;
        }
        sm.worked(1);
        sm.done();
        this.parameterHandler.initArgumentNames();
        sm.worked(1);
        sm.done();
        this.findInsertLocation();
        sm.worked(1);
        sm.done();
        return this.initStatus;
    }

    protected void collectModifications(IProgressMonitor pm, ModificationCollector collector) throws CoreException, OperationCanceledException {
        IASTTranslationUnit targetUnit = this.insertLocation.getTargetTranslationUnit();
        IASTNode parent = this.insertLocation.getPartenOfNodeToInsertBefore();
        this.createFunctionDefinition(targetUnit);
        IASTNode nodeToInsertBefore = this.insertLocation.getNodeToInsertBefore();
        ASTRewrite translationUnitRewrite = collector.rewriterForTranslationUnit(targetUnit);
        ASTRewrite methodRewrite = translationUnitRewrite.insertBefore(parent, nodeToInsertBefore, (IASTNode)this.createdMethodDefinition, null);
        this.createParameterModifications(methodRewrite);
    }

    private void createParameterModifications(ASTRewrite methodRewrite) {
        for (ParameterInfo actParameterInfo : this.parameterHandler.getParameterInfos()) {
            ASTRewrite parameterRewrite = methodRewrite.insertBefore((IASTNode)this.createdMethodDeclarator, null, (IASTNode)actParameterInfo.getParameter(), null);
            this.createNewNameInsertModification(actParameterInfo, parameterRewrite);
            this.createRemoveDefaultValueModification(actParameterInfo, parameterRewrite);
        }
    }

    private void createRemoveDefaultValueModification(ParameterInfo parameterInfo, ASTRewrite parameterRewrite) {
        if (parameterInfo.hasDefaultValue()) {
            parameterRewrite.remove(parameterInfo.getDefaultValueNode(), null);
        }
    }

    private void createNewNameInsertModification(ParameterInfo parameterInfo, ASTRewrite parameterRewrite) {
        if (parameterInfo.hasNewName()) {
            IASTName insertNode = parameterInfo.getNewNameNode();
            IASTName replaceNode = parameterInfo.getNameNode();
            parameterRewrite.replace((IASTNode)replaceNode, (IASTNode)insertNode, null);
        }
    }

    private void findInsertLocation() throws CoreException {
        this.insertLocation = MethodDefinitionInsertLocationFinder.find(this.methodDeclaration.getFileLocation(), this.methodDeclaration.getParent(), this.file);
        if (!this.insertLocation.hasFile() || NodeHelper.isContainedInTemplateDeclaration((IASTNode)this.methodDeclaration)) {
            this.insertLocation.setInsertFile(this.file);
            this.insertLocation.setNodeToInsertAfter(NodeHelper.findTopLevelParent((IASTNode)this.methodDeclaration));
        }
    }

    private void createFunctionDefinition(IASTTranslationUnit unit) {
        this.createFunctionDefinition(this.methodDeclaration.getDeclSpecifier(), (ICPPASTFunctionDeclarator)this.methodDeclaration.getDeclarators()[0], this.methodDeclaration.getParent(), unit);
    }

    public IASTDeclaration createFunctionDefinition() {
        this.createFunctionDefinition(this.unit);
        return this.createdMethodDefinition;
    }

    private void createFunctionDefinition(IASTDeclSpecifier declSpecifier, ICPPASTFunctionDeclarator functionDeclarator, IASTNode declarationParent, IASTTranslationUnit unit) {
        String currentFileName;
        CPPASTFunctionDefinition func = new CPPASTFunctionDefinition();
        func.setParent((IASTNode)unit);
        if (declSpecifier instanceof ICPPASTDeclSpecifier) {
            ((ICPPASTDeclSpecifier)declSpecifier).setVirtual(false);
        }
        if (Path.fromOSString((String)(currentFileName = this.methodDeclaration.getNodeLocations()[0].asFileLocation().getFileName())).equals((Object)this.insertLocation.getInsertFile().getLocation())) {
            declSpecifier.setInline(true);
        }
        if (declSpecifier.getStorageClass() == 3) {
            declSpecifier.setStorageClass(0);
        }
        func.setDeclSpecifier(declSpecifier);
        ICPPASTQualifiedName qname = this.createQualifiedNameFor((IASTFunctionDeclarator)functionDeclarator, declarationParent);
        this.createdMethodDeclarator = new CPPASTFunctionDeclarator();
        this.createdMethodDeclarator.setName((IASTName)qname);
        this.createdMethodDeclarator.setConst(functionDeclarator.isConst());
        func.setDeclarator((IASTFunctionDeclarator)this.createdMethodDeclarator);
        func.setBody((IASTStatement)new CPPASTCompoundStatement());
        if (NodeHelper.isContainedInTemplateDeclaration(declarationParent)) {
            CPPASTTemplateDeclaration templateDeclaration = new CPPASTTemplateDeclaration();
            templateDeclaration.setParent((IASTNode)unit);
            ICPPASTTemplateParameter[] iCPPASTTemplateParameterArray = ((ICPPASTTemplateDeclaration)declarationParent.getParent().getParent()).getTemplateParameters();
            int n = iCPPASTTemplateParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTTemplateParameter templateParameter = iCPPASTTemplateParameterArray[n2];
                templateDeclaration.addTemplateParamter(templateParameter);
                ++n2;
            }
            templateDeclaration.setDeclaration((IASTDeclaration)func);
            this.createdMethodDefinition = templateDeclaration;
            return;
        }
        this.createdMethodDefinition = func;
    }

    private ICPPASTQualifiedName createQualifiedNameFor(IASTFunctionDeclarator functionDeclarator, IASTNode declarationParent) {
        int insertOffset = this.insertLocation.getInsertPosition();
        return NameHelper.createQualifiedNameFor(functionDeclarator.getName(), this.file, this.region.getOffset(), this.insertLocation.getInsertFile(), insertOffset);
    }

    public IASTSimpleDeclaration getMethodDeclaration() {
        return this.methodDeclaration;
    }

    public ParameterHandler getParameterHandler() {
        return this.parameterHandler;
    }
}

