/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.implementmethod;

import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.internal.ui.refactoring.utils.TranslationUnitHelper;
import org.eclipse.core.resources.IFile;

public class InsertLocation {
    private IFile insertFile;
    private IASTNode nodeToInsertAfter;
    private IASTNode nodeToInsertBefore;
    private IASTTranslationUnit targetTranslationUnit;

    public boolean hasAnyNode() {
        return this.nodeToInsertAfter != null || this.nodeToInsertBefore != null;
    }

    public IASTNode getNodeToInsertBefore() {
        return this.nodeToInsertBefore;
    }

    public IASTNode getPartenOfNodeToInsertBefore() {
        IASTNode affectedNode = this.getAffectedNode();
        return affectedNode != null ? affectedNode.getParent() : this.getTargetTranslationUnit();
    }

    private IASTNode getAffectedNode() {
        IASTNode concernedNode = this.nodeToInsertBefore != null ? this.nodeToInsertBefore : this.nodeToInsertAfter;
        return concernedNode;
    }

    public IFile getInsertFile() {
        return this.insertFile;
    }

    public void setInsertFile(IFile insertFile) {
        this.insertFile = insertFile;
    }

    public void setNodeToInsertAfter(IASTNode nodeToInsertAfter) {
        this.nodeToInsertAfter = nodeToInsertAfter;
    }

    public void setNodeToInsertBefore(IASTNode nodeToInsertBefore) {
        this.nodeToInsertBefore = nodeToInsertBefore;
    }

    public boolean hasFile() {
        return this.insertFile != null;
    }

    public IASTTranslationUnit getTargetTranslationUnit() {
        if (this.targetTranslationUnit == null) {
            this.loadTargetTranslationUnit();
        }
        return this.targetTranslationUnit;
    }

    private void loadTargetTranslationUnit() {
        IASTNode affectedNode = this.getAffectedNode();
        if (affectedNode != null) {
            this.targetTranslationUnit = affectedNode.getTranslationUnit();
        } else if (this.hasFile()) {
            this.targetTranslationUnit = TranslationUnitHelper.loadTranslationUnit(this.insertFile);
        }
    }

    public int getInsertPosition() {
        if (this.nodeToInsertBefore != null) {
            return this.nodeToInsertBefore.getFileLocation().getNodeOffset();
        }
        if (this.nodeToInsertAfter != null) {
            return this.nodeToInsertAfter.getFileLocation().getNodeOffset() + this.nodeToInsertAfter.getFileLocation().getNodeLength();
        }
        return 0;
    }
}

