/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRefactoringArgument;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameProcessor;
import org.eclipse.cdt.internal.ui.refactoring.rename.CRenameTypeProcessor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class CRenameClassProcessor
extends CRenameTypeProcessor {
    public CRenameClassProcessor(CRenameProcessor processor, String kind) {
        super(processor, kind);
    }

    protected IBinding[] getBindingsToBeRenamed(RefactoringStatus status) {
        CRefactoringArgument argument = this.getArgument();
        IBinding binding = argument.getBinding();
        ArrayList<IBinding> bindings = new ArrayList<IBinding>();
        if (binding != null) {
            bindings.add(binding);
        }
        if (binding instanceof ICPPClassType) {
            ICPPClassType ctype = (ICPPClassType)binding;
            try {
                IBinding[] dtors;
                IScope scope;
                ICPPConstructor[] ctors = ctype.getConstructors();
                if (ctors != null) {
                    bindings.addAll((Collection)Arrays.asList(ctors));
                }
                if ((scope = ctype.getCompositeScope()) != null && (dtors = scope.find("~" + argument.getName())) != null) {
                    bindings.addAll((Collection)Arrays.asList(dtors));
                }
            }
            catch (DOMException e) {
                this.getAstManager().handleDOMException(argument.getTranslationUnit(), e, status);
            }
        }
        return bindings.toArray(new IBinding[bindings.size()]);
    }
}

