/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.ui.IPropertyChangeParticipant;
import org.eclipse.cdt.ui.text.ICTokenScanner;
import org.eclipse.cdt.ui.text.ITokenStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.util.PropertyChangeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCScanner
extends BufferedRuleBasedScanner
implements ICTokenScanner {
    private List<IPropertyChangeParticipant> pcps;
    protected final ITokenStore fTokenStore;

    public AbstractCScanner(ITokenStore tokenStore, int size) {
        this(tokenStore);
        this.setBufferSize(size);
    }

    public AbstractCScanner(ITokenStore tokenStore) {
        this.fTokenStore = tokenStore;
        this.pcps = new ArrayList<IPropertyChangeParticipant>();
    }

    protected void addPropertyChangeParticipant(IPropertyChangeParticipant participant) {
        this.pcps.add(participant);
    }

    public final void setRules(List<IRule> rules) {
        if (rules == null) {
            this.setRules(null);
        } else {
            IRule[] result = new IRule[rules.size()];
            rules.toArray(result);
            this.setRules(result);
        }
    }

    public IToken nextToken() {
        this.fTokenStore.ensureTokensInitialised();
        return super.nextToken();
    }

    public IToken getToken(String key) {
        return this.fTokenStore.getToken(key);
    }

    public IPreferenceStore getPreferenceStore() {
        return this.fTokenStore.getPreferenceStore();
    }

    @Override
    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.fTokenStore.affectsBehavior(event)) {
            this.fTokenStore.adaptToPreferenceChange(event);
        }
        for (IPropertyChangeParticipant propertyChangeParticipant : this.pcps) {
            propertyChangeParticipant.adaptToPreferenceChange(event);
        }
    }

    @Override
    public boolean affectsBehavior(PropertyChangeEvent event) {
        boolean result = this.fTokenStore.affectsBehavior(event);
        Iterator<IPropertyChangeParticipant> i = this.pcps.iterator();
        while (!result && i.hasNext()) {
            result |= i.next().affectsBehavior(event);
        }
        return result;
    }
}

