/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractCompareViewerInformationControl
extends PopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
IInformationControlExtension3,
IInformationControlExtension4,
IInformationControlExtension5,
DisposeListener {
    private final int fStyle;
    private CompareViewerControl fCompareViewerControl;
    private ICompareInput fCompareInput;
    private Color fBackgroundColor;
    private boolean fIsSystemBackgroundColor;
    private int fMaxWidth;
    private int fMaxHeight;
    private boolean fUseDefaultBounds;

    public AbstractCompareViewerInformationControl(Shell parent, int shellStyle, int textStyle, boolean takeFocus, boolean showViewMenu, boolean persistBounds) {
        super(parent, shellStyle | 0x4000, takeFocus, persistBounds, persistBounds, showViewMenu, false, null, null);
        this.fStyle = textStyle & 0xFFFFFCFF;
        if (this.hasHeader()) {
            this.setTitleText("");
        }
        this.setInfoText("");
        this.create();
    }

    private void initializeColors() {
        RGB bgRGB = this.getHoverBackgroundColorRGB();
        if (bgRGB != null) {
            this.fBackgroundColor = new Color((Device)this.getShell().getDisplay(), bgRGB);
            this.fIsSystemBackgroundColor = false;
        } else {
            this.fBackgroundColor = this.getShell().getDisplay().getSystemColor(29);
            this.fIsSystemBackgroundColor = true;
        }
    }

    private RGB getHoverBackgroundColorRGB() {
        IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("sourceHoverBackgroundColor.SystemDefault") ? null : PreferenceConverter.getColor((IPreferenceStore)store, (String)"sourceHoverBackgroundColor");
    }

    protected Control createContents(Composite parent) {
        this.initializeColors();
        Control contents = super.createContents(parent);
        this.applyBackgroundColor(this.fBackgroundColor, contents);
        return contents;
    }

    protected void applyBackgroundColor(Color color, Control control) {
        super.applyBackgroundColor(this.fBackgroundColor, control);
    }

    protected Control createDialogArea(Composite parent) {
        CompareConfiguration compareConfig = new CompareConfiguration();
        compareConfig.setLeftEditable(false);
        compareConfig.setRightEditable(false);
        CompareViewerControl control = this.fCompareViewerControl = this.createCompareViewerControl(parent, this.fStyle, compareConfig);
        control.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    AbstractCompareViewerInformationControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.addDisposeListener(this);
        return this.fCompareViewerControl;
    }

    protected CompareViewerControl createCompareViewerControl(Composite parent, int style, CompareConfiguration compareConfig) {
        CompareViewerControl compareViewer = new CompareViewerControl(parent, style, compareConfig);
        return compareViewer;
    }

    protected Viewer createContentViewer(Composite parent, ICompareInput input, CompareConfiguration cc) {
        return CompareUI.findContentViewer(null, (ICompareInput)input, (Composite)parent, (CompareConfiguration)cc);
    }

    protected String getId() {
        return null;
    }

    protected final CompareViewerControl getCompareViewer() {
        return this.fCompareViewerControl;
    }

    protected final CompareConfiguration getCompareConfiguration() {
        return this.fCompareViewerControl.getCompareConfiguration();
    }

    protected boolean hasHeader() {
        return false;
    }

    public void setInformation(String content) {
    }

    public void setInput(Object input) {
        if (input instanceof ICompareInput) {
            this.fCompareInput = (ICompareInput)input;
            if (this.fCompareViewerControl != null) {
                this.fCompareViewerControl.setInput(this.fCompareInput);
            }
        } else if (!(input instanceof String)) {
            this.fCompareInput = null;
            if (this.fCompareViewerControl != null) {
                this.fCompareViewerControl.setInput(this.fCompareInput);
            }
        }
    }

    protected void fillViewMenu(IMenuManager viewMenu) {
    }

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        super.fillDialogMenu(dialogMenu);
        this.fillViewMenu(dialogMenu);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public final void dispose() {
        if (!this.fIsSystemBackgroundColor) {
            this.fBackgroundColor.dispose();
        }
        this.close();
    }

    protected Point getInitialLocation(Point initialSize) {
        if (!this.restoresSize()) {
            Point size = new Point(400, 400);
            Rectangle parentBounds = this.getParentShell().getBounds();
            int x = parentBounds.x + parentBounds.width / 2 - size.x / 2;
            int y = parentBounds.y + parentBounds.height / 2 - size.y / 2;
            return new Point(x, y);
        }
        return super.getInitialLocation(initialSize);
    }

    public void widgetDisposed(DisposeEvent event) {
        this.fCompareViewerControl = null;
    }

    public boolean hasContents() {
        return this.fCompareViewerControl != null && this.fCompareInput != null;
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        this.fMaxWidth = maxWidth;
        this.fMaxHeight = maxHeight;
    }

    public Point computeSizeHint() {
        int x = -1;
        int y = -1;
        Point size = this.getShell().computeSize(x, y);
        if (size.x > this.fMaxWidth) {
            x = this.fMaxWidth;
        }
        if (size.y > this.fMaxHeight) {
            y = this.fMaxHeight;
        }
        if (x != -1 || y != -1) {
            size = this.getShell().computeSize(x, y, false);
        }
        return size;
    }

    public void setLocation(Point location) {
        if (!this.restoresLocation() || this.getDialogSettings() == null || this.fUseDefaultBounds) {
            this.getShell().setLocation(location);
        }
    }

    public void setSize(int width, int height) {
        if (!this.restoresSize() || this.getDialogSettings() == null || this.fUseDefaultBounds) {
            this.getShell().setSize(width, height);
        }
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.applyForegroundColor(foreground, this.getContents());
    }

    public void setBackgroundColor(Color background) {
        this.applyBackgroundColor(background, this.getContents());
    }

    protected Control getFocusControl() {
        return this.fCompareViewerControl;
    }

    public boolean isFocusControl() {
        return this.fCompareViewerControl != null;
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.fCompareViewerControl.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.getShell().addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getShell().removeFocusListener(listener);
    }

    protected IDialogSettings getDialogSettings() {
        String sectionName = this.getId();
        if (sectionName == null) {
            return null;
        }
        IDialogSettings settings = CUIPlugin.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            this.fUseDefaultBounds = true;
            settings = CUIPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    public Rectangle computeTrim() {
        Rectangle trim = this.getShell().computeTrim(0, 0, 0, 0);
        this.addInternalTrim(trim);
        return trim;
    }

    private void addInternalTrim(Rectangle trim) {
        Rectangle textTrim = this.fCompareViewerControl.computeTrim(0, 0, 0, 0);
        trim.x += textTrim.x;
        trim.y += textTrim.y;
        trim.width += textTrim.width;
        trim.height += textTrim.height;
    }

    public Rectangle getBounds() {
        return this.getShell().getBounds();
    }

    public boolean restoresLocation() {
        return this.getPersistLocation();
    }

    public boolean restoresSize() {
        return this.getPersistSize();
    }

    public void setStatusText(String statusFieldText) {
        this.setInfoText(statusFieldText);
    }

    public Point computeSizeConstraints(int widthInChars, int heightInChars) {
        Font font = JFaceResources.getFont((String)"org.eclipse.cdt.ui.editors.textfont");
        GC gc = new GC((Drawable)this.fCompareViewerControl);
        gc.setFont(font);
        int width = gc.getFontMetrics().getAverageCharWidth();
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        return new Point(widthInChars * width, heightInChars * height);
    }

    public boolean containsControl(Control control) {
        do {
            if (control == this.getShell()) {
                return true;
            }
            if (!(control instanceof Shell)) continue;
            return false;
        } while ((control = control.getParent()) != null);
        return false;
    }

    public boolean isVisible() {
        Shell shell = this.getShell();
        return shell != null && !shell.isDisposed() && shell.isVisible();
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return null;
    }

    protected class CompareViewerControl
    extends ViewForm {
        private CompareConfiguration fCompareConfiguration;
        private Viewer fViewer;

        public CompareViewerControl(Composite parent, int styles, CompareConfiguration cc) {
            super(parent, styles & 0xFFFFF7FF);
            this.verticalSpacing = 0;
            this.fCompareConfiguration = cc;
        }

        public CompareConfiguration getCompareConfiguration() {
            return this.fCompareConfiguration;
        }

        public void setInput(ICompareInput input) {
            if (this.fViewer == null) {
                this.fViewer = AbstractCompareViewerInformationControl.this.createContentViewer((Composite)this, input, this.fCompareConfiguration);
                AbstractCompareViewerInformationControl.this.applyBackgroundColor(AbstractCompareViewerInformationControl.this.fBackgroundColor, this.fViewer.getControl());
                this.setContent(this.fViewer.getControl());
            }
            this.fViewer.setInput((Object)input);
        }
    }
}

