/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.ui.editor.CSourceViewer;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.SimpleCSourceViewerConfiguration;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSourceViewerInformationControl
extends PopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
IInformationControlExtension3,
IInformationControlExtension4,
IInformationControlExtension5,
DisposeListener {
    private int fTextStyle;
    private ISourceViewer fSourceViewer;
    private Color fBackgroundColor;
    private boolean fIsSystemBackgroundColor;
    private int fMaxWidth;
    private int fMaxHeight;
    private List<Control> fColorExclusionControls = new ArrayList<Control>();
    private Font fTextFont;
    private StyledText fText;

    public AbstractSourceViewerInformationControl(Shell parent, int shellStyle, int textStyle, boolean takeFocus, boolean showViewMenu, boolean persistBounds, String statusFieldText) {
        super(parent, shellStyle, takeFocus, persistBounds, persistBounds, showViewMenu, false, null, null);
        this.fTextStyle = textStyle;
        if (this.hasHeader()) {
            this.setTitleText("");
        }
        if (statusFieldText != null) {
            this.setInfoText(statusFieldText);
        }
        this.create();
    }

    private void initializeColors() {
        RGB bgRGB = this.getHoverBackgroundColorRGB();
        if (bgRGB != null) {
            this.fBackgroundColor = new Color((Device)this.getShell().getDisplay(), bgRGB);
            this.fIsSystemBackgroundColor = false;
        } else {
            this.fBackgroundColor = this.getShell().getDisplay().getSystemColor(29);
            this.fIsSystemBackgroundColor = true;
        }
    }

    private RGB getHoverBackgroundColorRGB() {
        IPreferenceStore store = CUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("sourceHoverBackgroundColor.SystemDefault") ? null : PreferenceConverter.getColor((IPreferenceStore)store, (String)"sourceHoverBackgroundColor");
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        for (Control ctrl : this.fColorExclusionControls) {
            ctrl.setBackground(this.fBackgroundColor);
        }
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        this.fSourceViewer = this.createSourceViewer(parent, this.fTextStyle);
        StyledText text = this.fSourceViewer.getTextWidget();
        text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    AbstractSourceViewerInformationControl.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.addDisposeListener(this);
        return ((Viewer)this.fSourceViewer).getControl();
    }

    protected final ISourceViewer createSourceViewer(Composite parent, int style) {
        IPreferenceStore store = CUIPlugin.getDefault().getCombinedPreferenceStore();
        CSourceViewer sourceViewer = new CSourceViewer(parent, null, null, false, style, store);
        CTextTools tools = CUIPlugin.getDefault().getTextTools();
        sourceViewer.configure((SourceViewerConfiguration)new SimpleCSourceViewerConfiguration(tools.getColorManager(), store, null, "___c_partitioning", false));
        sourceViewer.setEditable(false);
        this.fText = sourceViewer.getTextWidget();
        GridData gd = new GridData(1809);
        this.fText.setLayoutData((Object)gd);
        this.initializeColors();
        this.fText.setForeground(parent.getDisplay().getSystemColor(28));
        this.fText.setBackground(this.fBackgroundColor);
        this.fColorExclusionControls.add((Control)this.fText);
        this.fTextFont = JFaceResources.getFont((String)"org.eclipse.cdt.ui.editors.textfont");
        this.fText.setFont(this.fTextFont);
        return sourceViewer;
    }

    protected Control createInfoTextArea(Composite parent) {
        Control infoText = super.createInfoTextArea(parent);
        this.fColorExclusionControls.add(infoText);
        return infoText;
    }

    protected Control createTitleControl(Composite parent) {
        Control titleText = super.createTitleControl(parent);
        this.fColorExclusionControls.add(titleText);
        return titleText;
    }

    protected List<Control> getBackgroundColorExclusions() {
        List exclusions = super.getBackgroundColorExclusions();
        exclusions.addAll(this.fColorExclusionControls);
        return exclusions;
    }

    protected List<Control> getForegroundColorExclusions() {
        List exclusions = super.getForegroundColorExclusions();
        exclusions.addAll(this.fColorExclusionControls);
        return exclusions;
    }

    protected String getId() {
        return null;
    }

    protected final ISourceViewer getSourceViewer() {
        return this.fSourceViewer;
    }

    protected boolean hasHeader() {
        return false;
    }

    public void setInformation(String content) {
        if (content == null) {
            this.fSourceViewer.setDocument(null);
            return;
        }
        Document doc = new Document(content);
        CUIPlugin.getDefault().getTextTools().setupCDocument((IDocument)doc);
        this.fSourceViewer.setDocument((IDocument)doc);
    }

    public void setInput(Object input) {
        if (input instanceof String) {
            this.setInformation((String)input);
        } else {
            this.setInformation(null);
        }
    }

    protected void fillViewMenu(IMenuManager viewMenu) {
    }

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        super.fillDialogMenu(dialogMenu);
        this.fillViewMenu(dialogMenu);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public final void dispose() {
        if (!this.fIsSystemBackgroundColor) {
            this.fBackgroundColor.dispose();
        }
        this.close();
    }

    protected Point getInitialLocation(Point initialSize) {
        if (!this.restoresLocation()) {
            Point size = new Point(400, 400);
            Rectangle parentBounds = this.getParentShell().getBounds();
            int x = parentBounds.x + parentBounds.width / 2 - size.x / 2;
            int y = parentBounds.y + parentBounds.height / 2 - size.y / 2;
            return new Point(x, y);
        }
        return super.getInitialLocation(initialSize);
    }

    public void widgetDisposed(DisposeEvent event) {
        this.fSourceViewer = null;
    }

    public boolean hasContents() {
        return this.fSourceViewer != null && this.fSourceViewer.getDocument() != null;
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        this.fMaxWidth = maxWidth;
        this.fMaxHeight = maxHeight;
    }

    public Point computeSizeHint() {
        int x = -1;
        int y = -1;
        Point size = this.getShell().computeSize(x, y);
        if (size.x > this.fMaxWidth) {
            x = this.fMaxWidth;
        }
        if (size.y > this.fMaxHeight) {
            y = this.fMaxHeight;
        }
        if (x != -1 || y != -1) {
            size = this.getShell().computeSize(x, y, false);
        }
        return size;
    }

    public void setLocation(Point location) {
        if (!this.restoresLocation() || this.getDialogSettings() == null) {
            this.getShell().setLocation(location);
        }
    }

    public void setSize(int width, int height) {
        if (!this.restoresSize() || this.getDialogSettings() == null) {
            this.getShell().setSize(width, height);
        }
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.applyForegroundColor(foreground, this.getContents());
    }

    public void setBackgroundColor(Color background) {
        this.applyBackgroundColor(background, this.getContents());
    }

    protected Control getFocusControl() {
        return this.fSourceViewer.getTextWidget();
    }

    public boolean isFocusControl() {
        return this.fSourceViewer.getTextWidget().isFocusControl();
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.fSourceViewer.getTextWidget().setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.getShell().addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getShell().removeFocusListener(listener);
    }

    protected IDialogSettings getDialogSettings() {
        String sectionName = this.getId();
        if (sectionName == null) {
            return null;
        }
        IDialogSettings settings = CUIPlugin.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = CUIPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    public Rectangle computeTrim() {
        return this.getShell().computeTrim(0, 0, 0, 0);
    }

    public Rectangle getBounds() {
        return this.getShell().getBounds();
    }

    public boolean restoresLocation() {
        return this.getPersistLocation();
    }

    public boolean restoresSize() {
        return this.getPersistSize();
    }

    public void setStatusText(String statusFieldText) {
        this.setInfoText(statusFieldText);
    }

    public Point computeSizeConstraints(int widthInChars, int heightInChars) {
        GC gc = new GC((Drawable)this.fText);
        gc.setFont(this.fTextFont);
        int width = gc.getFontMetrics().getAverageCharWidth();
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        return new Point(widthInChars * width, heightInChars * height);
    }

    public boolean containsControl(Control control) {
        do {
            if (control == this.getShell()) {
                return true;
            }
            if (!(control instanceof Shell)) continue;
            return false;
        } while ((control = control.getParent()) != null);
        return false;
    }

    public boolean isVisible() {
        Shell shell = this.getShell();
        return shell != null && !shell.isDisposed() && shell.isVisible();
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return null;
    }
}

