/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.internal.ui.text.CHelpBookDescriptor;
import org.eclipse.cdt.internal.ui.text.CHelpProviderDescriptor;
import org.eclipse.cdt.ui.ICHelpBook;
import org.eclipse.cdt.ui.ICHelpProvider;
import org.eclipse.cdt.ui.ICHelpResourceDescriptor;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CHelpSettings {
    public static final String CONTRIBUTION_EXTENSION = "CHelpProvider";
    private static final String ELEMENT_PROJECT = "project";
    private static final String ATTRIBUTE_NAME = "name";
    private IProject fProject;
    private static IConfigurationElement[] fConfigElements = null;
    private CHelpProviderDescriptor[] fProviderDescriptors = null;

    public CHelpSettings(IProject project) {
        this(project, null);
    }

    public CHelpSettings(IProject project, Element parentElement) {
        this.fProject = project;
        if (parentElement == null) {
            return;
        }
        Element projectElement = this.getProjectElement(parentElement);
        if (projectElement == null) {
            return;
        }
        this.getCHelpProviderDescriptors(projectElement);
    }

    private Element getProjectElement(Element parentElement) {
        NodeList nodes = parentElement.getElementsByTagName(ELEMENT_PROJECT);
        int i = 0;
        while (i < nodes.getLength()) {
            Element curProject = (Element)nodes.item(i);
            if (this.getProject().getName().equals(curProject.getAttribute(ATTRIBUTE_NAME))) {
                return curProject;
            }
            ++i;
        }
        return null;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public CHelpProviderDescriptor[] getCHelpProviderDescriptors(Element projectElement) {
        if (this.fProviderDescriptors == null || projectElement != null) {
            IConfigurationElement[] congifElements = CHelpSettings.getConfigElements();
            this.fProviderDescriptors = new CHelpProviderDescriptor[congifElements.length];
            int i = 0;
            while (i < congifElements.length) {
                this.fProviderDescriptors[i] = new CHelpProviderDescriptor(this.fProject, congifElements[i], projectElement);
                ++i;
            }
        }
        return this.fProviderDescriptors;
    }

    public CHelpProviderDescriptor[] getCHelpProviderDescriptors() {
        return this.getCHelpProviderDescriptors(null);
    }

    public CHelpBookDescriptor[] getCHelpBookDescriptors() {
        CHelpProviderDescriptor[] providerDescriptors = this.getCHelpProviderDescriptors();
        if (providerDescriptors.length == 0) {
            return new CHelpBookDescriptor[0];
        }
        ArrayList bookList = new ArrayList();
        int i = 0;
        while (i < providerDescriptors.length) {
            CHelpBookDescriptor[] bookDescriptors = providerDescriptors[i].getCHelpBookDescriptors();
            if (bookDescriptors.length != 0) {
                bookList.addAll(Arrays.asList(bookDescriptors));
            }
            ++i;
        }
        return bookList.toArray(new CHelpBookDescriptor[bookList.size()]);
    }

    private static IConfigurationElement[] getConfigElements() {
        if (fConfigElements == null && (fConfigElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.cdt.ui", CONTRIBUTION_EXTENSION)) == null) {
            fConfigElements = new IConfigurationElement[0];
        }
        return fConfigElements;
    }

    public IFunctionSummary getFunctionInfo(ICHelpInvocationContext context, String name) {
        CHelpProviderDescriptor[] providerDescriptors = this.getCHelpProviderDescriptors();
        int i = 0;
        while (i < providerDescriptors.length) {
            IFunctionSummary summary;
            ICHelpProvider provider;
            ICHelpBook[] books = providerDescriptors[i].getEnabledMatchedCHelpBooks(context);
            if (books != null && books.length != 0 && (provider = providerDescriptors[i].getCHelpProvider()) != null && (summary = provider.getFunctionInfo(context, books, name)) != null) {
                return summary;
            }
            ++i;
        }
        return null;
    }

    public IFunctionSummary[] getMatchingFunctions(ICHelpInvocationContext context, String frag) {
        CHelpProviderDescriptor[] providerDescriptors = this.getCHelpProviderDescriptors();
        ArrayList sumaryList = new ArrayList();
        int i = 0;
        while (i < providerDescriptors.length) {
            IFunctionSummary[] summaries;
            ICHelpProvider provider;
            ICHelpBook[] books = providerDescriptors[i].getEnabledMatchedCHelpBooks(context);
            if (books != null && books.length != 0 && (provider = providerDescriptors[i].getCHelpProvider()) != null && (summaries = provider.getMatchingFunctions(context, books, frag)) != null && summaries.length != 0) {
                sumaryList.addAll(Arrays.asList(summaries));
            }
            ++i;
        }
        if (sumaryList.size() == 0) {
            return null;
        }
        return sumaryList.toArray(new IFunctionSummary[sumaryList.size()]);
    }

    public ICHelpResourceDescriptor[] getHelpResources(ICHelpInvocationContext context, String name) {
        CHelpProviderDescriptor[] providerDescriptors = this.getCHelpProviderDescriptors();
        ArrayList resourcesList = new ArrayList();
        int i = 0;
        while (i < providerDescriptors.length) {
            ICHelpResourceDescriptor[] resources;
            ICHelpProvider provider;
            ICHelpBook[] books = providerDescriptors[i].getEnabledMatchedCHelpBooks(context);
            if (books != null && books.length != 0 && (provider = providerDescriptors[i].getCHelpProvider()) != null && (resources = provider.getHelpResources(context, books, name)) != null && resources.length != 0) {
                resourcesList.addAll(Arrays.asList(resources));
            }
            ++i;
        }
        if (resourcesList.size() == 0) {
            return null;
        }
        return resourcesList.toArray(new ICHelpResourceDescriptor[resourcesList.size()]);
    }

    public void serialize(Document doc, Element parentElement) {
        CHelpProviderDescriptor[] providerDescriptors = this.getCHelpProviderDescriptors();
        Element oldProjectElement = this.getProjectElement(parentElement);
        Element projectElement = doc.createElement(ELEMENT_PROJECT);
        projectElement.setAttribute(ATTRIBUTE_NAME, this.getProject().getName());
        if (oldProjectElement != null) {
            parentElement.replaceChild(projectElement, oldProjectElement);
        } else {
            parentElement.appendChild(projectElement);
        }
        int i = 0;
        while (i < providerDescriptors.length) {
            providerDescriptors[i].serialize(doc, projectElement);
            ++i;
        }
    }
}

