/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.c.hover;

import org.eclipse.cdt.internal.ui.text.c.hover.CTypeHover;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class CInformationProvider
implements IInformationProvider,
IInformationProviderExtension2 {
    protected IEditorPart fEditor;
    protected IPartListener fPartListener;
    protected CTypeHover fImplementation;
    private IInformationControlCreator fPresenterControlCreator;

    public CInformationProvider(IEditorPart editor) {
        this.fEditor = editor;
        if (this.fEditor != null) {
            this.fPartListener = new EditorWatcher();
            IWorkbenchWindow window = this.fEditor.getSite().getWorkbenchWindow();
            window.getPartService().addPartListener(this.fPartListener);
            this.fImplementation = new CTypeHover();
            this.fImplementation.setEditor(this.fEditor);
        }
    }

    public IRegion getSubject(ITextViewer textViewer, int offset) {
        if (textViewer != null && this.fImplementation != null) {
            return this.fImplementation.getHoverRegion(textViewer, offset);
        }
        return null;
    }

    public String getInformation(ITextViewer textViewer, IRegion subject) {
        String s;
        if (this.fImplementation != null && (s = this.fImplementation.getHoverInfo(textViewer, subject)) != null && s.trim().length() > 0) {
            return s;
        }
        return null;
    }

    public Object getInformation2(ITextViewer textViewer, IRegion subject) {
        if (this.fImplementation == null) {
            return null;
        }
        return this.fImplementation.getHoverInfo2(textViewer, subject);
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new ControlCreator();
        }
        return this.fPresenterControlCreator;
    }

    private static final class ControlCreator
    extends AbstractReusableInformationControlCreator {
        private ControlCreator() {
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            return new DefaultInformationControl(parent);
        }
    }

    class EditorWatcher
    implements IPartListener {
        EditorWatcher() {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == CInformationProvider.this.fEditor) {
                CInformationProvider.this.fEditor.getSite().getWorkbenchWindow().getPartService().removePartListener(CInformationProvider.this.fPartListener);
                CInformationProvider.this.fPartListener = null;
            }
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }
    }
}

