/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Item;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceToItemsMapper {
    private static final int NUMBER_LIST_REUSE = 10;
    private HashMap<IResource, Object> fResourceToItem = new HashMap();
    private Stack<List<Item>> fReuseLists = new Stack();
    private ContentViewer fContentViewer;

    public ResourceToItemsMapper(ContentViewer viewer) {
        this.fContentViewer = viewer;
    }

    public void resourceChanged(IResource changedResource) {
        Object obj = this.fResourceToItem.get(changedResource);
        if (obj != null) {
            if (obj instanceof Item) {
                this.updateItem((Item)obj);
            } else {
                List list = (List)obj;
                int k = 0;
                while (k < list.size()) {
                    this.updateItem((Item)list.get(k));
                    ++k;
                }
            }
        }
    }

    private void updateItem(Item item) {
        if (!item.isDisposed()) {
            ILabelProvider lprovider = (ILabelProvider)this.fContentViewer.getLabelProvider();
            Object data = item.getData();
            if (data != null && lprovider instanceof IViewerLabelProvider) {
                IViewerLabelProvider provider = (IViewerLabelProvider)lprovider;
                ViewerLabel updateLabel = new ViewerLabel(item.getText(), item.getImage());
                provider.updateLabel(updateLabel, data);
                if (updateLabel.hasNewImage()) {
                    item.setImage(updateLabel.getImage());
                }
                if (updateLabel.hasNewText()) {
                    item.setText(updateLabel.getText());
                }
            } else {
                Image oldImage = item.getImage();
                Image image = lprovider.getImage(data);
                if (image != null && !image.equals((Object)oldImage)) {
                    item.setImage(image);
                }
                String oldText = item.getText();
                String text = lprovider.getText(data);
                if (text != null && !text.equals(oldText)) {
                    item.setText(text);
                }
            }
        }
    }

    public void addToMap(Object element, Item item) {
        IResource resource = ResourceToItemsMapper.getCorrespondingResource(element);
        if (resource != null) {
            Object existingMapping = this.fResourceToItem.get(resource);
            if (existingMapping == null) {
                this.fResourceToItem.put(resource, item);
            } else if (existingMapping instanceof Item) {
                if (existingMapping != item) {
                    List<Item> list = this.getNewList();
                    list.add((Item)existingMapping);
                    list.add(item);
                    this.fResourceToItem.put(resource, list);
                }
            } else {
                List list = (List)existingMapping;
                if (!list.contains(item)) {
                    list.add(item);
                }
            }
        }
    }

    public void removeFromMap(Object element, Item item) {
        IResource resource = ResourceToItemsMapper.getCorrespondingResource(element);
        if (resource != null) {
            Object existingMapping = this.fResourceToItem.get(resource);
            if (existingMapping == null) {
                return;
            }
            if (existingMapping instanceof Item) {
                this.fResourceToItem.remove(resource);
            } else {
                List list = (List)existingMapping;
                list.remove(item);
                if (list.isEmpty()) {
                    this.fResourceToItem.remove(list);
                    this.releaseList(list);
                }
            }
        }
    }

    private List<Item> getNewList() {
        if (!this.fReuseLists.isEmpty()) {
            return this.fReuseLists.pop();
        }
        return new ArrayList<Item>(2);
    }

    private void releaseList(List<Item> list) {
        if (this.fReuseLists.size() < 10) {
            this.fReuseLists.push(list);
        }
    }

    public void clearMap() {
        this.fResourceToItem.clear();
    }

    public boolean isEmpty() {
        return this.fResourceToItem.isEmpty();
    }

    private static IResource getCorrespondingResource(Object element) {
        if (element instanceof ICElement) {
            ICElement elem = (ICElement)element;
            if (elem.exists()) {
                ITranslationUnit cu;
                IResource res = elem.getResource();
                if (res == null && (cu = (ITranslationUnit)elem.getAncestor(60)) != null) {
                    res = cu.getResource();
                }
                return res;
            }
            return null;
        }
        if (element instanceof IResource) {
            return (IResource)element;
        }
        return null;
    }
}

