/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.internal.corext.CorextMessages;
import org.eclipse.cdt.internal.ui.CUIStatus;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resources {
    private Resources() {
    }

    public static IStatus checkInSync(IResource resource) {
        return Resources.checkInSync(new IResource[]{resource});
    }

    public static IStatus checkInSync(IResource[] resources) {
        IStatus result = null;
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (!resource.isSynchronized(2)) {
                result = Resources.addOutOfSync(result, resource);
            }
            ++i;
        }
        if (result != null) {
            return result;
        }
        return new Status(0, CUIPlugin.getPluginId(), 0, "", null);
    }

    public static IStatus makeCommittable(IResource resource, Object context) {
        return Resources.makeCommittable(new IResource[]{resource}, context);
    }

    public static IStatus makeCommittable(IResource[] resources, Object context) {
        ArrayList<IResource> readOnlyFiles = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            ResourceAttributes attributes;
            IResource resource = resources[i];
            if (resource.getType() == 1 && (attributes = resource.getResourceAttributes()) != null && attributes.isReadOnly()) {
                readOnlyFiles.add(resource);
            }
            ++i;
        }
        if (readOnlyFiles.size() == 0) {
            return new Status(0, CUIPlugin.getPluginId(), 0, "", null);
        }
        Map<IFile, Long> oldTimeStamps = Resources.createModificationStampMap(readOnlyFiles);
        IStatus status = ResourcesPlugin.getWorkspace().validateEdit(readOnlyFiles.toArray(new IFile[readOnlyFiles.size()]), context);
        if (!status.isOK()) {
            return status;
        }
        IStatus modified = null;
        Map<IFile, Long> newTimeStamps = Resources.createModificationStampMap(readOnlyFiles);
        for (IFile file : oldTimeStamps.keySet()) {
            if (oldTimeStamps.get(file).equals(newTimeStamps.get(file))) continue;
            modified = Resources.addModified(modified, file);
        }
        if (modified != null) {
            return modified;
        }
        return new Status(0, CUIPlugin.getPluginId(), 0, "", null);
    }

    private static Map<IFile, Long> createModificationStampMap(List<IResource> files) {
        HashMap<IFile, Long> map = new HashMap<IFile, Long>();
        for (IFile iFile : files) {
            map.put(iFile, new Long(iFile.getModificationStamp()));
        }
        return map;
    }

    private static IStatus addModified(IStatus status, IFile file) {
        IStatus entry = CUIStatus.createError(10003, CorextMessages.getFormattedString("Resources.fileModified", file.getFullPath().toString()), null);
        if (status == null) {
            return entry;
        }
        if (status.isMultiStatus()) {
            ((MultiStatus)status).add(entry);
            return status;
        }
        MultiStatus result = new MultiStatus(CUIPlugin.getPluginId(), 10003, CorextMessages.getString("Resources.modifiedResources"), null);
        result.add(status);
        result.add(entry);
        return result;
    }

    private static IStatus addOutOfSync(IStatus status, IResource resource) {
        Status entry = new Status(4, ResourcesPlugin.getPlugin().getBundle().getSymbolicName(), 274, CorextMessages.getFormattedString("Resources.outOfSync", resource.getFullPath().toString()), null);
        if (status == null) {
            return entry;
        }
        if (status.isMultiStatus()) {
            ((MultiStatus)status).add((IStatus)entry);
            return status;
        }
        MultiStatus result = new MultiStatus(ResourcesPlugin.getPlugin().getBundle().getSymbolicName(), 274, CorextMessages.getString("Resources.outOfSyncResources"), null);
        result.add(status);
        result.add((IStatus)entry);
        return result;
    }

    public static String[] getLocationOSStrings(IResource[] resources) {
        ArrayList<String> result = new ArrayList<String>(resources.length);
        int i = 0;
        while (i < resources.length) {
            IPath location = resources[i].getLocation();
            if (location != null) {
                result.add(location.toOSString());
            }
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }
}

