/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.filewizard;

import java.util.HashMap;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.cdt.internal.ui.wizards.NewElementWizardPage;
import org.eclipse.cdt.internal.ui.wizards.SourceFolderSelectionDialog;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.Separator;
import org.eclipse.cdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.cdt.internal.ui.wizards.filewizard.NewFileWizardMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.views.contentoutline.ContentOutline;

public abstract class AbstractFileCreationWizardPage
extends NewElementWizardPage {
    private static final int MAX_FIELD_CHARS = 50;
    private IWorkspaceRoot fWorkspaceRoot;
    private static final int SOURCE_FOLDER_ID = 1;
    protected static final int NEW_FILE_ID = 2;
    private static final int ALL_FIELDS = 3;
    int fLastFocusedField = 0;
    private StringButtonDialogField fSourceFolderDialogField;
    private IStatus fSourceFolderStatus;
    private IStatus fNewFileStatus;
    private final IStatus STATUS_OK = new StatusInfo();
    private boolean isFirstTime = false;
    private Template[] fTemplates;
    private ComboDialogField fTemplateDialogField;

    public AbstractFileCreationWizardPage(String name) {
        super(name);
        this.setDescription(NewFileWizardMessages.AbstractFileCreationWizardPage_description);
        this.fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        SourceFolderFieldAdapter sourceFolderAdapter = new SourceFolderFieldAdapter();
        this.fSourceFolderDialogField = new StringButtonDialogField(sourceFolderAdapter);
        this.fSourceFolderDialogField.setDialogFieldListener(sourceFolderAdapter);
        this.fSourceFolderDialogField.setLabelText(NewFileWizardMessages.AbstractFileCreationWizardPage_sourceFolder_label);
        this.fSourceFolderDialogField.setButtonLabel(NewFileWizardMessages.AbstractFileCreationWizardPage_sourceFolder_button);
        this.fTemplates = this.getApplicableTemplates();
        if (this.fTemplates != null && this.fTemplates.length > 0) {
            this.fTemplateDialogField = new ComboDialogField(0);
            this.fTemplateDialogField.setLabelText(NewFileWizardMessages.AbstractFileCreationWizardPage_template_label);
        }
        this.fSourceFolderStatus = this.STATUS_OK;
        this.fNewFileStatus = this.STATUS_OK;
        this.fLastFocusedField = 0;
        this.isFirstTime = true;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.createSourceFolderControls(composite, nColumns);
        this.createFileControls(composite, nColumns);
        this.createTemplateControls(composite, nColumns);
        composite.layout();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    protected void createSeparator(Composite composite, int nColumns) {
        new Separator(258).doFillIntoGrid(composite, nColumns, this.convertHeightInCharsToPixels(1));
    }

    protected void createSourceFolderControls(Composite parent, int nColumns) {
        this.fSourceFolderDialogField.doFillIntoGrid(parent, nColumns);
        Text textControl = this.fSourceFolderDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)textControl, this.getMaxFieldWidth());
        textControl.addFocusListener((FocusListener)new StatusFocusListener(1));
    }

    protected abstract void createFileControls(Composite var1, int var2);

    protected void createTemplateControls(Composite parent, int columns) {
        if (this.fTemplateDialogField != null) {
            this.fTemplateDialogField.doFillIntoGrid(parent, columns - 1);
            Button configureButton = new Button(parent, 8);
            configureButton.setText(NewFileWizardMessages.AbstractFileCreationWizardPage_configure_label);
            configureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractFileCreationWizardPage.this.editTemplates();
                }
            });
            Combo comboControl = this.fTemplateDialogField.getComboControl(null);
            LayoutUtil.setWidthHint((Control)comboControl, this.getMaxFieldWidth());
        }
    }

    protected void editTemplates() {
        PreferenceDialog dialog;
        String prefPageId = "org.eclipse.cdt.ui.preferences.CodeTemplatePreferencePage";
        HashMap<String, String> data = null;
        String templateName = null;
        Template template = this.getSelectedTemplate();
        if (template != null) {
            templateName = template.getName();
        }
        if (templateName != null) {
            data = new HashMap<String, String>();
            data.put("CodeTemplatePreferencePage.select_template", templateName);
        }
        if ((dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)prefPageId, (String[])new String[]{prefPageId}, data)).open() == 0) {
            this.updateTemplates();
        }
    }

    protected void updateTemplates() {
        Template selected = this.getSelectedTemplate();
        this.fTemplates = this.getApplicableTemplates();
        int idx = 1;
        String[] names = new String[this.fTemplates.length + 1];
        int i = 0;
        while (i < this.fTemplates.length) {
            names[i + 1] = this.fTemplates[i].getName();
            if (selected != null && selected.getName().equals(names[i + 1])) {
                idx = i;
            }
            ++i;
        }
        names[0] = NewFileWizardMessages.AbstractFileCreationWizardPage_noTemplate;
        this.fTemplateDialogField.setItems(names);
        this.fTemplateDialogField.selectItem(idx + 1);
    }

    protected abstract Template[] getApplicableTemplates();

    protected Template getSelectedTemplate() {
        int index;
        if (this.fTemplateDialogField != null && (index = this.fTemplateDialogField.getSelectionIndex() - 1) >= 0 && index < this.fTemplates.length) {
            return this.fTemplates[index];
        }
        return null;
    }

    public void init(IStructuredSelection selection) {
        ICElement celem = this.getInitialCElement(selection);
        this.initFields(celem);
        this.doStatusUpdate();
    }

    protected ICElement getInitialCElement(IStructuredSelection selection) {
        IResource resource;
        IAdaptable adaptable;
        Object selectedElement;
        ICElement celem = null;
        if (selection != null && !selection.isEmpty() && (selectedElement = selection.getFirstElement()) instanceof IAdaptable && (celem = (ICElement)(adaptable = (IAdaptable)selectedElement).getAdapter(ICElement.class)) == null && (resource = (IResource)adaptable.getAdapter(IResource.class)) != null && resource.getType() != 8) {
            while (celem == null && resource.getType() != 4) {
                celem = (ICElement)resource.getAdapter(ICElement.class);
                resource = resource.getParent();
            }
            if (celem == null) {
                celem = CoreModel.getDefault().create(resource);
            }
        }
        if (celem == null) {
            IResource res;
            IEditorInput input;
            Object elem;
            IWorkbenchPart part = CUIPlugin.getActivePage().getActivePart();
            if (part instanceof ContentOutline) {
                part = CUIPlugin.getActivePage().getActiveEditor();
            }
            if (part instanceof IViewPartInputProvider && (elem = ((IViewPartInputProvider)part).getViewPartInput()) instanceof ICElement) {
                celem = (ICElement)elem;
            }
            if (celem == null && part instanceof CEditor && (input = ((IEditorPart)part).getEditorInput()) != null && (res = (IResource)input.getAdapter(IResource.class)) != null && res instanceof IFile) {
                celem = CoreModel.getDefault().create((IFile)res);
            }
        }
        if (celem == null || celem.getElementType() == 10) {
            try {
                ICProject[] projects = CoreModel.create((IWorkspaceRoot)this.getWorkspaceRoot()).getCProjects();
                if (projects.length == 1) {
                    celem = projects[0];
                }
            }
            catch (CModelException e) {
                CUIPlugin.log(e);
            }
        }
        return celem;
    }

    protected void initFields(ICElement elem) {
        this.initSourceFolder(elem);
        this.updateTemplates();
        this.handleFieldChanged(3);
    }

    protected void initSourceFolder(ICElement elem) {
        ICProject cproject;
        ICContainer folder = null;
        if (elem != null && (folder = CModelUtil.getSourceFolder(elem)) == null && (cproject = elem.getCProject()) != null) {
            try {
                ISourceRoot[] roots;
                if (cproject.exists() && (roots = cproject.getSourceRoots()) != null && roots.length > 0) {
                    folder = roots[0];
                }
            }
            catch (CModelException e) {
                CUIPlugin.log(e);
            }
            if (folder == null) {
                folder = cproject.findSourceRoot(cproject.getResource());
            }
        }
        this.setSourceFolderFullPath(folder != null ? folder.getResource().getFullPath() : null, false);
    }

    protected int getMaxFieldWidth() {
        return this.convertWidthInCharsToPixels(50);
    }

    protected ITextSelection getCurrentTextSelection() {
        ISelection selection;
        ISelectionProvider selectionProvider;
        IWorkbenchPart part = CUIPlugin.getActivePage().getActivePart();
        if (part instanceof IEditorPart && (selectionProvider = part.getSite().getSelectionProvider()) != null && (selection = selectionProvider.getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return null;
    }

    protected void setFocusOnSourceFolder() {
        this.fSourceFolderDialogField.setFocus();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected IStatus sourceFolderChanged() {
        StatusInfo status = new StatusInfo();
        IPath folderPath = this.getSourceFolderFullPath();
        if (folderPath == null) {
            status.setError(NewFileWizardMessages.AbstractFileCreationWizardPage_error_EnterSourceFolderName);
            return status;
        }
        IResource res = this.fWorkspaceRoot.findMember(folderPath);
        if (res != null && res.exists()) {
            int resType = res.getType();
            if (resType == 4 || resType == 2) {
                ICElement e;
                IProject proj = res.getProject();
                if (!proj.isOpen()) {
                    status.setError(NLS.bind((String)NewFileWizardMessages.AbstractFileCreationWizardPage_error_NotAFolder, (Object)folderPath));
                    return status;
                }
                if (!CoreModel.hasCCNature((IProject)proj) && !CoreModel.hasCNature((IProject)proj)) {
                    if (resType == 4) {
                        status.setError(NewFileWizardMessages.AbstractFileCreationWizardPage_warning_NotACProject);
                        return status;
                    }
                    status.setWarning(NewFileWizardMessages.AbstractFileCreationWizardPage_warning_NotInACProject);
                }
                if (CModelUtil.getSourceFolder(e = CoreModel.getDefault().create(res.getFullPath())) != null) return status;
                status.setError(NLS.bind((String)NewFileWizardMessages.AbstractFileCreationWizardPage_error_NotASourceFolder, (Object)folderPath));
                return status;
            }
            status.setError(NLS.bind((String)NewFileWizardMessages.AbstractFileCreationWizardPage_error_NotAFolder, (Object)folderPath));
            return status;
        }
        status.setError(NLS.bind((String)NewFileWizardMessages.AbstractFileCreationWizardPage_error_FolderDoesNotExist, (Object)folderPath));
        return status;
    }

    protected void handleFieldChanged(int fields) {
        if (fields == 0) {
            return;
        }
        if (this.fieldChanged(fields, 1)) {
            this.fSourceFolderStatus = this.sourceFolderChanged();
        }
        if (this.fieldChanged(fields, 2)) {
            if (this.isFirstTime) {
                this.isFirstTime = false;
                return;
            }
            this.fNewFileStatus = this.fileNameChanged();
        }
        this.doStatusUpdate();
    }

    private boolean fieldChanged(int fields, int fieldID) {
        return (fields & fieldID) != 0;
    }

    protected void doStatusUpdate() {
        IStatus lastStatus = this.getLastFocusedStatus();
        IStatus[] status = new IStatus[]{lastStatus, this.fSourceFolderStatus != lastStatus ? this.fSourceFolderStatus : this.STATUS_OK, this.fNewFileStatus != lastStatus ? this.fNewFileStatus : this.STATUS_OK};
        this.updateStatus(status);
    }

    private IStatus getLastFocusedStatus() {
        switch (this.fLastFocusedField) {
            case 1: {
                return this.fSourceFolderStatus;
            }
            case 2: {
                return this.fNewFileStatus;
            }
        }
        return this.STATUS_OK;
    }

    public IPath getSourceFolderFullPath() {
        String text = this.fSourceFolderDialogField.getText();
        if (text.length() > 0) {
            return new Path(text).makeAbsolute();
        }
        return null;
    }

    public void setSourceFolderFullPath(IPath folderPath, boolean update) {
        String str = folderPath != null ? folderPath.makeRelative().toString() : "";
        this.fSourceFolderDialogField.setTextWithoutUpdate(str);
        if (update) {
            this.fSourceFolderDialogField.dialogFieldChanged();
        }
    }

    protected IProject getCurrentProject() {
        IPath folderPath = this.getSourceFolderFullPath();
        if (folderPath != null) {
            return PathUtil.getEnclosingProject((IPath)folderPath);
        }
        return null;
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return this.fWorkspaceRoot;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    protected abstract void setFocus();

    IPath chooseSourceFolder(IPath initialPath) {
        Object result;
        ICProject cProject;
        ISourceRoot projRoot;
        ICElement initElement = this.getSourceFolderFromPath(initialPath);
        if (initElement instanceof ISourceRoot && (projRoot = (cProject = initElement.getCProject()).findSourceRoot((IResource)cProject.getProject())) != null && projRoot.equals(initElement)) {
            initElement = cProject;
        }
        SourceFolderSelectionDialog dialog = new SourceFolderSelectionDialog(this.getShell());
        dialog.setInput(CoreModel.create((IWorkspaceRoot)this.fWorkspaceRoot));
        dialog.setInitialSelection(initElement);
        if (dialog.open() == 0 && (result = dialog.getFirstResult()) instanceof ICElement) {
            ICProject cproject;
            ISourceRoot folder;
            ICElement element = (ICElement)result;
            if (element instanceof ICProject && (folder = (cproject = (ICProject)element).findSourceRoot((IResource)cproject.getProject())) != null) {
                return folder.getResource().getFullPath();
            }
            return element.getResource().getFullPath();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private ICElement getSourceFolderFromPath(IPath path) {
        if (path != null) ** GOTO lbl12
        return null;
lbl-1000:
        // 1 sources

        {
            res = this.fWorkspaceRoot.findMember(path);
            if (res != null && res.exists() && ((resType = res.getType()) == 4 || resType == 2)) {
                elem = CoreModel.getDefault().create(res.getFullPath());
                sourceFolder = CModelUtil.getSourceFolder(elem);
                if (sourceFolder != null) {
                    return sourceFolder;
                }
                if (resType == 4) {
                    return elem;
                }
            }
            path = path.removeLastSegments(1);
lbl12:
            // 2 sources

            ** while (path.segmentCount() > 0)
        }
lbl13:
        // 1 sources

        return null;
    }

    public abstract IPath getFileFullPath();

    protected abstract IStatus fileNameChanged();

    public abstract void createFile(IProgressMonitor var1) throws CoreException;

    public abstract ITranslationUnit getCreatedFileTU();

    private class SourceFolderFieldAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private SourceFolderFieldAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            IPath oldFolderPath = AbstractFileCreationWizardPage.this.getSourceFolderFullPath();
            IPath newFolderPath = AbstractFileCreationWizardPage.this.chooseSourceFolder(oldFolderPath);
            if (newFolderPath != null) {
                AbstractFileCreationWizardPage.this.setSourceFolderFullPath(newFolderPath, false);
                AbstractFileCreationWizardPage.this.handleFieldChanged(3);
            }
        }

        public void dialogFieldChanged(DialogField field) {
            AbstractFileCreationWizardPage.this.handleFieldChanged(3);
        }
    }

    protected final class StatusFocusListener
    implements FocusListener {
        private int fieldID;

        public StatusFocusListener(int fieldID) {
            this.fieldID = fieldID;
        }

        public void focusGained(FocusEvent e) {
            AbstractFileCreationWizardPage.this.fLastFocusedField = this.fieldID;
            AbstractFileCreationWizardPage.this.doStatusUpdate();
        }

        public void focusLost(FocusEvent e) {
            AbstractFileCreationWizardPage.this.fLastFocusedField = 0;
            AbstractFileCreationWizardPage.this.doStatusUpdate();
        }
    }
}

