/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.cdtvariables.ICdtVariableManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.ui.newui.BuildVarListDialog;
import org.eclipse.cdt.ui.newui.CDTPrefUtil;
import org.eclipse.cdt.ui.newui.ICPropertyProvider;
import org.eclipse.cdt.ui.newui.ICPropertyTab;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public abstract class AbstractCPropertyTab
implements ICPropertyTab {
    public static final Method GRAY_METHOD = AbstractCPropertyTab.getGrayEnabled();
    public static final int BUTTON_WIDTH = 120;
    public static final String EMPTY_STR = "";
    public static final String ADD_STR = UIMessages.getString("FileListControl.add");
    public static final String DEL_STR = UIMessages.getString("FileListControl.delete");
    public static final String EDIT_STR = UIMessages.getString("FileListControl.edit");
    public static final String MOVEUP_STR = UIMessages.getString("FileListControl.moveup");
    public static final String MOVEDOWN_STR = UIMessages.getString("FileListControl.movedown");
    public static final String WORKSPACEBUTTON_NAME = UIMessages.getString("FileListControl.button.workspace");
    public static final String FILESYSTEMBUTTON_NAME = UIMessages.getString("FileListControl.button.fs");
    public static final String VARIABLESBUTTON_NAME = UIMessages.getString("AbstractCPropertyTab.1");
    public static final String FILESYSTEM_DIR_DIALOG_MSG = UIMessages.getString("BrowseEntryDialog.fs.dir.dlg.msg");
    public static final String FILESYSTEM_FILE_DIALOG_TITLE = "";
    public static final String WORKSPACE_DIR_DIALOG_TITLE = UIMessages.getString("BrowseEntryDialog.wsp.dir.dlg.title");
    public static final String WORKSPACE_FILE_DIALOG_TITLE = UIMessages.getString("BrowseEntryDialog.wsp.file.dlg.title");
    public static final String WORKSPACE_DIR_DIALOG_MSG = UIMessages.getString("BrowseEntryDialog.wsp.dir.dlg.msg");
    public static final String WORKSPACE_FILE_DIALOG_MSG = UIMessages.getString("BrowseEntryDialog.wsp.file.dlg.msg");
    public static final String WORKSPACE_FILE_DIALOG_ERR = UIMessages.getString("BrowseEntryDialog.wsp.file.dlg.err");
    public static final String WORKSPACE_DIR_DIALOG_ERR = UIMessages.getString("BrowseEntryDialog.wsp.dir.dlg.err");
    public static final String BACKGROUND_TEXT_DEFAULT = UIMessages.getString("AbstractCPropertyTab.2");
    public static final Color BACKGROUND_FOR_USER_VAR = new Color((Device)Display.getDefault(), 255, 255, 200);
    private static final String PREFIX = "org.eclipse.cdt.ui.";
    public static final int TRI_UNKNOWN = 2;
    public static final int TRI_YES = 1;
    public static final int TRI_NO = 0;
    protected static final String ENUM = "enum";
    protected static final String SSET = "set";
    private CLabel background;
    protected Composite usercomp;
    protected Composite buttoncomp;
    private Button[] buttons;
    public ICPropertyProvider page;
    protected Image icon = null;
    private String helpId = "";
    protected boolean visible;

    public void createControls(Composite _parent, ICPropertyProvider _provider) {
        this.page = _provider;
        this.createControls(_parent);
    }

    protected void createControls(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.background = new CLabel(parent, 0x1000020);
        this.background.setText("");
        this.background.setLayout((Layout)new GridLayout(2, false));
        this.usercomp = new Composite((Composite)this.background, 0);
        this.usercomp.setLayoutData((Object)new GridData(1808));
        this.buttoncomp = new Composite((Composite)this.background, 0);
        GridData d = new GridData(3);
        d.widthHint = 1;
        this.buttoncomp.setLayoutData((Object)d);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.helpId);
    }

    protected void initButtons(String[] names) {
        this.initButtons(this.buttoncomp, names, 80);
    }

    protected void initButtons(String[] names, int width) {
        this.initButtons(this.buttoncomp, names, width);
    }

    protected void initButtons(Composite c, String[] names) {
        this.initButtons(c, names, 80);
    }

    protected void initButtons(Composite c, String[] names, int width) {
        if (names == null || names.length == 0) {
            return;
        }
        c.setLayoutData((Object)new GridData(1040));
        c.setLayout((Layout)new GridLayout(1, false));
        this.buttons = new Button[names.length];
        int i = 0;
        while (i < names.length) {
            this.buttons[i] = new Button(c, 8);
            GridData gdb = new GridData(4);
            gdb.grabExcessHorizontalSpace = false;
            gdb.horizontalAlignment = 4;
            gdb.minimumWidth = width;
            if (names[i] != null) {
                this.buttons[i].setText(names[i]);
            } else {
                this.buttons[i].setVisible(false);
                this.buttons[i].setEnabled(false);
                gdb.heightHint = 10;
            }
            this.buttons[i].setLayoutData((Object)gdb);
            this.buttons[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    AbstractCPropertyTab.this.buttonPressed(event);
                }
            });
            ++i;
        }
    }

    private void configChanged(ICResourceDescription cfg) {
        if (this.visible) {
            this.updateData(cfg);
        }
    }

    public void dispose() {
    }

    public void setVisible(boolean _visible) {
        this.visible = _visible;
        if (this.visible) {
            this.updateData(this.page.getResDesc());
        }
    }

    protected abstract void performApply(ICResourceDescription var1, ICResourceDescription var2);

    protected abstract void performDefaults();

    protected abstract void updateData(ICResourceDescription var1);

    protected abstract void updateButtons();

    protected void performCancel() {
    }

    protected void performOK() {
    }

    private void buttonPressed(SelectionEvent e) {
        int i = 0;
        while (i < this.buttons.length) {
            if (this.buttons[i].equals(e.widget)) {
                this.buttonPressed(i);
                return;
            }
            ++i;
        }
    }

    protected void buttonPressed(int i) {
    }

    protected boolean buttonIsEnabled(int i) {
        if (this.buttons == null || this.buttons.length <= i) {
            return false;
        }
        return this.buttons[i].isEnabled();
    }

    protected void buttonSetEnabled(int i, boolean state) {
        if (this.buttons == null || this.buttons.length <= i) {
            return;
        }
        this.buttons[i].setEnabled(state);
    }

    protected void buttonSetText(int i, String text) {
        if (this.buttons == null || this.buttons.length <= i) {
            return;
        }
        this.buttons[i].setText(text);
        Composite c = this.buttons[i].getParent();
        if (c != null) {
            c.pack();
            c = c.getParent();
            if (c != null) {
                c.layout(true);
            }
        }
    }

    protected Label setupLabel(Composite c, String name, int span, int mode) {
        Label l = new Label(c, 0);
        l.setText(name);
        this.setupControl((Control)l, span, mode);
        return l;
    }

    protected Button setupButton(Composite c, String name, int span, int mode) {
        Button b = new Button(c, 8);
        b.setText(name);
        this.setupControl((Control)b, span, mode);
        GridData g = (GridData)b.getLayoutData();
        g.minimumWidth = 120;
        g.horizontalAlignment = 131072;
        b.setLayoutData((Object)g);
        return b;
    }

    protected Text setupText(Composite c, int span, int mode) {
        Text t = new Text(c, 2052);
        this.setupControl((Control)t, span, mode);
        return t;
    }

    protected Group setupGroup(Composite c, String name, int cols, int mode) {
        Group g = new Group(c, 0);
        g.setText(name);
        g.setLayout((Layout)new GridLayout(cols, false));
        this.setupControl((Control)g, 1, mode);
        return g;
    }

    protected Button setupCheck(Composite c, String name, int span, int mode) {
        Button b = new Button(c, 32);
        b.setText(name);
        this.setupControl((Control)b, span, mode);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractCPropertyTab.setGrayed((Button)event.widget, false);
                AbstractCPropertyTab.this.checkPressed(event);
            }
        });
        return b;
    }

    protected void checkPressed(SelectionEvent e) {
    }

    protected void setupControl(Control c, int span, int mode) {
        if (c != null) {
            if (span != 0) {
                GridData gd = new GridData(mode);
                gd.horizontalSpan = span;
                c.setLayoutData((Object)gd);
            }
            Composite p = c.getParent();
            c.setFont(p.getFont());
        }
    }

    public static String getFileSystemDirDialog(Shell shell, String text) {
        DirectoryDialog dialog = new DirectoryDialog(shell, 69632);
        if (text != null && text.trim().length() != 0) {
            dialog.setFilterPath(text);
        }
        dialog.setMessage(FILESYSTEM_DIR_DIALOG_MSG);
        return dialog.open();
    }

    public static String getFileSystemFileDialog(Shell shell, String text) {
        FileDialog dialog = new FileDialog(shell);
        if (text != null && text.trim().length() != 0) {
            dialog.setFilterPath(text);
        }
        dialog.setFilterExtensions(new String[]{"*.a;*.so;*.dll;*.lib"});
        dialog.setText("");
        return dialog.open();
    }

    public static String getVariableDialog(Shell shell, ICConfigurationDescription cfgd) {
        Object[] selected;
        ICdtVariableManager vm = CCorePlugin.getDefault().getCdtVariableManager();
        BuildVarListDialog dialog = new BuildVarListDialog(shell, vm.getVariables(cfgd));
        dialog.setTitle(UIMessages.getString("AbstractCPropertyTab.0"));
        if (dialog.open() == 0 && (selected = dialog.getResult()).length > 0) {
            String s = ((ICdtVariable)selected[0]).getName();
            return "${" + s.trim() + "}";
        }
        return null;
    }

    public static String getWorkspaceDirDialog(Shell shell, String text) {
        return AbstractCPropertyTab.getWorkspaceDialog(shell, text, true, null);
    }

    public static String getWorkspaceFileDialog(Shell shell, String text) {
        return AbstractCPropertyTab.getWorkspaceDialog(shell, text, false, null);
    }

    private static String getWorkspaceDialog(Shell shell, String text, boolean dir, IProject prj) {
        IFile resource;
        String currentPathText = text;
        currentPathText = currentPathText.replaceAll("\"", "");
        Path path = new Path(currentPathText);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        if (prj == null) {
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        } else {
            dialog.setInput((Object)prj);
        }
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        if (dir) {
            IContainer[] cs;
            IContainer container = null;
            if (path.isAbsolute() && (cs = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocation((IPath)path)) != null && cs.length > 0) {
                container = cs[0];
            }
            dialog.setInitialSelection(container);
            dialog.setValidator(new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    if (selection != null && selection.length > 0 && selection[0] instanceof IFile) {
                        return new StatusInfo(4, WORKSPACE_DIR_DIALOG_ERR);
                    }
                    return new StatusInfo();
                }
            });
            dialog.setTitle(WORKSPACE_DIR_DIALOG_TITLE);
            dialog.setMessage(WORKSPACE_DIR_DIALOG_MSG);
        } else {
            IFile[] fs;
            resource = null;
            if (path.isAbsolute() && (fs = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)path)) != null && fs.length > 0) {
                resource = fs[0];
            }
            dialog.setInitialSelection(resource);
            dialog.setValidator(new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    if (selection != null && selection.length > 0 && !(selection[0] instanceof IFile)) {
                        return new StatusInfo(4, WORKSPACE_FILE_DIALOG_ERR);
                    }
                    return new StatusInfo();
                }
            });
            dialog.setTitle(WORKSPACE_FILE_DIALOG_TITLE);
            dialog.setMessage(WORKSPACE_FILE_DIALOG_MSG);
        }
        if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
            StringBuffer buf = new StringBuffer();
            return buf.append("${").append("workspace_loc:").append(resource.getFullPath()).append("}").toString();
        }
        return null;
    }

    public ICResourceDescription getResDesc() {
        return this.page.getResDesc();
    }

    public void handleTabEvent(int kind, Object data) {
        switch (kind) {
            case 0: {
                if (!this.canBeVisible()) break;
                this.performOK();
                break;
            }
            case 1: {
                if (!this.canBeVisible()) break;
                this.performApply(this.getResDesc(), (ICResourceDescription)data);
                break;
            }
            case 2: {
                if (!this.canBeVisible()) break;
                this.performCancel();
                break;
            }
            case 3: {
                if (!this.canBeVisible()) break;
                this.updateData(this.getResDesc());
                this.performDefaults();
                break;
            }
            case 4: {
                if (!this.canBeVisible()) break;
                this.configChanged((ICResourceDescription)data);
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                if (this.canBeVisible()) {
                    this.setVisible(data != null);
                    break;
                }
                this.setVisible(false);
                break;
            }
            case 7: {
                this.icon = (Image)data;
                break;
            }
        }
    }

    public boolean canBeVisible() {
        return true;
    }

    public static FontMetrics getFontMetrics(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        FontMetrics fFontMetrics = gc.getFontMetrics();
        gc.dispose();
        return fFontMetrics;
    }

    public static void setTriSelection(Button b, boolean state) {
        AbstractCPropertyTab.setTriSelection(b, state ? 1 : 0);
    }

    public static void setTriSelection(Button b, int state) {
        switch (state) {
            case 0: {
                AbstractCPropertyTab.setGrayed(b, false);
                b.setSelection(false);
                break;
            }
            case 1: {
                AbstractCPropertyTab.setGrayed(b, false);
                b.setSelection(true);
                break;
            }
            case 2: {
                b.setSelection(true);
                AbstractCPropertyTab.setGrayed(b, true);
            }
        }
    }

    public static void setGrayed(Button b, boolean value) {
        if (GRAY_METHOD != null) {
            try {
                GRAY_METHOD.invoke((Object)b, new Boolean(value));
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    private static Method getGrayEnabled() {
        try {
            Class<?> cl = Class.forName("org.eclipse.swt.widgets.Button");
            return cl.getMethod("setGrayed", Boolean.TYPE);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    protected void setAllVisible(boolean visible, String msg) {
        this.setBackgroundText(visible ? "" : msg);
        this.usercomp.setVisible(visible);
        this.buttoncomp.setVisible(visible);
        if (this.page != null) {
            Button b = this.page.getAButton();
            if (b != null) {
                b.setVisible(visible);
            }
            if ((b = this.page.getDButton()) != null) {
                b.setVisible(visible);
            }
        }
    }

    protected void setBackgroundText(String s) {
        this.background.setText(s == null ? BACKGROUND_TEXT_DEFAULT : s);
    }

    protected void updateLbs(Label lb1, Label lb2) {
        if (this.page.isMultiCfg()) {
            if (lb1 != null) {
                lb1.setText(CDTPrefUtil.getDMode());
                lb1.setVisible(true);
            }
            if (lb2 != null) {
                lb2.setText(CDTPrefUtil.getWMode());
                lb2.setVisible(true);
            }
        } else {
            if (lb1 != null) {
                lb1.setVisible(false);
            }
            if (lb2 != null) {
                lb2.setVisible(false);
            }
        }
    }

    protected boolean isWModifyMode() {
        int wmode = CDTPrefUtil.getInt("properties.multi.write.mode");
        return wmode == 4;
    }

    public String getHelpContextId() {
        return this.helpId;
    }

    public void setHelpContextId(String id) {
        this.helpId = PREFIX + id;
    }
}

