/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.text;

import org.eclipse.cdt.ui.IPropertyChangeParticipant;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.util.PropertyChangeEvent;

public final class TaskTagRule
extends WordRule
implements IPropertyChangeParticipant {
    private IToken fToken;

    public static String getTaskWords(IPreferenceStore preferenceStore, Preferences corePreferences) {
        String result = null;
        if (preferenceStore.contains("org.eclipse.cdt.core.taskTags")) {
            result = preferenceStore.getString("org.eclipse.cdt.core.taskTags");
        } else if (corePreferences != null) {
            result = corePreferences.getString("org.eclipse.cdt.core.taskTags");
        }
        return result;
    }

    public TaskTagRule(IToken token, String taskWords) {
        super((IWordDetector)new TaskTagDetector(), Token.UNDEFINED);
        this.fToken = token;
        if (taskWords != null) {
            this.addTaskTags(taskWords);
        }
    }

    public void clearTaskTags() {
        this.fWords.clear();
    }

    public void addTaskTags(String value) {
        String[] tasks = value.split(",");
        int i = 0;
        while (i < tasks.length) {
            if (tasks[i].length() > 0) {
                this.addWord(tasks[i], this.fToken);
            }
            ++i;
        }
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return event.getProperty().equals("org.eclipse.cdt.core.taskTags");
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        Object value;
        if (event.getProperty().equals("org.eclipse.cdt.core.taskTags") && (value = event.getNewValue()) instanceof String) {
            this.clearTaskTags();
            this.addTaskTags((String)value);
        }
    }

    private static class TaskTagDetector
    implements IWordDetector {
        private TaskTagDetector() {
        }

        public boolean isWordStart(char c) {
            return Character.isLetter(c);
        }

        public boolean isWordPart(char c) {
            return Character.isLetter(c);
        }
    }
}

