/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.newui.UIMessages;
import org.eclipse.cdt.ui.wizards.CDTMainWizardPage;
import org.eclipse.cdt.ui.wizards.CWizardHandler;
import org.eclipse.cdt.ui.wizards.IWizardWithMemory;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public abstract class CDTCommonProjectWizard
extends BasicNewResourceWizard
implements IExecutableExtension,
IWizardWithMemory {
    private static final String PREFIX = "CProjectWizard";
    private static final String OP_ERROR = "CProjectWizard.op_error";
    private static final String title = CUIPlugin.getResourceString("CProjectWizard.op_error.title");
    private static final String message = CUIPlugin.getResourceString("CProjectWizard.op_error.message");
    private static final String[] EMPTY_ARR = new String[0];
    protected IConfigurationElement fConfigElement;
    protected CDTMainWizardPage fMainPage;
    protected IProject newProject;
    private String wz_title;
    private String wz_desc;
    private boolean existingPath = false;
    private String lastProjectName = null;
    private URI lastProjectLocation = null;
    private CWizardHandler savedHandler = null;

    public CDTCommonProjectWizard() {
        this(UIMessages.getString("NewModelProjectWizard.0"), UIMessages.getString("NewModelProjectWizard.1"));
    }

    public CDTCommonProjectWizard(String title, String desc) {
        this.setDialogSettings(CUIPlugin.getDefault().getDialogSettings());
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(title);
        this.wz_title = title;
        this.wz_desc = desc;
    }

    public void addPages() {
        this.fMainPage = new CDTMainWizardPage(CUIPlugin.getResourceString(PREFIX));
        this.fMainPage.setTitle(this.wz_title);
        this.fMainPage.setDescription(this.wz_desc);
        this.addPage((IWizardPage)this.fMainPage);
    }

    private boolean isChanged() {
        if (this.savedHandler != this.fMainPage.h_selected) {
            return true;
        }
        if (!this.fMainPage.getProjectName().equals(this.lastProjectName)) {
            return true;
        }
        URI projectLocation = this.fMainPage.getProjectLocation();
        if (projectLocation == null ? this.lastProjectLocation != null : !projectLocation.equals(this.lastProjectLocation)) {
            return true;
        }
        return this.savedHandler.isChanged();
    }

    public IProject getProject(boolean defaults) {
        return this.getProject(defaults, true);
    }

    public IProject getProject(boolean defaults, boolean onFinish) {
        if (this.newProject != null && this.isChanged()) {
            this.clearProject();
        }
        if (this.newProject == null) {
            block7: {
                block8: {
                    IFileStore fs;
                    this.existingPath = false;
                    URI p = this.fMainPage.getProjectLocation();
                    if (p == null) {
                        fs = EFS.getStore((URI)ResourcesPlugin.getWorkspace().getRoot().getLocationURI());
                        fs = fs.getChild(this.fMainPage.getProjectName());
                    } else {
                        fs = EFS.getStore((URI)p);
                    }
                    IFileInfo f = fs.fetchInfo();
                    if (!f.exists() || !f.isDirectory()) break block7;
                    if (!fs.getChild(".project").fetchInfo().exists() || MessageDialog.openConfirm((Shell)this.getShell(), (String)UIMessages.getString("CDTCommonProjectWizard.0"), (String)UIMessages.getString("CDTCommonProjectWizard.1"))) break block8;
                    return null;
                }
                try {
                    this.existingPath = true;
                }
                catch (CoreException e) {
                    CUIPlugin.log(e.getStatus());
                }
            }
            this.savedHandler = this.fMainPage.h_selected;
            this.savedHandler.saveState();
            this.lastProjectName = this.fMainPage.getProjectName();
            this.lastProjectLocation = this.fMainPage.getProjectLocation();
            this.invokeRunnable(this.getRunnable(defaults, onFinish));
        }
        return this.newProject;
    }

    private void clearProject() {
        if (this.lastProjectName == null) {
            return;
        }
        try {
            ResourcesPlugin.getWorkspace().getRoot().getProject(this.lastProjectName).delete(!this.existingPath, true, null);
        }
        catch (CoreException coreException) {}
        this.newProject = null;
        this.lastProjectName = null;
        this.lastProjectLocation = null;
    }

    private boolean invokeRunnable(IRunnableWithProgress runnable) {
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            CUIPlugin.errorDialog(this.getShell(), title, message, e.getTargetException(), false);
            this.clearProject();
            return false;
        }
        catch (InterruptedException interruptedException) {
            this.clearProject();
            return false;
        }
        return true;
    }

    public boolean performFinish() {
        boolean needsPost;
        boolean bl = needsPost = this.newProject != null && !this.isChanged();
        if (this.getProject(this.fMainPage.isCurrent(), true) == null) {
            return false;
        }
        this.fMainPage.h_selected.postProcess(this.newProject, needsPost);
        try {
            this.setCreated();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
        this.selectAndReveal((IResource)this.newProject);
        return true;
    }

    protected boolean setCreated() throws CoreException {
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription des = mngr.getProjectDescription(this.newProject, false);
        if (des.isCdtProjectCreating()) {
            des = mngr.getProjectDescription(this.newProject, true);
            des.setCdtProjectCreated();
            mngr.setProjectDescription(this.newProject, des, false, null);
            return true;
        }
        return false;
    }

    public boolean performCancel() {
        this.clearProject();
        return true;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fConfigElement = config;
    }

    private IRunnableWithProgress getRunnable(boolean _defaults, final boolean onFinish) {
        final boolean defaults = _defaults;
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor imonitor) throws InvocationTargetException, InterruptedException {
                CDTCommonProjectWizard.this.getShell().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        try {
                            (this).CDTCommonProjectWizard.this.newProject = CDTCommonProjectWizard.this.createIProject(CDTCommonProjectWizard.this.lastProjectName, CDTCommonProjectWizard.this.lastProjectLocation);
                            if ((this).CDTCommonProjectWizard.this.newProject != null) {
                                (this).CDTCommonProjectWizard.this.fMainPage.h_selected.createProject((this).CDTCommonProjectWizard.this.newProject, defaults, onFinish);
                            }
                        }
                        catch (CoreException e) {
                            CUIPlugin.log(e);
                        }
                    }
                });
            }
        };
    }

    public IProject createIProject(String name, URI location) throws CoreException {
        if (this.newProject != null) {
            return this.newProject;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        final IProject newProjectHandle = root.getProject(name);
        if (!newProjectHandle.exists()) {
            IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
            if (location != null) {
                description.setLocationURI(location);
            }
            this.newProject = CCorePlugin.getDefault().createCDTProject(description, newProjectHandle, (IProgressMonitor)new NullProgressMonitor());
        } else {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    newProjectHandle.refreshLocal(2, monitor);
                }
            };
            NullProgressMonitor monitor = new NullProgressMonitor();
            workspace.run(runnable, (ISchedulingRule)root, 1, (IProgressMonitor)monitor);
            this.newProject = newProjectHandle;
        }
        if (!this.newProject.isOpen()) {
            this.newProject.open((IProgressMonitor)new NullProgressMonitor());
        }
        return this.continueCreation(this.newProject);
    }

    protected abstract IProject continueCreation(IProject var1);

    public abstract String[] getNatures();

    public void dispose() {
        this.fMainPage.dispose();
    }

    public boolean canFinish() {
        if (this.fMainPage.h_selected != null) {
            if (!this.fMainPage.h_selected.canFinish()) {
                return false;
            }
            String s = this.fMainPage.h_selected.getErrorMessage();
            if (s != null) {
                return false;
            }
        }
        return super.canFinish();
    }

    public String getLastProjectName() {
        return this.lastProjectName;
    }

    public URI getLastProjectLocation() {
        return this.lastProjectLocation;
    }

    public IProject getLastProject() {
        return this.newProject;
    }

    public String[] getLanguageIDs() {
        return EMPTY_ARR;
    }

    public String[] getContentTypeIDs() {
        return EMPTY_ARR;
    }

    public String[] getExtensions() {
        return EMPTY_ARR;
    }
}

