/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.callhierarchy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IEnumerator;
import org.eclipse.cdt.core.model.IMacro;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.cdt.internal.ui.callhierarchy.CHReferenceInfo;
import org.eclipse.cdt.internal.ui.util.CoreUtility;
import org.eclipse.core.runtime.IAdaptable;

public class CHNode
implements IAdaptable {
    private CHNode fParent;
    private ICElement fRepresentedDecl;
    private ITranslationUnit fFileOfReferences;
    private List<CHReferenceInfo> fReferences;
    protected int fHashCode;
    private long fTimestamp;
    private boolean fIsRecursive;
    private boolean fIsInitializer;
    private boolean fIsReadAccess;
    private boolean fIsWriteAccess;

    public CHNode(CHNode parent, ITranslationUnit fileOfReferences, long timestamp, ICElement decl) {
        this.fParent = parent;
        this.fFileOfReferences = fileOfReferences;
        this.fReferences = Collections.emptyList();
        this.fRepresentedDecl = decl;
        this.fIsRecursive = this.computeIsRecursive(this.fParent, decl);
        this.fHashCode = this.computeHashCode();
        this.fTimestamp = timestamp;
    }

    private int computeHashCode() {
        int hashCode = 1;
        if (this.fParent != null) {
            hashCode = this.fParent.hashCode() * 31;
        }
        if (this.fRepresentedDecl != null) {
            hashCode += this.fRepresentedDecl.hashCode();
        }
        return hashCode;
    }

    public int hashCode() {
        return this.fHashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CHNode)) {
            return false;
        }
        CHNode rhs = (CHNode)o;
        if (this.fHashCode != rhs.fHashCode) {
            return false;
        }
        return CoreUtility.safeEquals(this.fRepresentedDecl, rhs.fRepresentedDecl);
    }

    private boolean computeIsRecursive(CHNode parent, ICElement decl) {
        if (parent == null || decl == null) {
            return false;
        }
        if (decl.equals(parent.fRepresentedDecl)) {
            return true;
        }
        return this.computeIsRecursive(parent.fParent, decl);
    }

    public CHNode getParent() {
        return this.fParent;
    }

    public boolean isRecursive() {
        return this.fIsRecursive;
    }

    public int getReferenceCount() {
        return this.fReferences.size();
    }

    public CHReferenceInfo getReference(int idx) {
        return this.fReferences.get(idx);
    }

    public ICElement getRepresentedDeclaration() {
        return this.fRepresentedDecl;
    }

    public long getTimestamp() {
        return this.fTimestamp;
    }

    public boolean isMacro() {
        return this.fRepresentedDecl instanceof IMacro;
    }

    public boolean isVariableOrEnumerator() {
        return this.fRepresentedDecl instanceof IVariableDeclaration || this.fRepresentedDecl instanceof IEnumerator;
    }

    public int getFirstReferenceOffset() {
        return this.fReferences.isEmpty() ? -1 : this.getReference(0).getOffset();
    }

    public void addReference(CHReferenceInfo info) {
        switch (this.fReferences.size()) {
            case 0: {
                this.fReferences = Collections.singletonList(info);
                return;
            }
            case 1: {
                this.fReferences = new ArrayList<CHReferenceInfo>(this.fReferences);
            }
        }
        this.fReferences.add(info);
    }

    public ITranslationUnit getFileOfReferences() {
        return this.fFileOfReferences;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ICElement.class)) {
            return this.getRepresentedDeclaration();
        }
        return null;
    }

    public boolean isMultiDef() {
        return false;
    }

    public ICElement getOneRepresentedDeclaration() {
        return this.getRepresentedDeclaration();
    }

    public boolean isInitializer() {
        return this.fIsInitializer;
    }

    public void setInitializer(boolean isInitializer) {
        this.fIsInitializer = isInitializer;
    }

    public void sortReferencesByOffset() {
        if (this.fReferences.size() > 1) {
            Collections.sort(this.fReferences, CHReferenceInfo.COMPARE_OFFSET);
        }
    }

    public void setRWAccess(boolean readAccess, boolean writeAccess) {
        this.fIsReadAccess = readAccess;
        this.fIsWriteAccess = writeAccess;
    }

    public boolean isReadAccess() {
        return this.fIsReadAccess;
    }

    public boolean isWriteAccess() {
        return this.fIsWriteAccess;
    }
}

