/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.includebrowser;

import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.includebrowser.IBMessages;
import org.eclipse.cdt.internal.ui.includebrowser.IBViewPart;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.ResourceTransfer;

public class IBDropTargetListener
implements DropTargetListener {
    private IBViewPart fIncludeBrowser;
    private ITranslationUnit fTranslationUnit;
    private boolean fEnabled = true;

    public IBDropTargetListener(IBViewPart view) {
        this.fIncludeBrowser = view;
    }

    public void setEnabled(boolean val) {
        this.fEnabled = val;
    }

    public void dragEnter(DropTargetEvent event) {
        this.fTranslationUnit = null;
        this.checkOperation(event);
        if (event.detail != 0 && LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType)) {
            this.fTranslationUnit = this.checkLocalSelection();
            if (this.fTranslationUnit == null) {
                TransferData alternateDataType = this.checkForAlternateDataType(event.dataTypes, new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance()});
                if (alternateDataType == null) {
                    event.detail = 0;
                } else {
                    event.currentDataType = alternateDataType;
                }
            }
        }
    }

    private TransferData checkForAlternateDataType(TransferData[] dataTypes, Transfer[] transfers) {
        int i = 0;
        while (i < dataTypes.length) {
            TransferData dataType = dataTypes[i];
            int j = 0;
            while (j < transfers.length) {
                Transfer transfer = transfers[j];
                if (transfer.isSupportedType(dataType)) {
                    return dataType;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private ITranslationUnit checkLocalSelection() {
        ISelection sel = LocalSelectionTransfer.getTransfer().getSelection();
        if (sel instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)sel) {
                if (!(element instanceof ITranslationUnit)) continue;
                return (ITranslationUnit)element;
            }
        }
        return null;
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.checkOperation(event);
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        if (this.fTranslationUnit == null) {
            this.fTranslationUnit = this.findFirstTranslationUnit(event.data);
        }
        if (this.fTranslationUnit == null) {
            this.fIncludeBrowser.setMessage(IBMessages.IBViewPart_falseInputMessage);
            Display.getCurrent().beep();
        } else {
            this.fIncludeBrowser.setInput(this.fTranslationUnit);
        }
    }

    private ITranslationUnit findFirstTranslationUnit(Object o) {
        if (o instanceof String[]) {
            String[] filePaths = (String[])o;
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            int i = 0;
            while (i < filePaths.length) {
                String filePath = filePaths[i];
                ITranslationUnit tu = this.findTranslationUnit((IResource[])root.findFilesForLocation(Path.fromOSString((String)filePath)));
                if (tu != null) {
                    return tu;
                }
                ++i;
            }
            return null;
        }
        if (o instanceof IResource[]) {
            return this.findTranslationUnit((IResource[])o);
        }
        return null;
    }

    private ITranslationUnit findTranslationUnit(IResource[] files) {
        int i = 0;
        while (i < files.length) {
            ITranslationUnit tu;
            IResource resource = files[i];
            if (resource.getType() == 1 && (tu = CoreModelUtil.findTranslationUnit((IFile)((IFile)resource))) != null) {
                return tu;
            }
            ++i;
        }
        return null;
    }

    public void dropAccept(DropTargetEvent event) {
    }

    private void checkOperation(DropTargetEvent event) {
        event.detail = this.fEnabled && (event.operations & 1) != 0 ? 1 : 0;
    }
}

