/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.includebrowser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.includebrowser.IBContentProvider;
import org.eclipse.cdt.internal.ui.includebrowser.IBConversions;
import org.eclipse.cdt.internal.ui.includebrowser.IBDragSourceListener;
import org.eclipse.cdt.internal.ui.includebrowser.IBDropTargetListener;
import org.eclipse.cdt.internal.ui.includebrowser.IBFile;
import org.eclipse.cdt.internal.ui.includebrowser.IBHistoryDropDownAction;
import org.eclipse.cdt.internal.ui.includebrowser.IBLabelProvider;
import org.eclipse.cdt.internal.ui.includebrowser.IBMessages;
import org.eclipse.cdt.internal.ui.includebrowser.IBNode;
import org.eclipse.cdt.internal.ui.includebrowser.IBSetInputJob;
import org.eclipse.cdt.internal.ui.includebrowser.IBWorkingSetFilter;
import org.eclipse.cdt.internal.ui.navigator.OpenCElementAction;
import org.eclipse.cdt.internal.ui.util.Messages;
import org.eclipse.cdt.internal.ui.viewsupport.EditorOpener;
import org.eclipse.cdt.internal.ui.viewsupport.ExtendedTreeViewer;
import org.eclipse.cdt.internal.ui.viewsupport.IndexUI;
import org.eclipse.cdt.internal.ui.viewsupport.TreeNavigator;
import org.eclipse.cdt.internal.ui.viewsupport.WorkingSetFilterUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.actions.OpenFileAction;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;

public class IBViewPart
extends ViewPart
implements IShowInSource,
IShowInTarget,
IShowInTargetList {
    private static final int MAX_HISTORY_SIZE = 10;
    private static final String TRUE = String.valueOf(true);
    private static final String KEY_WORKING_SET_FILTER = "workingSetFilter";
    private static final String KEY_FILTER_SYSTEM = "systemFilter";
    private static final String KEY_FILTER_INACTIVE = "inactiveFilter";
    private static final String KEY_INPUT_PATH = "inputPath";
    private IMemento fMemento;
    private boolean fShowsMessage;
    private IBNode fLastNavigationNode;
    private ArrayList<ITranslationUnit> fHistoryEntries = new ArrayList(10);
    private PageBook fPagebook;
    private Composite fViewerPage;
    private Label fInfoText;
    private IBContentProvider fContentProvider;
    private IBLabelProvider fLabelProvider;
    private ExtendedTreeViewer fTreeViewer;
    private IBWorkingSetFilter fWorkingSetFilter;
    private ViewerFilter fInactiveFilter;
    private ViewerFilter fSystemFilter;
    private ViewerComparator fSorterAlphaNumeric;
    private ViewerComparator fSorterReferencePosition;
    private Action fIncludedByAction;
    private Action fIncludesToAction;
    private Action fFilterInactiveAction;
    private Action fFilterSystemAction;
    private Action fShowFolderInLabelsAction;
    private Action fNextAction;
    private Action fPreviousAction;
    private Action fRefreshAction;
    private Action fHistoryAction;
    private IContextActivation fContextActivation;
    private WorkingSetFilterUI fWorkingSetFilterUI;
    private IBSetInputJob fSetInputJob;

    public void setFocus() {
        this.fPagebook.setFocus();
    }

    public void setMessage(String msg) {
        this.fInfoText.setText(msg);
        this.fPagebook.showPage((Control)this.fInfoText);
        this.fShowsMessage = true;
        this.updateActionEnablement();
        this.updateDescription();
    }

    public void setInput(ITranslationUnit input) {
        if (this.fPagebook.isDisposed()) {
            return;
        }
        if (input instanceof IWorkingCopy) {
            input = ((IWorkingCopy)input).getOriginalElement();
        }
        this.fSetInputJob.cancel();
        if (input == null) {
            this.setMessage(IBMessages.IBViewPart_instructionMessage);
            this.fTreeViewer.setInput(null);
            return;
        }
        if (CCorePlugin.getIndexManager().isIndexerIdle()) {
            this.setInputIndexerIdle(input);
        } else {
            this.setMessage(IBMessages.IBViewPart_waitingOnIndexerMessage);
            this.fSetInputJob.setInput(input);
            this.fSetInputJob.schedule();
        }
    }

    private void setInputIndexerIdle(final ITranslationUnit input) {
        this.fShowsMessage = false;
        boolean isHeader = input.isHeaderUnit();
        this.fTreeViewer.setInput(null);
        if (!isHeader) {
            this.fContentProvider.setComputeIncludedBy(isHeader);
            this.fIncludedByAction.setChecked(isHeader);
            this.fIncludesToAction.setChecked(!isHeader);
            this.fIncludedByAction.setEnabled(false);
            this.updateSorter();
        } else {
            this.fIncludedByAction.setEnabled(true);
        }
        this.fTreeViewer.setInput(input);
        this.fPagebook.showPage((Control)this.fViewerPage);
        this.updateHistory(input);
        this.updateActionEnablement();
        this.updateDescription();
        final Display display = Display.getCurrent();
        Job job = new Job(IBMessages.IBViewPart_jobCheckInput){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus iStatus;
                ICProject[] projects = CoreModel.getDefault().getCModel().getCProjects();
                IIndex index = CCorePlugin.getIndexManager().getIndex(projects);
                index.acquireReadLock();
                try {
                    if (!IndexUI.isIndexed(index, (ICElement)input)) {
                        final String msg = IndexUI.getFileNotIndexedMessage((ICElement)input);
                        display.asyncExec(new Runnable(){

                            public void run() {
                                if (IBViewPart.this.fTreeViewer.getInput() == input) {
                                    IBViewPart.this.setMessage(msg);
                                    IBViewPart.this.fTreeViewer.setInput(null);
                                }
                            }
                        });
                    }
                    iStatus = Status.OK_STATUS;
                }
                catch (Throwable throwable) {
                    try {
                        index.releaseReadLock();
                        throw throwable;
                    }
                    catch (CoreException coreException) {
                        return Status.OK_STATUS;
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                        return Status.CANCEL_STATUS;
                    }
                }
                index.releaseReadLock();
                return iStatus;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void updateActionEnablement() {
        this.fHistoryAction.setEnabled(!this.fHistoryEntries.isEmpty());
        this.fNextAction.setEnabled(!this.fShowsMessage);
        this.fPreviousAction.setEnabled(!this.fShowsMessage);
        this.fRefreshAction.setEnabled(!this.fShowsMessage);
    }

    public void createPartControl(Composite parent) {
        this.fSetInputJob = new IBSetInputJob(this, Display.getCurrent());
        this.fPagebook = new PageBook(parent, 0);
        this.fPagebook.setLayoutData((Object)new GridData(1808));
        this.createInfoPage();
        this.createViewerPage();
        this.initDragAndDrop();
        this.createActions();
        this.createContextMenu();
        this.getSite().setSelectionProvider((ISelectionProvider)this.fTreeViewer);
        this.setMessage(IBMessages.IBViewPart_instructionMessage);
        this.initializeActionStates();
        this.restoreInput();
        this.fMemento = null;
        IContextService ctxService = (IContextService)this.getSite().getService(IContextService.class);
        if (ctxService != null) {
            this.fContextActivation = ctxService.activateContext("org.eclipse.cdt.ui.cViewScope");
        }
    }

    public void dispose() {
        IContextService ctxService;
        if (this.fContextActivation != null && (ctxService = (IContextService)this.getSite().getService(IContextService.class)) != null) {
            ctxService.deactivateContext(this.fContextActivation);
        }
        if (this.fWorkingSetFilterUI != null) {
            this.fWorkingSetFilterUI.dispose();
        }
    }

    private void initializeActionStates() {
        boolean includedBy = true;
        boolean filterSystem = false;
        boolean filterInactive = false;
        if (this.fMemento != null) {
            filterSystem = TRUE.equals(this.fMemento.getString(KEY_FILTER_SYSTEM));
            filterInactive = TRUE.equals(this.fMemento.getString(KEY_FILTER_INACTIVE));
        }
        this.fIncludedByAction.setChecked(includedBy);
        this.fIncludesToAction.setChecked(!includedBy);
        this.fContentProvider.setComputeIncludedBy(includedBy);
        this.fFilterInactiveAction.setChecked(filterInactive);
        this.fFilterInactiveAction.run();
        this.fFilterSystemAction.setChecked(filterSystem);
        this.fFilterSystemAction.run();
        this.updateSorter();
    }

    private void restoreInput() {
        IPath path;
        String pathStr;
        if (this.fMemento != null && (pathStr = this.fMemento.getString(KEY_INPUT_PATH)) != null && (path = Path.fromPortableString((String)pathStr)).segmentCount() > 1) {
            String name = path.segment(0);
            ICProject project = CoreModel.getDefault().getCModel().getCProject(name);
            if (project != null) {
                try {
                    ICElement celement = project.findElement(path);
                    if (celement instanceof ITranslationUnit) {
                        this.setInput((ITranslationUnit)celement);
                    }
                }
                catch (CModelException cModelException) {}
            }
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.fMemento = memento;
        super.init(site, memento);
    }

    public void saveState(IMemento memento) {
        IPath path;
        if (this.fWorkingSetFilter != null) {
            this.fWorkingSetFilter.getUI().saveState(memento, KEY_WORKING_SET_FILTER);
        }
        memento.putString(KEY_FILTER_INACTIVE, String.valueOf(this.fFilterInactiveAction.isChecked()));
        memento.putString(KEY_FILTER_SYSTEM, String.valueOf(this.fFilterSystemAction.isChecked()));
        ITranslationUnit input = this.getInput();
        if (input != null && (path = input.getPath()) != null) {
            memento.putString(KEY_INPUT_PATH, path.toPortableString());
        }
        super.saveState(memento);
    }

    private void createContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                IBViewPart.this.onContextMenuAboutToShow(m);
            }
        });
        Menu menu = manager.createContextMenu(this.fTreeViewer.getControl());
        this.fTreeViewer.getControl().setMenu(menu);
        IWorkbenchPartSite site = this.getSite();
        site.registerContextMenu("org.eclipse.cdt.ui.includeBrowser", manager, (ISelectionProvider)this.fTreeViewer);
    }

    private void createViewerPage() {
        Display display = this.getSite().getShell().getDisplay();
        this.fViewerPage = new Composite((Composite)this.fPagebook, 0);
        this.fViewerPage.setLayoutData((Object)new GridData(1808));
        this.fViewerPage.setSize(100, 100);
        this.fViewerPage.setLayout((Layout)new FillLayout());
        this.fContentProvider = new IBContentProvider(display);
        this.fLabelProvider = new IBLabelProvider(display, this.fContentProvider);
        this.fTreeViewer = new ExtendedTreeViewer(this.fViewerPage);
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        this.fTreeViewer.setAutoExpandLevel(2);
        this.fTreeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IBViewPart.this.onShowInclude(event.getSelection());
            }
        });
    }

    private void createInfoPage() {
        this.fInfoText = new Label((Composite)this.fPagebook, 16576);
    }

    private void initDragAndDrop() {
        IBDropTargetListener dropListener = new IBDropTargetListener(this);
        Transfer[] dropTransfers = new Transfer[]{LocalSelectionTransfer.getTransfer(), ResourceTransfer.getInstance(), FileTransfer.getInstance()};
        DropTarget dropTarget = new DropTarget((Control)this.fPagebook, 23);
        dropTarget.setTransfer(dropTransfers);
        dropTarget.addDropListener((DropTargetListener)dropListener);
        Transfer[] dragTransfers = new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance()};
        IBDragSourceListener dragListener = new IBDragSourceListener(this.fTreeViewer);
        dragListener.setDependentDropTargetListener(dropListener);
        this.fTreeViewer.addDragSupport(1, dragTransfers, dragListener);
    }

    private void createActions() {
        this.fWorkingSetFilterUI = new WorkingSetFilterUI((IViewPart)this, this.fMemento, KEY_WORKING_SET_FILTER){

            protected void onWorkingSetChange() {
                IBViewPart.this.updateWorkingSetFilter(this);
            }

            protected void onWorkingSetNameChange() {
                IBViewPart.this.updateDescription();
            }
        };
        this.fIncludedByAction = new Action(IBMessages.IBViewPart_showIncludedBy_label, 8){

            public void run() {
                if (this.isChecked()) {
                    IBViewPart.this.onSetDirection(true);
                }
            }
        };
        this.fIncludedByAction.setToolTipText(IBMessages.IBViewPart_showIncludedBy_tooltip);
        CPluginImages.setImageDescriptors((IAction)this.fIncludedByAction, "lcl16/", "org.eclipse.cdt.ui.ch_callers.gif");
        this.fIncludesToAction = new Action(IBMessages.IBViewPart_showIncludesTo_label, 8){

            public void run() {
                if (this.isChecked()) {
                    IBViewPart.this.onSetDirection(false);
                }
            }
        };
        this.fIncludesToAction.setToolTipText(IBMessages.IBViewPart_showIncludesTo_tooltip);
        CPluginImages.setImageDescriptors((IAction)this.fIncludesToAction, "lcl16/", "org.eclipse.cdt.ui.ch_callees.gif");
        this.fInactiveFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IBNode) {
                    IBNode node = (IBNode)element;
                    return node.isActiveCode();
                }
                return true;
            }
        };
        this.fFilterInactiveAction = new Action(IBMessages.IBViewPart_hideInactive_label, 2){

            public void run() {
                if (this.isChecked()) {
                    IBViewPart.this.fTreeViewer.addFilter(IBViewPart.this.fInactiveFilter);
                } else {
                    IBViewPart.this.fTreeViewer.removeFilter(IBViewPart.this.fInactiveFilter);
                }
            }
        };
        this.fFilterInactiveAction.setToolTipText(IBMessages.IBViewPart_hideInactive_tooltip);
        CPluginImages.setImageDescriptors((IAction)this.fFilterInactiveAction, "lcl16/", "org.eclipse.cdt.ui.filterInactive.gif");
        this.fSystemFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IBNode) {
                    IBNode node = (IBNode)element;
                    return !node.isSystemInclude();
                }
                return true;
            }
        };
        this.fFilterSystemAction = new Action(IBMessages.IBViewPart_hideSystem_label, 2){

            public void run() {
                if (this.isChecked()) {
                    IBViewPart.this.fTreeViewer.addFilter(IBViewPart.this.fSystemFilter);
                } else {
                    IBViewPart.this.fTreeViewer.removeFilter(IBViewPart.this.fSystemFilter);
                }
            }
        };
        this.fFilterSystemAction.setToolTipText(IBMessages.IBViewPart_hideSystem_tooltip);
        CPluginImages.setImageDescriptors((IAction)this.fFilterSystemAction, "lcl16/", "org.eclipse.cdt.ui.filterSystem.gif");
        this.fSorterAlphaNumeric = new ViewerComparator();
        this.fSorterReferencePosition = new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof IBNode) {
                    return 0;
                }
                return 1;
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (!(e1 instanceof IBNode)) {
                    if (!(e2 instanceof IBNode)) {
                        return 0;
                    }
                    return -1;
                }
                if (!(e2 instanceof IBNode)) {
                    return 1;
                }
                IBNode n1 = (IBNode)e1;
                IBNode n2 = (IBNode)e2;
                return n1.getDirectiveCharacterOffset() - n2.getDirectiveCharacterOffset();
            }
        };
        this.fShowFolderInLabelsAction = new Action(IBMessages.IBViewPart_showFolders_label, 2){

            public void run() {
                IBViewPart.this.onShowFolderInLabels(this.isChecked());
            }
        };
        this.fShowFolderInLabelsAction.setToolTipText(IBMessages.IBViewPart_showFolders_tooltip);
        this.fNextAction = new Action(IBMessages.IBViewPart_nextMatch_label){

            public void run() {
                IBViewPart.this.onNextOrPrevious(true);
            }
        };
        this.fNextAction.setToolTipText(IBMessages.IBViewPart_nextMatch_tooltip);
        CPluginImages.setImageDescriptors((IAction)this.fNextAction, "lcl16/", "org.eclipse.cdt.ui.search_next.gif");
        this.fPreviousAction = new Action(IBMessages.IBViewPart_previousMatch_label){

            public void run() {
                IBViewPart.this.onNextOrPrevious(false);
            }
        };
        this.fPreviousAction.setToolTipText(IBMessages.IBViewPart_previousMatch_tooltip);
        CPluginImages.setImageDescriptors((IAction)this.fPreviousAction, "lcl16/", "org.eclipse.cdt.ui.search_prev.gif");
        this.fRefreshAction = new Action(IBMessages.IBViewPart_refresh_label){

            public void run() {
                IBViewPart.this.onRefresh();
            }
        };
        this.fRefreshAction.setToolTipText(IBMessages.IBViewPart_refresh_tooltip);
        CPluginImages.setImageDescriptors((IAction)this.fRefreshAction, "lcl16/", "org.eclipse.cdt.ui.refresh_nav.gif");
        this.fHistoryAction = new IBHistoryDropDownAction(this);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this.fNextAction);
        actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this.fPreviousAction);
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.fRefreshAction);
        actionBars.updateActionBars();
        IToolBarManager tm = actionBars.getToolBarManager();
        tm.add((IAction)this.fNextAction);
        tm.add((IAction)this.fPreviousAction);
        tm.add((IContributionItem)new Separator());
        tm.add((IAction)this.fFilterSystemAction);
        tm.add((IAction)this.fFilterInactiveAction);
        tm.add((IContributionItem)new Separator());
        tm.add((IAction)this.fIncludedByAction);
        tm.add((IAction)this.fIncludesToAction);
        tm.add((IAction)this.fHistoryAction);
        tm.add((IAction)this.fRefreshAction);
        IMenuManager mm = actionBars.getMenuManager();
        this.fWorkingSetFilterUI.fillActionBars(actionBars);
        mm.add((IAction)this.fIncludedByAction);
        mm.add((IAction)this.fIncludesToAction);
        mm.add((IContributionItem)new Separator());
        mm.add((IAction)this.fShowFolderInLabelsAction);
        mm.add((IContributionItem)new Separator());
        mm.add((IAction)this.fFilterSystemAction);
        mm.add((IAction)this.fFilterInactiveAction);
    }

    private IBNode getNextNode(boolean forward) {
        TreeNavigator navigator = new TreeNavigator(this.fTreeViewer.getTree(), IBNode.class);
        TreeItem selectedItem = navigator.getSelectedItemOrFirstOnLevel(1, forward);
        if (selectedItem == null) {
            return null;
        }
        if (selectedItem.getData().equals(this.fLastNavigationNode)) {
            selectedItem = navigator.getNextSibbling(selectedItem, forward);
        }
        return selectedItem == null ? null : (IBNode)selectedItem.getData();
    }

    protected void onNextOrPrevious(boolean forward) {
        IBNode nextItem = this.getNextNode(forward);
        if (nextItem != null) {
            StructuredSelection sel = new StructuredSelection((Object)nextItem);
            this.fTreeViewer.setSelection((ISelection)sel);
            this.onShowInclude((ISelection)sel);
        }
    }

    protected void onRefresh() {
        this.fContentProvider.recompute();
    }

    protected void onShowFolderInLabels(boolean show) {
        this.fLabelProvider.setShowFolders(show);
        this.fTreeViewer.refresh();
    }

    private void updateHistory(ITranslationUnit input) {
        if (input != null) {
            this.fHistoryEntries.remove(input);
            this.fHistoryEntries.add(0, input);
            if (this.fHistoryEntries.size() > 10) {
                this.fHistoryEntries.remove(9);
            }
        }
    }

    private void updateSorter() {
        if (this.fIncludedByAction.isChecked()) {
            this.fTreeViewer.setComparator(this.fSorterAlphaNumeric);
        } else {
            this.fTreeViewer.setComparator(this.fSorterReferencePosition);
        }
    }

    private void updateDescription() {
        IPath path;
        ITranslationUnit tu;
        String message = "";
        if (!this.fShowsMessage && (tu = this.getInput()) != null && (path = tu.getPath()) != null) {
            String file = String.valueOf(path.lastSegment()) + "(" + path.removeLastSegments(1) + ")";
            String scope = this.fWorkingSetFilter == null ? IBMessages.IBViewPart_workspaceScope : this.fWorkingSetFilter.getLabel();
            String format = this.fIncludedByAction.isChecked() ? IBMessages.IBViewPart_IncludedByContentDescription : IBMessages.IBViewPart_IncludesToContentDescription;
            message = Messages.format(format, file, scope);
        }
        this.setContentDescription(message);
    }

    private void updateWorkingSetFilter(WorkingSetFilterUI filterUI) {
        if (filterUI.getWorkingSet() == null) {
            if (this.fWorkingSetFilter != null) {
                this.fTreeViewer.removeFilter(this.fWorkingSetFilter);
                this.fWorkingSetFilter = null;
            }
        } else if (this.fWorkingSetFilter != null) {
            this.fTreeViewer.refresh();
        } else {
            this.fWorkingSetFilter = new IBWorkingSetFilter(filterUI);
            this.fTreeViewer.addFilter(this.fWorkingSetFilter);
        }
    }

    public void onSetDirection(boolean includedBy) {
        if (includedBy != this.fContentProvider.getComputeIncludedBy()) {
            Object input = this.fTreeViewer.getInput();
            this.fTreeViewer.setInput(null);
            this.fContentProvider.setComputeIncludedBy(includedBy);
            this.updateSorter();
            this.fTreeViewer.setInput(input);
            this.updateDescription();
        }
    }

    protected void onContextMenuAboutToShow(IMenuManager m) {
        final IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
        IBNode node = IBConversions.selectionToNode((ISelection)selection);
        if (node != null) {
            ITranslationUnit tu;
            IWorkbenchPage page = this.getSite().getPage();
            if (node.getParent() != null && node.getDirectiveFile() != null) {
                m.add((IAction)new Action(IBMessages.IBViewPart_showInclude_label){

                    public void run() {
                        IBViewPart.this.onShowInclude((ISelection)selection);
                    }
                });
            }
            if ((tu = node.getRepresentedTranslationUnit()) != null) {
                OpenCElementAction ofa = new OpenCElementAction(page);
                ofa.selectionChanged(selection);
                m.add((IAction)ofa);
                MenuManager submenu = new MenuManager(IBMessages.IBViewPart_ShowInMenu_label);
                submenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(this.getSite().getWorkbenchWindow()));
                m.add((IContributionItem)submenu);
                if (node.getParent() != null) {
                    m.add((IContributionItem)new Separator());
                    m.add((IAction)new Action(Messages.format(IBMessages.IBViewPart_FocusOn_label, tu.getPath().lastSegment())){

                        public void run() {
                            IBViewPart.this.setInput(tu);
                        }
                    });
                }
            }
        }
        m.add((IContributionItem)new Separator("additions"));
    }

    protected void onShowInclude(ISelection selection) {
        IBNode node = IBConversions.selectionToNode(selection);
        if (node != null) {
            this.fLastNavigationNode = node;
            IWorkbenchPage page = this.getSite().getPage();
            IBFile ibf = node.getDirectiveFile();
            if (ibf != null) {
                Region region = new Region(node.getDirectiveCharacterOffset(), node.getDirectiveLength());
                long timestamp = node.getTimestamp();
                IFile f = ibf.getResource();
                if (f != null) {
                    EditorOpener.open(page, f, (IRegion)region, timestamp);
                } else {
                    IPath location;
                    IIndexFileLocation ifl = ibf.getLocation();
                    if (ifl != null && (location = IndexLocationFactory.getAbsolutePath((IIndexFileLocation)ifl)) != null) {
                        EditorOpener.openExternalFile(page, location, (IRegion)region, timestamp);
                    }
                }
            } else {
                IResource r;
                ITranslationUnit tu = IBConversions.selectionToTU(selection);
                if (tu != null && (r = tu.getResource()) != null) {
                    OpenFileAction ofa = new OpenFileAction(page);
                    ofa.selectionChanged((IStructuredSelection)selection);
                    ofa.run();
                }
            }
        }
    }

    public ShowInContext getShowInContext() {
        return new ShowInContext(null, IBConversions.nodeSelectionToRepresentedTUSelection(this.fTreeViewer.getSelection()));
    }

    public boolean show(ShowInContext context) {
        ITranslationUnit tu = IBConversions.selectionToTU(context.getSelection());
        if (tu == null && (tu = IBConversions.objectToTU(context.getInput())) == null) {
            this.setMessage(IBMessages.IBViewPart_falseInputMessage);
            return false;
        }
        this.setInput(tu);
        return true;
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.ui.navigator.ProjectExplorer", "org.eclipse.ui.views.ResourceNavigator"};
    }

    public TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    public ITranslationUnit[] getHistoryEntries() {
        return this.fHistoryEntries.toArray(new ITranslationUnit[this.fHistoryEntries.size()]);
    }

    public void setHistoryEntries(ITranslationUnit[] remaining) {
        this.fHistoryEntries.clear();
        this.fHistoryEntries.addAll((Collection<ITranslationUnit>)Arrays.asList(remaining));
    }

    public ITranslationUnit getInput() {
        Object input = this.fTreeViewer.getInput();
        if (input instanceof ITranslationUnit) {
            return (ITranslationUnit)input;
        }
        return null;
    }
}

