/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.cdt.internal.ui.preferences.formatter.CPreview;
import org.eclipse.cdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.cdt.internal.ui.preferences.formatter.IModifyDialogTabPage;
import org.eclipse.cdt.internal.ui.util.Messages;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModifyDialogTabPage
implements IModifyDialogTabPage {
    protected final Observer fUpdater = new Observer(){

        public void update(Observable o, Object arg) {
            ModifyDialogTabPage.this.doUpdatePreview();
            ModifyDialogTabPage.this.notifyValuesModified();
        }
    };
    protected final DefaultFocusManager fDefaultFocusManager;
    protected PixelConverter fPixelConverter;
    protected Map<String, String> fWorkingValues;
    private IModifyDialogTabPage.IModificationListener fModifyListener;

    public ModifyDialogTabPage(IModifyDialogTabPage.IModificationListener modifyListener, Map<String, String> workingValues) {
        this.fWorkingValues = workingValues;
        this.fModifyListener = modifyListener;
        this.fDefaultFocusManager = new DefaultFocusManager();
    }

    public ModifyDialogTabPage() {
        this.fDefaultFocusManager = new DefaultFocusManager();
    }

    @Override
    public void setWorkingValues(Map<String, String> workingValues) {
        this.fWorkingValues = workingValues;
    }

    @Override
    public void setModifyListener(IModifyDialogTabPage.IModificationListener modifyListener) {
        this.fModifyListener = modifyListener;
    }

    @Override
    public final Composite createContents(Composite parent) {
        if (this.fPixelConverter == null) {
            this.fPixelConverter = new PixelConverter((Control)parent);
        }
        SashForm sashForm = new SashForm(parent, 256);
        sashForm.setFont(parent.getFont());
        Composite scrollContainer = new Composite((Composite)sashForm, 0);
        GridData gridData = new GridData(4, 4, true, true);
        scrollContainer.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        scrollContainer.setLayout((Layout)layout);
        ScrolledComposite scroll = new ScrolledComposite(scrollContainer, 768);
        scroll.setLayoutData((Object)new GridData(4, 4, true, true));
        scroll.setExpandHorizontal(true);
        scroll.setExpandVertical(true);
        final Composite settingsContainer = new Composite((Composite)scroll, 0);
        settingsContainer.setFont(sashForm.getFont());
        scroll.setContent((Control)settingsContainer);
        settingsContainer.setLayout((Layout)new PageLayout(scroll, 400, 400));
        settingsContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite settingsPane = new Composite(settingsContainer, 0);
        settingsPane.setLayoutData((Object)new GridData(4, 4, true, true));
        layout = new GridLayout(4, false);
        layout.verticalSpacing = (int)(1.5 * (double)this.fPixelConverter.convertVerticalDLUsToPixels(4));
        layout.horizontalSpacing = this.fPixelConverter.convertHorizontalDLUsToPixels(4);
        layout.marginHeight = this.fPixelConverter.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.fPixelConverter.convertHorizontalDLUsToPixels(7);
        settingsPane.setLayout((Layout)layout);
        this.doCreatePreferences(settingsPane, 4);
        settingsContainer.setSize(settingsContainer.computeSize(-1, -1));
        scroll.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                settingsContainer.setSize(settingsContainer.computeSize(-1, -1));
            }
        });
        Label sashHandle = new Label(scrollContainer, 514);
        gridData = new GridData(131072, 4, false, true);
        sashHandle.setLayoutData((Object)gridData);
        Composite previewPane = new Composite((Composite)sashForm, 0);
        previewPane.setLayout((Layout)this.createGridLayout(4, true));
        previewPane.setFont(sashForm.getFont());
        this.doCreatePreviewPane(previewPane, 4);
        this.initializePage();
        sashForm.setWeights(new int[]{3, 3});
        return sashForm;
    }

    protected abstract void initializePage();

    protected abstract void doCreatePreferences(Composite var1, int var2);

    protected Composite doCreatePreviewPane(Composite composite, int numColumns) {
        ModifyDialogTabPage.createLabel(numColumns, composite, FormatterMessages.ModifyDialogTabPage_preview_label_text);
        CPreview preview = this.doCreateCPreview(composite);
        this.fDefaultFocusManager.add(preview.getControl());
        GridData gd = ModifyDialogTabPage.createGridData(numColumns, 1808, 0);
        gd.widthHint = 0;
        gd.heightHint = 0;
        preview.getControl().setLayoutData((Object)gd);
        return composite;
    }

    protected abstract CPreview doCreateCPreview(Composite var1);

    @Override
    public final void makeVisible() {
        this.fDefaultFocusManager.resetFocus();
        this.doUpdatePreview();
    }

    protected abstract void doUpdatePreview();

    protected void notifyValuesModified() {
        this.fModifyListener.valuesModified();
    }

    @Override
    public void setInitialFocus() {
        if (this.fDefaultFocusManager.isUsed()) {
            this.fDefaultFocusManager.restoreFocus();
        }
    }

    protected void updateStatus(IStatus status) {
        this.fModifyListener.updateStatus(status);
    }

    protected GridLayout createGridLayout(int numColumns, boolean margins) {
        GridLayout layout = new GridLayout(numColumns, false);
        layout.verticalSpacing = this.fPixelConverter.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.fPixelConverter.convertHorizontalDLUsToPixels(4);
        if (margins) {
            layout.marginHeight = this.fPixelConverter.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.fPixelConverter.convertHorizontalDLUsToPixels(7);
        } else {
            layout.marginHeight = 0;
            layout.marginWidth = 0;
        }
        return layout;
    }

    protected static GridData createGridData(int numColumns, int style, int widthHint) {
        GridData gd = new GridData(style);
        gd.horizontalSpan = numColumns;
        gd.widthHint = widthHint;
        return gd;
    }

    protected static Label createLabel(int numColumns, Composite parent, String text) {
        return ModifyDialogTabPage.createLabel(numColumns, parent, text, 768);
    }

    protected static Label createLabel(int numColumns, Composite parent, String text, int gridDataStyle) {
        Label label = new Label(parent, 64);
        label.setFont(parent.getFont());
        label.setText(text);
        PixelConverter pixelConverter = new PixelConverter((Control)parent);
        label.setLayoutData((Object)ModifyDialogTabPage.createGridData(numColumns, gridDataStyle, pixelConverter.convertHorizontalDLUsToPixels(150)));
        return label;
    }

    protected Group createGroup(int numColumns, Composite parent, String text) {
        Group group = new Group(parent, 0);
        group.setFont(parent.getFont());
        group.setLayoutData((Object)ModifyDialogTabPage.createGridData(numColumns, 768, -1));
        GridLayout layout = new GridLayout(numColumns, false);
        layout.verticalSpacing = this.fPixelConverter.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.fPixelConverter.convertHorizontalDLUsToPixels(4);
        layout.marginHeight = this.fPixelConverter.convertVerticalDLUsToPixels(4);
        group.setLayout((Layout)layout);
        group.setText(text);
        return group;
    }

    protected NumberPreference createNumberPref(Composite composite, int numColumns, String name, String key, int minValue, int maxValue) {
        NumberPreference pref = new NumberPreference(composite, numColumns, this.fWorkingValues, key, minValue, maxValue, name);
        this.fDefaultFocusManager.add(pref);
        pref.addObserver(this.fUpdater);
        return pref;
    }

    protected ComboPreference createComboPref(Composite composite, int numColumns, String name, String key, String[] values, String[] items) {
        ComboPreference pref = new ComboPreference(composite, numColumns, this.fWorkingValues, key, values, name, items);
        this.fDefaultFocusManager.add(pref);
        pref.addObserver(this.fUpdater);
        return pref;
    }

    protected CheckboxPreference createCheckboxPref(Composite composite, int numColumns, String name, String key, String[] values) {
        CheckboxPreference pref = new CheckboxPreference(composite, numColumns, this.fWorkingValues, key, values, name);
        this.fDefaultFocusManager.add(pref);
        pref.addObserver(this.fUpdater);
        return pref;
    }

    protected RadioPreference createRadioPref(Composite composite, int numColumns, String name, String key, String[] values) {
        RadioPreference pref = new RadioPreference(composite, numColumns, this.fWorkingValues, key, values, name);
        this.fDefaultFocusManager.add(pref);
        pref.addObserver(this.fUpdater);
        return pref;
    }

    protected static String createPreviewHeader(String title) {
        return "/*\n* " + title + "\n*/\n";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ButtonPreference
    extends Preference {
        private final String[] fValues;
        private final Button fCheckbox;

        public ButtonPreference(Composite composite, int numColumns, Map<String, String> preferences, String key, String[] values, String text, int style) {
            super(preferences, key);
            if (values == null || text == null) {
                throw new IllegalArgumentException(FormatterMessages.ModifyDialogTabPage_error_msg_values_text_unassigned);
            }
            this.fValues = values;
            this.fCheckbox = new Button(composite, style);
            this.fCheckbox.setText(text);
            this.fCheckbox.setLayoutData((Object)ModifyDialogTabPage.createGridData(numColumns, 768, -1));
            this.fCheckbox.setFont(composite.getFont());
            this.updateWidget();
            this.fCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ButtonPreference.this.checkboxChecked(((Button)e.widget).getSelection());
                }
            });
        }

        protected void checkboxChecked(boolean state) {
            this.getPreferences().put(this.getKey(), state ? this.fValues[1] : this.fValues[0]);
            this.setChanged();
            this.notifyObservers();
        }

        @Override
        protected void updateWidget() {
            if (this.getKey() != null) {
                this.fCheckbox.setEnabled(this.getEnabled());
                this.fCheckbox.setSelection(this.getChecked());
            } else {
                this.fCheckbox.setSelection(false);
                this.fCheckbox.setEnabled(false);
            }
        }

        public boolean getChecked() {
            return this.fValues[1].equals(this.getPreferences().get(this.getKey()));
        }

        public void setChecked(boolean checked) {
            this.getPreferences().put(this.getKey(), checked ? this.fValues[1] : this.fValues[0]);
            this.updateWidget();
            this.checkboxChecked(checked);
        }

        @Override
        public Control getControl() {
            return this.fCheckbox;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class CheckboxPreference
    extends ButtonPreference {
        public CheckboxPreference(Composite composite, int numColumns, Map<String, String> preferences, String key, String[] values, String text) {
            super(composite, numColumns, preferences, key, values, text, 32);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class ComboPreference
    extends Preference {
        private final String[] fItems;
        private final String[] fValues;
        private final Combo fCombo;

        public ComboPreference(Composite composite, int numColumns, Map<String, String> preferences, String key, String[] values, String text, String[] items) {
            super(preferences, key);
            if (values == null || items == null || text == null) {
                throw new IllegalArgumentException(FormatterMessages.ModifyDialogTabPage_error_msg_values_items_text_unassigned);
            }
            this.fValues = values;
            this.fItems = items;
            ModifyDialogTabPage.createLabel(numColumns - 1, composite, text);
            this.fCombo = new Combo(composite, 12);
            this.fCombo.setFont(composite.getFont());
            this.fCombo.setItems(items);
            int max = 0;
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                if (item.length() > max) {
                    max = item.length();
                }
                ++n2;
            }
            this.fCombo.setLayoutData((Object)ModifyDialogTabPage.createGridData(1, 256, this.fCombo.computeSize((int)-1, (int)-1).x));
            this.updateWidget();
            this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ComboPreference.this.comboSelected(((Combo)e.widget).getSelectionIndex());
                }
            });
        }

        protected void comboSelected(int index) {
            this.getPreferences().put(this.getKey(), this.fValues[index]);
            this.setChanged();
            this.notifyObservers(this.fValues[index]);
        }

        @Override
        protected void updateWidget() {
            if (this.getKey() != null) {
                this.fCombo.setEnabled(this.getEnabled());
                this.fCombo.setText(this.getSelectedItem());
            } else {
                this.fCombo.setText("");
                this.fCombo.setEnabled(false);
            }
        }

        public String getSelectedItem() {
            String selected = this.getPreferences().get(this.getKey());
            int i = 0;
            while (i < this.fValues.length) {
                if (this.fValues[i].equals(selected)) {
                    return this.fItems[i];
                }
                ++i;
            }
            return "";
        }

        public boolean hasValue(String value) {
            return value.equals(this.getPreferences().get(this.getKey()));
        }

        @Override
        public Control getControl() {
            return this.fCombo;
        }
    }

    protected static final class DefaultFocusManager
    extends FocusAdapter {
        private static final String PREF_LAST_FOCUS_INDEX = "formatter_page.modify_dialog_tab_page.last_focus_index";
        private final IDialogSettings fDialogSettings = CUIPlugin.getDefault().getDialogSettings();
        private final Map<Control, Integer> fItemMap = new HashMap<Control, Integer>();
        private final List<Control> fItemList = new ArrayList<Control>();
        private int fIndex = 0;

        public void focusGained(FocusEvent e) {
            this.fDialogSettings.put(PREF_LAST_FOCUS_INDEX, this.fItemMap.get(e.widget).intValue());
        }

        public void add(Control control) {
            control.addFocusListener((FocusListener)this);
            this.fItemList.add(this.fIndex, control);
            this.fItemMap.put(control, new Integer(this.fIndex++));
        }

        public void add(Preference preference) {
            Control control = preference.getControl();
            if (control != null) {
                this.add(control);
            }
        }

        public boolean isUsed() {
            return this.fIndex != 0;
        }

        public void restoreFocus() {
            int index = 0;
            try {
                index = this.fDialogSettings.getInt(PREF_LAST_FOCUS_INDEX);
                if (index >= 0 && index <= this.fItemList.size() - 1) {
                    this.fItemList.get(index).setFocus();
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }

        public void resetFocus() {
            this.fDialogSettings.put(PREF_LAST_FOCUS_INDEX, -1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class NumberPreference
    extends Preference {
        private final int fMinValue;
        private final int fMaxValue;
        private final Label fNumberLabel;
        private final Text fNumberText;
        protected int fSelected;
        protected int fOldSelected;

        public NumberPreference(Composite composite, int numColumns, Map<String, String> preferences, String key, int minValue, int maxValue, String text) {
            super(preferences, key);
            this.fNumberLabel = ModifyDialogTabPage.createLabel(numColumns - 1, composite, text, 768);
            this.fNumberText = new Text(composite, 133124);
            this.fNumberText.setFont(composite.getFont());
            int length = Integer.toString(maxValue).length() + 3;
            this.fNumberText.setLayoutData((Object)ModifyDialogTabPage.createGridData(1, 128, ModifyDialogTabPage.this.fPixelConverter.convertWidthInCharsToPixels(length)));
            this.fMinValue = minValue;
            this.fMaxValue = maxValue;
            this.updateWidget();
            this.fNumberText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    NumberPreference.this.focusGained();
                }

                public void focusLost(FocusEvent e) {
                    NumberPreference.this.focusLost();
                }
            });
            this.fNumberText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NumberPreference.this.fieldModified();
                }
            });
        }

        private IStatus createErrorStatus() {
            return new Status(4, CUIPlugin.getPluginId(), 0, Messages.format(FormatterMessages.ModifyDialogTabPage_NumberPreference_error_invalid_value, new String[]{Integer.toString(this.fMinValue), Integer.toString(this.fMaxValue)}), null);
        }

        protected void focusGained() {
            this.fOldSelected = this.fSelected;
            this.fNumberText.setSelection(0, this.fNumberText.getCharCount());
        }

        protected void focusLost() {
            ModifyDialogTabPage.this.updateStatus(null);
            String input = this.fNumberText.getText();
            this.fSelected = !this.validInput(input) ? this.fOldSelected : Integer.parseInt(input);
            if (this.fSelected != this.fOldSelected) {
                this.saveSelected();
                this.fNumberText.setText(Integer.toString(this.fSelected));
            }
        }

        protected void fieldModified() {
            int number;
            String trimInput = this.fNumberText.getText().trim();
            boolean valid = this.validInput(trimInput);
            ModifyDialogTabPage.this.updateStatus(valid ? null : this.createErrorStatus());
            if (valid && this.fSelected != (number = Integer.parseInt(trimInput))) {
                this.fSelected = number;
                this.saveSelected();
            }
        }

        private boolean validInput(String trimInput) {
            int number;
            try {
                number = Integer.parseInt(trimInput);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (number < this.fMinValue) {
                return false;
            }
            return number <= this.fMaxValue;
        }

        private void saveSelected() {
            this.getPreferences().put(this.getKey(), Integer.toString(this.fSelected));
            this.setChanged();
            this.notifyObservers();
        }

        @Override
        protected void updateWidget() {
            boolean hasKey = this.getKey() != null;
            this.fNumberLabel.setEnabled(hasKey && this.getEnabled());
            this.fNumberText.setEnabled(hasKey && this.getEnabled());
            if (hasKey) {
                String s = this.getPreferences().get(this.getKey());
                try {
                    this.fSelected = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    String message = Messages.format(FormatterMessages.ModifyDialogTabPage_NumberPreference_error_invalid_key, this.getKey());
                    CUIPlugin.log((IStatus)new Status(4, CUIPlugin.getPluginId(), 0, message, (Throwable)e));
                    s = "";
                }
                this.fNumberText.setText(s);
            } else {
                this.fNumberText.setText("");
            }
        }

        @Override
        public Control getControl() {
            return this.fNumberText;
        }
    }

    private static class PageLayout
    extends Layout {
        private final ScrolledComposite fContainer;
        private final int fMinimalWidth;
        private final int fMinimalHight;

        private PageLayout(ScrolledComposite container, int minimalWidth, int minimalHight) {
            this.fContainer = container;
            this.fMinimalWidth = minimalWidth;
            this.fMinimalHight = minimalHight;
        }

        public Point computeSize(Composite composite, int wHint, int hHint, boolean force) {
            Control[] children;
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            int x = this.fMinimalWidth;
            int y = this.fMinimalHight;
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                Point size = element.computeSize(-1, -1, force);
                x = Math.max(x, size.x);
                y = Math.max(y, size.y);
                ++n2;
            }
            Rectangle area = this.fContainer.getClientArea();
            if (area.width > x) {
                this.fContainer.setExpandHorizontal(true);
            } else {
                this.fContainer.setExpandHorizontal(false);
            }
            if (area.height > y) {
                this.fContainer.setExpandVertical(true);
            } else {
                this.fContainer.setExpandVertical(false);
            }
            if (wHint != -1) {
                x = wHint;
            }
            if (hHint != -1) {
                y = hHint;
            }
            return new Point(x, y);
        }

        public void layout(Composite composite, boolean force) {
            Control[] children;
            Rectangle rect = composite.getClientArea();
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control element = controlArray[n2];
                element.setSize(rect.width, rect.height);
                ++n2;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class Preference
    extends Observable {
        private final Map<String, String> fPreferences;
        private boolean fEnabled;
        private String fKey;

        public Preference(Map<String, String> preferences, String key) {
            this.fPreferences = preferences;
            this.fEnabled = true;
            this.fKey = key;
        }

        protected final Map<String, String> getPreferences() {
            return this.fPreferences;
        }

        public final void setEnabled(boolean enabled) {
            this.fEnabled = enabled;
            this.updateWidget();
        }

        public final boolean getEnabled() {
            return this.fEnabled;
        }

        public final void setKey(String key) {
            if (key == null || !this.fKey.equals(key)) {
                this.fKey = key;
                this.updateWidget();
            }
        }

        public final String getKey() {
            return this.fKey;
        }

        public abstract Control getControl();

        protected abstract void updateWidget();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class RadioPreference
    extends ButtonPreference {
        public RadioPreference(Composite composite, int numColumns, Map<String, String> preferences, String key, String[] values, String text) {
            super(composite, numColumns, preferences, key, values, text, 16);
        }
    }
}

