/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.dialogs;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.cdt.internal.ui.compare.CMergeViewer;
import org.eclipse.cdt.internal.ui.refactoring.dialogs.Messages;
import org.eclipse.cdt.internal.ui.text.CSourceViewerConfiguration;
import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.refactoring.CTextFileChange;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.ui.refactoring.ChangePreviewViewerInput;
import org.eclipse.ltk.ui.refactoring.IChangePreviewViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CTextEditChangePreviewViewer
implements IChangePreviewViewer {
    private CPPMergeViewer viewer;
    private CTextEditChangePane viewerPane;
    private CTextEditChangePreviewViewerContentProvider textEditChangeContentProvider;

    public void createControl(Composite parent) {
        CompareConfiguration compConfig = new CompareConfiguration();
        compConfig.setLeftEditable(false);
        compConfig.setRightEditable(false);
        this.viewerPane = new CTextEditChangePane(parent, 0x800800);
        this.viewer = new CPPMergeViewer((Composite)this.viewerPane, 65538, compConfig);
        this.textEditChangeContentProvider = new CTextEditChangePreviewViewerContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.textEditChangeContentProvider);
        this.viewerPane.setContent(this.viewer.getControl());
    }

    public Control getControl() {
        return this.viewerPane;
    }

    public void setInput(ChangePreviewViewerInput input) {
        try {
            Change change = input.getChange();
            if (change instanceof CTextFileChange) {
                CTextFileChange editChange = (CTextFileChange)change;
                this.setInput(editChange, editChange.getCurrentContent((IProgressMonitor)new NullProgressMonitor()), editChange.getPreviewContent((IProgressMonitor)new NullProgressMonitor()), editChange.getTextType());
                return;
            }
            this.viewer.setInput(null);
        }
        catch (CoreException coreException) {
            this.viewer.setInput(null);
        }
    }

    private void setInput(CTextFileChange change, String left, String right, String type) {
        IFile resource = change.getFile();
        this.viewerPane.setText(resource.getName());
        this.viewerPane.setImage(new CElementLabelProvider().getImage(resource));
        this.viewer.setInput(new DiffNode((ITypedElement)new CompareElement(left, type, (IResource)resource), (ITypedElement)new CompareElement(right, type, (IResource)resource)));
    }

    private class CPPMergeViewer
    extends CMergeViewer {
        public CPPMergeViewer(Composite parent, int styles, CompareConfiguration mp) {
            super(parent, styles, mp);
        }

        protected CSourceViewerConfiguration getSourceViewerConfiguration() {
            CTextTools tools = CUIPlugin.getDefault().getTextTools();
            IPreferenceStore store = CUIPlugin.getDefault().getCombinedPreferenceStore();
            return new CSourceViewerConfiguration(tools.getColorManager(), store, null, tools.getDocumentPartitioning());
        }

        protected void configureTextViewer(TextViewer textViewer) {
            if (textViewer instanceof SourceViewer) {
                ((SourceViewer)textViewer).configure((SourceViewerConfiguration)this.getSourceViewerConfiguration());
            }
        }
    }

    private static class CTextEditChangePane
    extends CompareViewerPane {
        public CTextEditChangePane(Composite parent, int style) {
            super(parent, style);
        }
    }

    private class CTextEditChangePreviewViewerContentProvider
    implements IMergeViewerContentProvider {
        private CTextEditChangePreviewViewerContentProvider() {
        }

        public Object getAncestorContent(Object input) {
            if (input instanceof ICompareInput) {
                return ((ICompareInput)input).getAncestor();
            }
            return null;
        }

        public Image getAncestorImage(Object input) {
            ITypedElement ancestor;
            if (input instanceof ICompareInput && (ancestor = ((ICompareInput)input).getAncestor()) != null) {
                return ancestor.getImage();
            }
            return null;
        }

        public String getAncestorLabel(Object input) {
            ITypedElement ancestor;
            if (input instanceof ICompareInput && (ancestor = ((ICompareInput)input).getAncestor()) != null) {
                return ancestor.getName();
            }
            return null;
        }

        public Object getLeftContent(Object input) {
            if (input instanceof ICompareInput) {
                return ((ICompareInput)input).getLeft();
            }
            return null;
        }

        public Image getLeftImage(Object input) {
            if (input instanceof ICompareInput) {
                return ((ICompareInput)input).getLeft().getImage();
            }
            return null;
        }

        public String getLeftLabel(Object input) {
            return Messages.CTextEditChangePreviewViewer_OrgSource;
        }

        public Object getRightContent(Object input) {
            if (input instanceof ICompareInput) {
                return ((ICompareInput)input).getRight();
            }
            return null;
        }

        public Image getRightImage(Object input) {
            if (input instanceof ICompareInput) {
                return ((ICompareInput)input).getRight().getImage();
            }
            return null;
        }

        public String getRightLabel(Object input) {
            return Messages.CTextEditChangePreviewViewer_RefactoredSource;
        }

        public boolean isLeftEditable(Object input) {
            return false;
        }

        public boolean isRightEditable(Object input) {
            return false;
        }

        public void saveLeftContent(Object input, byte[] bytes) {
        }

        public void saveRightContent(Object input, byte[] bytes) {
        }

        public boolean showAncestor(Object input) {
            return false;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class CompareElement
    implements ITypedElement,
    IEncodedStreamContentAccessor,
    IResourceProvider {
        private static final String ENCODING = "UTF-8";
        private final String fContent;
        private final String fType;
        private final IResource fResource;

        public CompareElement(String content, String type, IResource resource) {
            this.fContent = content;
            this.fType = type;
            this.fResource = resource;
        }

        public String getName() {
            return "";
        }

        public Image getImage() {
            return null;
        }

        public String getType() {
            return this.fType;
        }

        public InputStream getContents() throws CoreException {
            try {
                return new ByteArrayInputStream(this.fContent.getBytes(ENCODING));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new ByteArrayInputStream(this.fContent.getBytes());
            }
        }

        public String getCharset() {
            return ENCODING;
        }

        public IResource getResource() {
            return this.fResource;
        }
    }
}

