/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchUtil;
import org.eclipse.cdt.internal.ui.search.actions.FindAction;
import org.eclipse.cdt.internal.ui.util.Messages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public abstract class FindInWorkingSetAction
extends FindAction {
    private IWorkingSet[] fWorkingSets;
    private String scopeDescription = "";

    public FindInWorkingSetAction(CEditor editor, String label, String tooltip, IWorkingSet[] workingSets) {
        super(editor);
        this.setText(label);
        this.setToolTipText(tooltip);
        this.fWorkingSets = workingSets;
    }

    public FindInWorkingSetAction(IWorkbenchSite site, String label, String tooltip, IWorkingSet[] workingSets) {
        super(site);
        this.setText(label);
        this.setToolTipText(tooltip);
        this.fWorkingSets = workingSets;
    }

    public final void run() {
        IWorkingSet[] initial = this.fWorkingSets;
        if (this.fWorkingSets == null) {
            this.fWorkingSets = this.askForWorkingSets();
        }
        if (this.fWorkingSets != null) {
            this.scopeDescription = Messages.format(CSearchMessages.WorkingSetScope, new String[]{CSearchUtil.toString(this.fWorkingSets)});
            super.run();
        }
        this.fWorkingSets = initial;
    }

    protected final String getScopeDescription() {
        return this.scopeDescription;
    }

    protected final ICElement[] getScope() {
        if (this.fWorkingSets == null) {
            return new ICElement[0];
        }
        ArrayList<ICElement> scope = new ArrayList<ICElement>();
        int i = 0;
        while (i < this.fWorkingSets.length) {
            IAdaptable[] elements = this.fWorkingSets[i].getElements();
            int j = 0;
            while (j < elements.length) {
                ICElement element = (ICElement)elements[j].getAdapter(ICElement.class);
                if (element != null) {
                    scope.add(element);
                }
                ++j;
            }
            ++i;
        }
        return scope.toArray(new ICElement[scope.size()]);
    }

    private IWorkingSet[] askForWorkingSets() {
        IWorkingSetManager wsm = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dlg = wsm.createWorkingSetSelectionDialog(this.getSite().getShell(), true);
        IWorkingSet[] mru = wsm.getRecentWorkingSets();
        if (mru != null && mru.length > 0) {
            dlg.setSelection(new IWorkingSet[]{mru[0]});
        }
        if (dlg.open() == 0) {
            mru = dlg.getSelection();
            if (mru != null && mru.length == 1) {
                wsm.addRecentWorkingSet(mru[0]);
            }
            return mru;
        }
        return null;
    }
}

