/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionStyleMacroParameter;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorFunctionStyleMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDirective;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitTypedef;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.internal.ui.text.contentassist.CContentAssistInvocationContext;
import org.eclipse.cdt.internal.ui.text.contentassist.CProposalContextInformation;
import org.eclipse.cdt.internal.ui.text.contentassist.ParsingBasedProposalComputer;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMCompletionProposalComputer
extends ParsingBasedProposalComputer {
    @Override
    protected List<ICompletionProposal> computeCompletionProposals(CContentAssistInvocationContext context, IASTCompletionNode completionNode, String prefix) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        if (this.inPreprocessorDirective(context)) {
            if (!this.inPreprocessorKeyword(context)) {
                if (prefix.length() == 0) {
                    try {
                        prefix = context.computeIdentifierPrefix().toString();
                    }
                    catch (BadLocationException exc) {
                        CUIPlugin.log(exc);
                    }
                }
                this.addMacroProposals(context, prefix, proposals);
            }
        } else {
            boolean handleMacros = false;
            IASTName[] names = completionNode.getNames();
            int i = 0;
            while (i < names.length) {
                IASTCompletionContext astContext;
                if (names[i].getTranslationUnit() != null && (astContext = names[i].getCompletionContext()) != null) {
                    IBinding[] bindings;
                    if (astContext instanceof IASTIdExpression || astContext instanceof IASTNamedTypeSpecifier) {
                        handleMacros = prefix.length() > 0;
                    }
                    if ((bindings = astContext.findBindings(names[i], !context.isContextInformationStyle())) != null) {
                        int j = 0;
                        while (j < bindings.length) {
                            this.handleBinding(bindings[j], context, prefix, astContext, proposals);
                            ++j;
                        }
                    }
                }
                ++i;
            }
            if (handleMacros) {
                this.addMacroProposals(context, prefix, proposals);
            }
        }
        return proposals;
    }

    private boolean inPreprocessorKeyword(CContentAssistInvocationContext context) {
        IDocument doc = context.getDocument();
        int offset = context.getInvocationOffset();
        try {
            String ppPrefix;
            ITypedRegion partition = TextUtilities.getPartition((IDocument)doc, (String)"___c_partitioning", (int)offset, (boolean)true);
            if ("__c_preprocessor".equals(partition.getType()) && (ppPrefix = doc.get(partition.getOffset(), offset - partition.getOffset())).matches("\\s*#\\s*\\w*")) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    private boolean inPreprocessorDirective(CContentAssistInvocationContext context) {
        IDocument doc = context.getDocument();
        int offset = context.getInvocationOffset();
        try {
            ITypedRegion partition = TextUtilities.getPartition((IDocument)doc, (String)"___c_partitioning", (int)offset, (boolean)true);
            if ("__c_preprocessor".equals(partition.getType())) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    private void addMacroProposals(CContentAssistInvocationContext context, String prefix, List<ICompletionProposal> proposals) {
        char[] macroName;
        int i;
        char[] prefixChars = prefix.toCharArray();
        boolean matchPrefix = !context.isContextInformationStyle();
        IASTCompletionNode completionNode = context.getCompletionNode();
        IASTPreprocessorMacroDefinition[] macros = completionNode.getTranslationUnit().getMacroDefinitions();
        if (macros != null) {
            i = 0;
            while (i < macros.length) {
                macroName = macros[i].getName().toCharArray();
                if (CharArrayUtils.equals((char[])macroName, (int)0, (int)(matchPrefix ? prefixChars.length : macroName.length), (char[])prefixChars, (boolean)true)) {
                    this.handleMacro(macros[i], context, prefix, proposals);
                }
                ++i;
            }
        }
        if ((macros = completionNode.getTranslationUnit().getBuiltinMacroDefinitions()) != null) {
            i = 0;
            while (i < macros.length) {
                macroName = macros[i].getName().toCharArray();
                if (CharArrayUtils.equals((char[])macroName, (int)0, (int)(matchPrefix ? prefixChars.length : macroName.length), (char[])prefixChars, (boolean)true)) {
                    this.handleMacro(macros[i], context, prefix, proposals);
                }
                ++i;
            }
        }
    }

    private void handleMacro(IASTPreprocessorMacroDefinition macro, CContentAssistInvocationContext context, String prefix, List<ICompletionProposal> proposals) {
        String macroName = macro.getName().toString();
        int baseRelevance = this.computeBaseRelevance(prefix, macroName);
        Image image = this.getImage(CElementImageProvider.getMacroImageDescriptor());
        if (macro instanceof IASTPreprocessorFunctionStyleMacroDefinition) {
            IASTPreprocessorFunctionStyleMacroDefinition functionMacro = (IASTPreprocessorFunctionStyleMacroDefinition)macro;
            StringBuilder repStringBuff = new StringBuilder();
            repStringBuff.append(macroName);
            repStringBuff.append('(');
            StringBuilder args = new StringBuilder();
            IASTFunctionStyleMacroParameter[] params = functionMacro.getParameters();
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    if (i > 0) {
                        args.append(", ");
                    }
                    args.append(params[i].getParameter());
                    ++i;
                }
            }
            String argString = args.toString();
            StringBuilder descStringBuff = new StringBuilder(repStringBuff.toString());
            descStringBuff.append(argString);
            descStringBuff.append(')');
            repStringBuff.append(')');
            String repString = repStringBuff.toString();
            String descString = descStringBuff.toString();
            CCompletionProposal proposal = this.createProposal(repString, descString, prefix.length(), image, baseRelevance + 15, context);
            if (!context.isContextInformationStyle()) {
                proposal.setCursorPosition(repString.length() - 1);
            }
            if (argString.length() > 0) {
                CProposalContextInformation info = new CProposalContextInformation(image, descString, argString);
                info.setContextInformationPosition(context.getContextInformationOffset());
                proposal.setContextInformation(info);
            }
            proposals.add(proposal);
        } else {
            proposals.add(this.createProposal(macroName, macroName, prefix.length(), image, baseRelevance + 15, context));
        }
    }

    protected void handleBinding(IBinding binding, CContentAssistInvocationContext cContext, String prefix, IASTCompletionContext astContext, List<ICompletionProposal> proposals) {
        if ((binding instanceof CPPImplicitFunction || binding instanceof CPPTemplates.CPPImplicitFunctionTemplate || binding instanceof CPPImplicitTypedef) && !(binding instanceof CPPImplicitMethod)) {
            return;
        }
        if (!this.isAnonymousBinding(binding)) {
            String name = binding.getName();
            int baseRelevance = this.computeBaseRelevance(prefix, name);
            if (binding instanceof ICPPClassType) {
                this.handleClass((ICPPClassType)binding, astContext, cContext, baseRelevance, proposals);
            } else if (binding instanceof IFunction) {
                this.handleFunction((IFunction)binding, cContext, baseRelevance, proposals);
            } else if (!cContext.isContextInformationStyle()) {
                if (binding instanceof IVariable) {
                    this.handleVariable((IVariable)binding, cContext, baseRelevance, proposals);
                } else if (binding instanceof ITypedef) {
                    proposals.add(this.createProposal(name, name, this.getImage(binding), baseRelevance + 60, cContext));
                } else if (binding instanceof ICPPNamespace) {
                    this.handleNamespace((ICPPNamespace)binding, astContext, cContext, baseRelevance, proposals);
                } else if (binding instanceof IEnumeration) {
                    proposals.add(this.createProposal(name, name, this.getImage(binding), baseRelevance + 30, cContext));
                } else if (binding instanceof IEnumerator) {
                    proposals.add(this.createProposal(name, name, this.getImage(binding), baseRelevance + 40, cContext));
                } else {
                    proposals.add(this.createProposal(name, name, this.getImage(binding), baseRelevance + 20, cContext));
                }
            }
        }
    }

    private boolean isAnonymousBinding(IBinding binding) {
        char[] name = binding.getNameCharArray();
        return name.length == 0 || name[0] == '{';
    }

    private void handleClass(ICPPClassType classType, IASTCompletionContext astContext, CContentAssistInvocationContext context, int baseRelevance, List<ICompletionProposal> proposals) {
        if (context.isContextInformationStyle()) {
            try {
                ICPPConstructor[] constructors;
                ICPPConstructor[] iCPPConstructorArray = constructors = classType.getConstructors();
                int n = constructors.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPConstructor constructor = iCPPConstructorArray[n2];
                    this.handleFunction((IFunction)constructor, context, baseRelevance, proposals);
                    ++n2;
                }
            }
            catch (DOMException dOMException) {}
        } else {
            IASTName name;
            int relevance = 0;
            try {
                switch (classType.getKey()) {
                    case 3: {
                        relevance = 90;
                        break;
                    }
                    case 1: {
                        relevance = 80;
                        break;
                    }
                    case 2: {
                        relevance = 70;
                    }
                }
            }
            catch (DOMException dOMException) {}
            if (astContext instanceof IASTName && !(astContext instanceof ICPPASTQualifiedName) && (name = (IASTName)astContext).getParent() instanceof IASTDeclarator) {
                proposals.add(this.createProposal(String.valueOf(classType.getName()) + "::", classType.getName(), this.getImage((IBinding)classType), baseRelevance + relevance, context));
            }
            proposals.add(this.createProposal(classType.getName(), classType.getName(), this.getImage((IBinding)classType), baseRelevance + 90, context));
        }
    }

    private void handleFunction(IFunction function, CContentAssistInvocationContext context, int baseRelevance, List<ICompletionProposal> proposals) {
        Image image = this.getImage((IBinding)function);
        StringBuilder repStringBuff = new StringBuilder();
        repStringBuff.append(function.getName());
        repStringBuff.append('(');
        StringBuilder dispargs = new StringBuilder();
        StringBuilder idargs = new StringBuilder();
        String returnTypeStr = null;
        try {
            IType returnType;
            IFunctionType functionType;
            IParameter[] params = function.getParameters();
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    IType paramType = params[i].getType();
                    if (i > 0) {
                        dispargs.append(',');
                        idargs.append(',');
                    }
                    dispargs.append(ASTTypeUtil.getType((IType)paramType, (boolean)false));
                    idargs.append(ASTTypeUtil.getType((IType)paramType, (boolean)false));
                    String paramName = params[i].getName();
                    if (paramName != null && paramName.length() > 0) {
                        dispargs.append(' ');
                        dispargs.append(paramName);
                    }
                    ++i;
                }
                if (function.takesVarArgs()) {
                    if (params.length > 0) {
                        dispargs.append(',');
                        idargs.append(',');
                    }
                    dispargs.append("...");
                    idargs.append("...");
                } else if (params.length == 0) {
                    dispargs.append("void");
                    idargs.append("void");
                }
            }
            if ((functionType = function.getType()) != null && (returnType = functionType.getReturnType()) != null) {
                returnTypeStr = ASTTypeUtil.getType((IType)returnType, (boolean)false);
            }
        }
        catch (DOMException dOMException) {}
        String dispargString = dispargs.toString();
        String idargString = idargs.toString();
        StringBuilder dispStringBuff = new StringBuilder(repStringBuff.toString());
        dispStringBuff.append(dispargString);
        dispStringBuff.append(')');
        if (returnTypeStr != null && returnTypeStr.length() > 0) {
            dispStringBuff.append(" : ");
            dispStringBuff.append(returnTypeStr);
        }
        String dispString = dispStringBuff.toString();
        StringBuilder idStringBuff = new StringBuilder(repStringBuff.toString());
        idStringBuff.append(idargString);
        idStringBuff.append(')');
        String idString = idStringBuff.toString();
        repStringBuff.append(')');
        String repString = repStringBuff.toString();
        int relevance = function instanceof ICPPMethod ? 120 : 100;
        CCompletionProposal proposal = this.createProposal(repString, dispString, idString, context.getCompletionNode().getLength(), image, baseRelevance + relevance, context);
        if (!context.isContextInformationStyle()) {
            proposal.setCursorPosition(repString.length() - 1);
        }
        if (dispargString.length() > 0) {
            CProposalContextInformation info = new CProposalContextInformation(image, dispString, dispargString);
            info.setContextInformationPosition(context.getContextInformationOffset());
            proposal.setContextInformation(info);
        }
        proposals.add(proposal);
    }

    private void handleVariable(IVariable variable, CContentAssistInvocationContext context, int baseRelevance, List<ICompletionProposal> proposals) {
        StringBuilder repStringBuff = new StringBuilder();
        repStringBuff.append(variable.getName());
        String returnTypeStr = "<unknown>";
        try {
            IType varType = variable.getType();
            if (varType != null) {
                returnTypeStr = ASTTypeUtil.getType((IType)varType, (boolean)false);
            }
        }
        catch (DOMException dOMException) {}
        StringBuilder dispStringBuff = new StringBuilder(repStringBuff.toString());
        if (returnTypeStr != null) {
            dispStringBuff.append(" : ");
            dispStringBuff.append(returnTypeStr);
        }
        String dispString = dispStringBuff.toString();
        StringBuilder idStringBuff = new StringBuilder(repStringBuff.toString());
        String idString = idStringBuff.toString();
        String repString = repStringBuff.toString();
        Image image = this.getImage((IBinding)variable);
        int relevance = DOMCompletionProposalComputer.isLocalVariable(variable) ? 140 : (DOMCompletionProposalComputer.isField(variable) ? 130 : 110);
        CCompletionProposal proposal = this.createProposal(repString, dispString, idString, context.getCompletionNode().getLength(), image, baseRelevance + relevance, context);
        proposals.add(proposal);
    }

    private static boolean isField(IVariable variable) {
        return variable instanceof IField;
    }

    private static boolean isLocalVariable(IVariable variable) {
        try {
            return DOMCompletionProposalComputer.isLocalScope(variable.getScope());
        }
        catch (DOMException dOMException) {
            return false;
        }
    }

    private static boolean isLocalScope(IScope scope) {
        while (scope != null) {
            if (scope instanceof ICPPFunctionScope || scope instanceof ICPPBlockScope || scope instanceof ICFunctionScope) {
                return true;
            }
            try {
                scope = scope.getParent();
            }
            catch (DOMException dOMException) {
                scope = null;
            }
        }
        return false;
    }

    private void handleNamespace(ICPPNamespace namespace, IASTCompletionContext astContext, CContentAssistInvocationContext cContext, int baseRelevance, List<ICompletionProposal> proposals) {
        if (astContext instanceof ICPPASTQualifiedName) {
            IASTCompletionContext parent = ((ICPPASTQualifiedName)astContext).getCompletionContext();
            this.handleNamespace(namespace, parent, cContext, baseRelevance, proposals);
            return;
        }
        StringBuilder repStringBuff = new StringBuilder();
        repStringBuff.append(namespace.getName());
        if (!(astContext instanceof ICPPASTUsingDeclaration) && !(astContext instanceof ICPPASTUsingDirective)) {
            repStringBuff.append("::");
        }
        String repString = repStringBuff.toString();
        proposals.add(this.createProposal(repString, namespace.getName(), this.getImage((IBinding)namespace), baseRelevance + 50, cContext));
    }

    private CCompletionProposal createProposal(String repString, String dispString, Image image, int relevance, CContentAssistInvocationContext context) {
        return this.createProposal(repString, dispString, null, context.getCompletionNode().getLength(), image, relevance, context);
    }

    private CCompletionProposal createProposal(String repString, String dispString, int prefixLength, Image image, int relevance, CContentAssistInvocationContext context) {
        return this.createProposal(repString, dispString, null, prefixLength, image, relevance, context);
    }

    private CCompletionProposal createProposal(String repString, String dispString, String idString, int prefixLength, Image image, int relevance, CContentAssistInvocationContext context) {
        int parseOffset = context.getParseOffset();
        int invocationOffset = context.getInvocationOffset();
        boolean doReplacement = !context.isContextInformationStyle();
        int repLength = doReplacement ? prefixLength : 0;
        int repOffset = doReplacement ? parseOffset - repLength : invocationOffset;
        repString = doReplacement ? repString : "";
        return new CCompletionProposal(repString, repOffset, repLength, image, dispString, idString, relevance, context.getViewer());
    }

    private Image getImage(ImageDescriptor desc) {
        return desc != null ? CUIPlugin.getImageDescriptorRegistry().get(desc) : null;
    }

    private Image getImage(IBinding binding) {
        ImageDescriptor imageDescriptor = null;
        try {
            IBinding[] delegates;
            if (binding instanceof ITypedef) {
                imageDescriptor = CElementImageProvider.getTypedefImageDescriptor();
            } else if (binding instanceof ICompositeType) {
                if (((ICompositeType)binding).getKey() == 3 || binding instanceof ICPPClassTemplate) {
                    imageDescriptor = CElementImageProvider.getClassImageDescriptor();
                } else if (((ICompositeType)binding).getKey() == 1) {
                    imageDescriptor = CElementImageProvider.getStructImageDescriptor();
                } else if (((ICompositeType)binding).getKey() == 2) {
                    imageDescriptor = CElementImageProvider.getUnionImageDescriptor();
                }
            } else if (binding instanceof ICPPMethod) {
                switch (((ICPPMethod)binding).getVisibility()) {
                    case 3: {
                        imageDescriptor = CElementImageProvider.getMethodImageDescriptor(ASTAccessVisibility.PRIVATE);
                        break;
                    }
                    case 2: {
                        imageDescriptor = CElementImageProvider.getMethodImageDescriptor(ASTAccessVisibility.PROTECTED);
                        break;
                    }
                    default: {
                        imageDescriptor = CElementImageProvider.getMethodImageDescriptor(ASTAccessVisibility.PUBLIC);
                        break;
                    }
                }
            } else if (binding instanceof IFunction) {
                imageDescriptor = CElementImageProvider.getFunctionImageDescriptor();
            } else if (binding instanceof ICPPField) {
                switch (((ICPPField)binding).getVisibility()) {
                    case 3: {
                        imageDescriptor = CElementImageProvider.getFieldImageDescriptor(ASTAccessVisibility.PRIVATE);
                        break;
                    }
                    case 2: {
                        imageDescriptor = CElementImageProvider.getFieldImageDescriptor(ASTAccessVisibility.PROTECTED);
                        break;
                    }
                    default: {
                        imageDescriptor = CElementImageProvider.getFieldImageDescriptor(ASTAccessVisibility.PUBLIC);
                        break;
                    }
                }
            } else if (binding instanceof IField) {
                imageDescriptor = CElementImageProvider.getFieldImageDescriptor(ASTAccessVisibility.PUBLIC);
            } else if (binding instanceof IVariable) {
                imageDescriptor = CElementImageProvider.getVariableImageDescriptor();
            } else if (binding instanceof IEnumeration) {
                imageDescriptor = CElementImageProvider.getEnumerationImageDescriptor();
            } else if (binding instanceof IEnumerator) {
                imageDescriptor = CElementImageProvider.getEnumeratorImageDescriptor();
            } else if (binding instanceof ICPPNamespace) {
                imageDescriptor = CElementImageProvider.getNamespaceImageDescriptor();
            } else if (binding instanceof ICPPFunctionTemplate) {
                imageDescriptor = CElementImageProvider.getFunctionImageDescriptor();
            } else if (binding instanceof ICPPUsingDeclaration && (delegates = ((ICPPUsingDeclaration)binding).getDelegates()).length > 0) {
                return this.getImage(delegates[0]);
            }
        }
        catch (DOMException dOMException) {}
        return imageDescriptor != null ? CUIPlugin.getImageDescriptorRegistry().get(imageDescriptor) : null;
    }
}

