/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.doctools;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.doctools.IDocCommentOwner;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProjectMap {
    private static final String ATTRVAL_STORAGEID = "org.eclipse.cdt.internal.ui.text.commentOwnerProjectMappings";
    private static final String ELEMENT_DOC_COMMENT_OWNER = "doc-comment-owner";
    private static final String ATTRKEY_DCO_ID = "id";
    private static final String ELEMENT_PATH = "path";
    private static final String ATTRKEY_PATH_VALUE = "value";
    private IProject fProject;
    private Map<IPath, String> fMap;

    public ProjectMap(IProject project) {
        try {
            this.fMap = ProjectMap.load(project);
        }
        catch (CoreException ce) {
            CUIPlugin.log(ce);
            this.fMap = new HashMap<IPath, String>();
        }
        this.fProject = project;
    }

    public String getOwnerID(IResource resource) {
        String id = null;
        if (resource != null) {
            IPath p = resource.getProjectRelativePath();
            while (true) {
                if (this.fMap.containsKey(p)) {
                    id = this.fMap.get(p);
                    break;
                }
                if (p.isEmpty()) break;
                p = p.removeLastSegments(1);
            }
        }
        return id;
    }

    public void setCommentOwner(IResource resource, IDocCommentOwner owner) {
        Assert.isNotNull((Object)resource);
        if (ResourcesPlugin.getWorkspace().getRoot().equals((Object)resource)) {
            throw new IllegalStateException();
        }
        if (owner != null) {
            this.fMap.put(resource.getProjectRelativePath(), owner.getID());
        } else {
            this.fMap.remove(resource.getProjectRelativePath());
        }
        try {
            this.save();
        }
        catch (CoreException ce) {
            CUIPlugin.log(ce);
        }
    }

    public boolean isEmpty() {
        return this.fMap.isEmpty();
    }

    private static Map<IPath, String> load(IProject project) throws CoreException {
        HashMap<IPath, String> result = new HashMap<IPath, String>();
        ICDescriptor pd = CCorePlugin.getDefault().getCProjectDescription(project, true);
        Element e = pd.getProjectData(ATTRVAL_STORAGEID);
        if (e.hasChildNodes()) {
            NodeList commentOwners = e.getElementsByTagName(ELEMENT_DOC_COMMENT_OWNER);
            int i = 0;
            while (i < commentOwners.getLength()) {
                Element node = (Element)commentOwners.item(i);
                Node commentOwnerIDNode = node.getAttributes().getNamedItem(ATTRKEY_DCO_ID);
                if (commentOwnerIDNode != null) {
                    String commentOwnerID = commentOwnerIDNode.getNodeValue();
                    NodeList paths = node.getElementsByTagName(ELEMENT_PATH);
                    int j = 0;
                    while (j < paths.getLength()) {
                        Node path = paths.item(i);
                        Node pathValue = path.getAttributes().getNamedItem(ATTRKEY_PATH_VALUE);
                        if (pathValue != null) {
                            result.put(Path.fromPortableString((String)pathValue.getNodeValue()), commentOwnerID);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public void save() throws CoreException {
        ICDescriptor pd = CCorePlugin.getDefault().getCProjectDescription(this.fProject, true);
        Element data = pd.getProjectData(ATTRVAL_STORAGEID);
        NodeList nl = data.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node.getNodeType() == 1) {
                data.removeChild(node);
            }
            ++i;
        }
        for (String cid : this.fMap.values()) {
            Element commentNode = data.getOwnerDocument().createElement(ELEMENT_DOC_COMMENT_OWNER);
            commentNode.setAttribute(ATTRKEY_DCO_ID, cid);
            for (IPath path : this.fMap.keySet()) {
                String ccid = this.fMap.get(path);
                if (!cid.equals(ccid)) continue;
                Element pathNode = data.getOwnerDocument().createElement(ELEMENT_PATH);
                pathNode.setAttribute(ATTRKEY_PATH_VALUE, path.toPortableString());
                commentNode.appendChild(pathNode);
            }
            data.appendChild(commentNode);
        }
        pd.saveProjectData();
    }
}

