/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.resources.EFSFileStorage;
import org.eclipse.cdt.core.resources.FileStorage;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.editor.ITranslationUnitEditorInput;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public class EditorUtility {
    public static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";

    private EditorUtility() {
    }

    public static IEditorPart isOpenInEditor(Object inputElement) {
        IWorkbenchPage p;
        IEditorInput input = null;
        try {
            input = EditorUtility.getEditorInput(inputElement);
        }
        catch (CModelException cModelException) {}
        if (input != null && (p = CUIPlugin.getActivePage()) != null) {
            return p.findEditor(input);
        }
        return null;
    }

    public static IEditorPart openInEditor(Object inputElement) throws CModelException, PartInitException {
        return EditorUtility.openInEditor(inputElement, true);
    }

    public static IEditorPart openInEditor(Object inputElement, boolean activate) throws CModelException, PartInitException {
        if (inputElement instanceof IFile) {
            return EditorUtility.openInEditor((IFile)inputElement, activate);
        }
        IEditorInput input = EditorUtility.getEditorInput(inputElement);
        if (input != null) {
            return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input, inputElement), activate);
        }
        return null;
    }

    public static void revealInEditor(IEditorPart part, ICElement element) {
        if (element == null) {
            return;
        }
        if (part instanceof CEditor) {
            ((CEditor)part).setSelection(element);
        } else if (part instanceof ITextEditor && element instanceof ISourceReference && !(element instanceof ITranslationUnit)) {
            ISourceReference reference = (ISourceReference)element;
            try {
                ISourceRange range = reference.getSourceRange();
                ((ITextEditor)part).selectAndReveal(range.getIdStartPos(), range.getIdLength());
            }
            catch (CModelException exc) {
                CUIPlugin.log(exc.getStatus());
            }
        }
    }

    private static IEditorPart openInEditor(IFile file, boolean activate) throws PartInitException {
        if (file == null) {
            return null;
        }
        if (!file.getProject().isAccessible()) {
            EditorUtility.closedProject(file.getProject());
            return null;
        }
        try {
            IEditorInput input;
            File tempFile;
            if (!EditorUtility.isLinked(file) && (tempFile = file.getRawLocation().toFile()) != null) {
                String canonicalPath = null;
                try {
                    canonicalPath = tempFile.getCanonicalPath();
                }
                catch (IOException iOException) {}
                if (canonicalPath != null) {
                    Path path = new Path(canonicalPath);
                    file = CUIPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
                }
            }
            if ((input = EditorUtility.getEditorInput(file)) != null) {
                return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input, file), activate);
            }
        }
        catch (CModelException cModelException) {}
        return null;
    }

    public static boolean isLinked(IFile file) {
        if (file.isLinked()) {
            return true;
        }
        IPath path = file.getLocation();
        while (path.segmentCount() > 0) {
            IContainer[] containers;
            path = path.removeLastSegments(1);
            IContainer[] iContainerArray = containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocation(path);
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer container = iContainerArray[n2];
                if (container instanceof IFolder && ((IFolder)container).isLinked()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static void closedProject(IProject project) {
        MessageBox errorMsg = new MessageBox(CUIPlugin.getActiveWorkbenchShell(), 33);
        errorMsg.setText(CUIPlugin.getResourceString("EditorUtility.closedproject"));
        String desc = CUIPlugin.getResourceString("Editorutility.closedproject.description");
        errorMsg.setMessage(MessageFormat.format(desc, project.getName()));
        errorMsg.open();
    }

    private static IEditorPart openInEditor(IEditorInput input, String editorID, boolean activate) throws PartInitException {
        IWorkbenchPage p;
        if (input != null && (p = CUIPlugin.getActivePage()) != null) {
            IEditorPart editorPart = p.openEditor(input, editorID, activate);
            return editorPart;
        }
        return null;
    }

    private static IEditorInput getEditorInput(ICElement element) throws CModelException {
        while (element != null) {
            IResource resource;
            ITranslationUnit tu;
            if (element instanceof ISourceReference && (tu = ((ISourceReference)element).getTranslationUnit()) != null) {
                element = tu;
            }
            if (element instanceof IWorkingCopy && ((IWorkingCopy)element).isWorkingCopy()) {
                element = ((IWorkingCopy)element).getOriginalElement();
            }
            if (element instanceof ITranslationUnit) {
                ITranslationUnit unit = (ITranslationUnit)element;
                IResource resource2 = unit.getResource();
                if (resource2 instanceof IFile) {
                    return new FileEditorInput((IFile)resource2);
                }
                return new ExternalEditorInput(unit, (IStorage)new EFSFileStorage(unit.getLocationURI()));
            }
            if (element instanceof IBinary && (resource = element.getResource()) instanceof IFile) {
                return new FileEditorInput((IFile)resource);
            }
            element = element.getParent();
        }
        return null;
    }

    public static IEditorInput getEditorInput(Object input) throws CModelException {
        if (input instanceof ICElement) {
            return EditorUtility.getEditorInput((ICElement)input);
        }
        if (input instanceof IFile) {
            return new FileEditorInput((IFile)input);
        }
        if (input instanceof IStorage) {
            return new ExternalEditorInput((IStorage)input);
        }
        return null;
    }

    public static IEditorPart openInEditor(IPath location, ICElement element) throws PartInitException {
        IEditorInput input = EditorUtility.getEditorInputForLocation(location, element);
        return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input, element), true);
    }

    public static IEditorPart openInEditor(URI locationURI, ICElement element) throws PartInitException {
        IEditorInput input = EditorUtility.getEditorInputForLocation(locationURI, element);
        return EditorUtility.openInEditor(input, EditorUtility.getEditorID(input, element), true);
    }

    public static IEditorInput getEditorInputForLocation(URI locationURI, ICElement context) {
        ICProject cproject;
        IFile resource = EditorUtility.getWorkspaceFileAtLocation(locationURI, context);
        if (resource != null) {
            return new FileEditorInput(resource);
        }
        if (context == null) {
            try {
                ICProject[] projects = CCorePlugin.getDefault().getCoreModel().getCModel().getCProjects();
                int i = 0;
                block4: while (i < projects.length) {
                    IIncludeReference[] includeReferences = projects[i].getIncludeReferences();
                    int j = 0;
                    while (j < includeReferences.length) {
                        if (includeReferences[j].isOnIncludeEntry(URIUtil.toPath((URI)locationURI))) {
                            context = projects[i];
                            break block4;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (context == null && projects.length > 0) {
                    context = projects[0];
                }
            }
            catch (CModelException cModelException) {}
        }
        if (context != null && (cproject = context.getCProject()) != null) {
            ITranslationUnit unit = CoreModel.getDefault().createTranslationUnitFrom(cproject, locationURI);
            if (unit != null) {
                IFileStore fileStore = null;
                try {
                    fileStore = EFS.getStore((URI)locationURI);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return null;
                }
                if (fileStore != null) {
                    return new ExternalEditorInput(unit, (IStorage)new EFSFileStorage(locationURI));
                }
            }
            IProject markerResource = cproject.getProject();
            return new ExternalEditorInput((IStorage)new EFSFileStorage(locationURI), (IResource)markerResource);
        }
        return new ExternalEditorInput((IStorage)new EFSFileStorage(locationURI));
    }

    public static IEditorInput getEditorInputForLocation(IPath location, ICElement context) {
        ICProject cproject;
        IFile resource = EditorUtility.getWorkspaceFileAtLocation(location, context);
        if (resource != null) {
            return new FileEditorInput(resource);
        }
        if (context == null) {
            try {
                ICProject[] projects = CCorePlugin.getDefault().getCoreModel().getCModel().getCProjects();
                int i = 0;
                block2: while (i < projects.length) {
                    IIncludeReference[] includeReferences = projects[i].getIncludeReferences();
                    int j = 0;
                    while (j < includeReferences.length) {
                        if (includeReferences[j].isOnIncludeEntry(location)) {
                            context = projects[i];
                            break block2;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (context == null && projects.length > 0) {
                    context = projects[0];
                }
            }
            catch (CModelException cModelException) {}
        }
        if (context != null && (cproject = context.getCProject()) != null) {
            ITranslationUnit unit = CoreModel.getDefault().createTranslationUnitFrom(cproject, location);
            if (unit != null) {
                return new ExternalEditorInput(unit, (IStorage)new FileStorage(location));
            }
            IProject markerResource = cproject.getProject();
            return new ExternalEditorInput((IStorage)new FileStorage(location), (IResource)markerResource);
        }
        return new ExternalEditorInput((IStorage)new FileStorage(location));
    }

    public static IFile getWorkspaceFileAtLocation(IPath location, ICElement context) {
        IFile file;
        ICProject cProject;
        IProject project = null;
        if (context != null && (cProject = context.getCProject()) != null) {
            project = cProject.getProject();
        }
        IFile bestMatch = null;
        IFile secondBestMatch = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = root.findFilesForLocation(location);
        if (files.length == 0 && (file = root.getFileForLocation(location)) != null) {
            files = new IFile[]{file};
        }
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            file = iFileArray[n2];
            if (file.isAccessible()) {
                if (project != null && file.getProject().equals((Object)project)) {
                    bestMatch = file;
                    break;
                }
                if (CoreModel.hasCNature((IProject)file.getProject())) {
                    bestMatch = file;
                    if (project == null) {
                        break;
                    }
                } else {
                    secondBestMatch = file;
                }
            }
            ++n2;
        }
        IFile iFile = bestMatch = bestMatch != null ? bestMatch : secondBestMatch;
        if (bestMatch == null && location.segmentCount() >= 2 && (file = root.getFile(location)) != null && file.isAccessible()) {
            bestMatch = file;
        }
        return bestMatch;
    }

    public static IFile getWorkspaceFileAtLocation(URI locationURI, ICElement context) {
        IFile[] files;
        ICProject cProject;
        IProject project = null;
        if (context != null && (cProject = context.getCProject()) != null) {
            project = cProject.getProject();
        }
        IFile bestMatch = null;
        IFile secondBestMatch = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] iFileArray = files = root.findFilesForLocationURI(locationURI);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            if (file.isAccessible()) {
                if (project != null && file.getProject().equals((Object)project)) {
                    bestMatch = file;
                    break;
                }
                if (CoreModel.hasCNature((IProject)file.getProject())) {
                    bestMatch = file;
                    if (project == null) {
                        break;
                    }
                } else {
                    secondBestMatch = file;
                }
            }
            ++n2;
        }
        bestMatch = bestMatch != null ? bestMatch : secondBestMatch;
        return bestMatch;
    }

    public static ICElement getActiveEditorCInput() {
        IEditorPart part;
        IWorkbenchPage page = CUIPlugin.getActivePage();
        if (page != null && (part = page.getActiveEditor()) != null) {
            return EditorUtility.getEditorInputCElement(part);
        }
        return null;
    }

    public static ICElement getEditorInputCElement(IEditorPart part) {
        IEditorInput editorInput = part.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        return (ICElement)editorInput.getAdapter(ICElement.class);
    }

    public static ITranslationUnit getWorkingCopy(ITranslationUnit cu) {
        if (cu == null) {
            return null;
        }
        if (cu.isWorkingCopy()) {
            return cu;
        }
        return cu.findSharedWorkingCopy(CUIPlugin.getDefault().getBufferFactory());
    }

    public static String getEditorID(String name) {
        try {
            IEditorDescriptor descriptor = IDE.getEditorDescriptor((String)name);
            if (descriptor != null) {
                return descriptor.getId();
            }
        }
        catch (PartInitException partInitException) {}
        return DEFAULT_TEXT_EDITOR_ID;
    }

    public static String getEditorID(IEditorInput input, Object inputObject) {
        IEditorRegistry registry;
        IEditorDescriptor desc;
        int elementType;
        String contentTypeId;
        Object editorInput;
        ITranslationUnit cElement = null;
        if (input instanceof IFileEditorInput) {
            editorInput = (IFileEditorInput)input;
            IFile file = editorInput.getFile();
            try {
                IEditorRegistry registry2;
                IEditorDescriptor desc2;
                String editorID = file.getPersistentProperty(IDE.EDITOR_KEY);
                if (editorID != null && (desc2 = (registry2 = PlatformUI.getWorkbench().getEditorRegistry()).findEditor(editorID)) != null) {
                    return editorID;
                }
            }
            catch (CoreException coreException) {}
            cElement = CoreModel.getDefault().create(file);
        } else if (input instanceof ITranslationUnitEditorInput) {
            editorInput = (ITranslationUnitEditorInput)input;
            cElement = editorInput.getTranslationUnit();
        } else if (inputObject instanceof ICElement) {
            cElement = (ICElement)inputObject;
        }
        IContentType contentType = null;
        if (cElement instanceof ITranslationUnit && (contentTypeId = cElement.getContentTypeId()) != null) {
            contentType = Platform.getContentTypeManager().getContentType(contentTypeId);
        }
        if (contentType == null) {
            IProject project = null;
            if (cElement != null) {
                project = cElement.getCProject().getProject();
            } else {
                IFile file = ResourceUtil.getFile((IEditorInput)input);
                if (file != null) {
                    project = file.getProject();
                }
            }
            contentType = CCorePlugin.getContentType((IProject)project, (String)input.getName());
        }
        if (contentType == null && cElement != null && ((elementType = cElement.getElementType()) == 18 || elementType == 14)) {
            contentType = Platform.getContentTypeManager().getContentType("org.eclipse.cdt.core.binaryFile");
        }
        if ((desc = (registry = PlatformUI.getWorkbench().getEditorRegistry()).getDefaultEditor(input.getName(), contentType)) != null) {
            String editorID = desc.getId();
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                IDE.setDefaultEditor((IFile)file, (String)editorID);
            }
            return editorID;
        }
        return DEFAULT_TEXT_EDITOR_ID;
    }

    public static int findLocalizedModifier(String token) {
        if (token == null) {
            return 0;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)262144))) {
            return 262144;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)131072))) {
            return 131072;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)65536))) {
            return 65536;
        }
        if (token.equalsIgnoreCase(Action.findModifierString((int)0x400000))) {
            return 0x400000;
        }
        return 0;
    }

    public static String getModifierString(int stateMask) {
        String modifierString = "";
        if ((stateMask & 0x40000) == 262144) {
            modifierString = EditorUtility.appendModifierString(modifierString, 262144);
        }
        if ((stateMask & 0x10000) == 65536) {
            modifierString = EditorUtility.appendModifierString(modifierString, 65536);
        }
        if ((stateMask & 0x20000) == 131072) {
            modifierString = EditorUtility.appendModifierString(modifierString, 131072);
        }
        if ((stateMask & 0x400000) == 0x400000) {
            modifierString = EditorUtility.appendModifierString(modifierString, 0x400000);
        }
        return modifierString;
    }

    private static String appendModifierString(String modifierString, int modifier) {
        if (modifierString == null) {
            modifierString = "";
        }
        String newModifierString = Action.findModifierString((int)modifier);
        if (modifierString.length() == 0) {
            return newModifierString;
        }
        return CEditorMessages.getFormattedString("EditorUtility.concatModifierStrings", new String[]{modifierString, newModifierString});
    }

    public static IStorage getStorage(IBinary bin) {
        FileStorage store = null;
        try {
            IBuffer buffer = bin.getBuffer();
            if (buffer != null) {
                store = new FileStorage((InputStream)new ByteArrayInputStream(buffer.getContents().getBytes()), bin.getPath());
            }
        }
        catch (CModelException cModelException) {}
        return store;
    }

    public static ICProject getCProject(IEditorInput input) {
        ICProject cProject = null;
        if (input instanceof IFileEditorInput) {
            IProject project = ((IFileEditorInput)input).getFile().getProject();
            if (project != null && !(cProject = CoreModel.getDefault().create(project)).exists()) {
                cProject = null;
            }
        } else if (input instanceof ITranslationUnitEditorInput) {
            IResource resource;
            ITranslationUnit tu = ((ITranslationUnitEditorInput)input).getTranslationUnit();
            if (tu != null) {
                cProject = tu.getCProject();
            } else if (input instanceof ExternalEditorInput && (resource = ((ExternalEditorInput)input).getMarkerResource()) instanceof IProject) {
                cProject = CoreModel.getDefault().create((IProject)resource);
            }
        }
        return cProject;
    }
}

