/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.compare;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.dom.NullCodeReaderFactory;
import org.eclipse.cdt.internal.ui.compare.CStructureCreatorVisitor;
import org.eclipse.cdt.internal.ui.text.doctools.DocCommentOwnerManager;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.doctools.IDocCommentOwner;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ResourceNode;
import org.eclipse.compare.contentmergeviewer.IDocumentRange;
import org.eclipse.compare.structuremergeviewer.DocumentRangeNode;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.compare.structuremergeviewer.StructureCreator;
import org.eclipse.compare.structuremergeviewer.StructureRootNode;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.Position;

public class CStructureCreator
extends StructureCreator {
    private static final String NAME = "CStructureCreator.name";

    public String getName() {
        return CUIPlugin.getResourceString(NAME);
    }

    public String getContents(Object node, boolean ignoreWhitespace) {
        if (node instanceof IDocumentRange) {
            IDocumentRange documentRange = (IDocumentRange)node;
            Position range = documentRange.getRange();
            try {
                return documentRange.getDocument().get(range.getOffset(), range.getLength());
            }
            catch (BadLocationException badLocationException) {}
        }
        if (node instanceof IStreamContentAccessor) {
            IStreamContentAccessor sca = (IStreamContentAccessor)node;
            try {
                return CStructureCreator.readString(sca);
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    protected IStructureComparator createStructureComparator(Object element, IDocument document, ISharedDocumentAdapter sharedDocumentAdapter, IProgressMonitor monitor) throws CoreException {
        StructureRootNode root = new StructureRootNode(document, element, (StructureCreator)this, sharedDocumentAdapter);
        ICodeReaderFactory codeReaderFactory = NullCodeReaderFactory.getInstance();
        ScannerInfo scanInfo = new ScannerInfo();
        CodeReader reader = new CodeReader(document.get().toCharArray());
        boolean[] isSource = new boolean[1];
        ILanguage language = this.determineLanguage(element, isSource);
        try {
            int options = isSource[0] ? 8 : 0;
            IASTTranslationUnit ast = language.getASTTranslationUnit(reader, (IScannerInfo)scanInfo, codeReaderFactory, null, options, ParserUtil.getParserLogService());
            CStructureCreatorVisitor structureCreator = new CStructureCreatorVisitor((DocumentRangeNode)root);
            ast.accept((ASTVisitor)structureCreator);
        }
        catch (CoreException exc) {
            CUIPlugin.log(exc);
        }
        return root;
    }

    private ILanguage determineLanguage(Object element, boolean[] isSource) {
        ITranslationUnit tUnit;
        IResource resource;
        GPPLanguage language = null;
        if (element instanceof ResourceNode && (resource = ((ResourceNode)element).getResource()).getType() == 1 && (tUnit = (ITranslationUnit)CoreModel.getDefault().create(resource)) != null) {
            try {
                language = tUnit.getLanguage();
                isSource[0] = tUnit.isSourceUnit();
            }
            catch (CoreException coreException) {}
        }
        if (language == null) {
            language = GPPLanguage.getDefault();
        }
        return language;
    }

    protected String getDocumentPartitioning() {
        return "___c_partitioning";
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        IDocCommentOwner owner = DocCommentOwnerManager.getInstance().getWorkspaceCommentOwner();
        return CUIPlugin.getDefault().getTextTools().createDocumentPartitioner(owner);
    }

    private static String readString(IStreamContentAccessor sa) throws CoreException {
        InputStream is = sa.getContents();
        if (is != null) {
            String encoding = null;
            if (sa instanceof IEncodedStreamContentAccessor) {
                try {
                    encoding = ((IEncodedStreamContentAccessor)sa).getCharset();
                }
                catch (Exception exception) {}
            }
            if (encoding == null) {
                encoding = ResourcesPlugin.getEncoding();
            }
            return CStructureCreator.readString(is, encoding);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String readString(InputStream is, String encoding) {
        if (is == null) {
            return null;
        }
        BufferedReader reader = null;
        StringBuffer buffer = new StringBuffer();
        char[] part = new char[2048];
        int read = 0;
        reader = new BufferedReader(new InputStreamReader(is, encoding));
        while ((read = reader.read(part)) != -1) {
            buffer.append(part, 0, read);
        }
        String string = buffer.toString();
        if (reader == null) return string;
        try {
            reader.close();
            return string;
        }
        catch (IOException iOException) {}
        return string;
        catch (IOException iOException) {
            try {
                if (reader == null) return null;
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                reader.close();
                return null;
            }
            catch (IOException iOException3) {}
            return null;
        }
    }
}

