/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.editor.AbstractCModelOutlinePage;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.search.actions.SelectionSearchGroup;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.cdt.ui.actions.CustomFiltersActionGroup;
import org.eclipse.cdt.ui.actions.MemberFilterActionGroup;
import org.eclipse.cdt.ui.actions.OpenViewActionGroup;
import org.eclipse.cdt.ui.refactoring.actions.CRefactoringActionGroup;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.ITextEditor;

public class CContentOutlinePage
extends AbstractCModelOutlinePage {
    private Composite fParent;
    private StackLayout fStackLayout;
    private Composite fOutlinePage;
    private Control fStatusPage;
    private boolean fScalabilityMode;

    public CContentOutlinePage(CEditor editor) {
        super("#TranslationUnitOutlinerContext", (ITextEditor)editor);
    }

    public CEditor getEditor() {
        return (CEditor)this.fEditor;
    }

    public void createControl(Composite parent) {
        this.fParent = new Composite(parent, 0);
        this.fStackLayout = new StackLayout();
        this.fParent.setLayout((Layout)this.fStackLayout);
        this.fOutlinePage = new Composite(this.fParent, 0);
        this.fOutlinePage.setLayout((Layout)new FillLayout());
        super.createControl(this.fOutlinePage);
        this.fStatusPage = this.createStatusPage(this.fParent);
        this.updateVisiblePage();
    }

    public Control getControl() {
        return this.fParent;
    }

    private Control createStatusPage(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(CEditorMessages.getString("Scalability.outlineDisabled"));
        return label;
    }

    public void setInput(ITranslationUnit unit) {
        CEditor editor = this.getEditor();
        if (editor.isEnableScalablilityMode() && PreferenceConstants.getPreferenceStore().getBoolean("scalability.reconciler")) {
            this.fScalabilityMode = true;
            super.setInput(null);
        } else {
            this.fScalabilityMode = false;
            super.setInput(unit);
        }
        this.updateVisiblePage();
    }

    private void updateVisiblePage() {
        if (this.fStackLayout == null) {
            return;
        }
        if (this.fScalabilityMode) {
            if (this.fStackLayout.topControl != this.fStatusPage) {
                this.fStackLayout.topControl = this.fStatusPage;
                this.fParent.layout();
            }
        } else if (this.fStackLayout.topControl != this.fOutlinePage) {
            this.fStackLayout.topControl = this.fOutlinePage;
            this.fParent.layout();
        }
    }

    protected ActionGroup createSearchActionGroup() {
        return new SelectionSearchGroup(this);
    }

    protected ActionGroup createOpenViewActionGroup() {
        OpenViewActionGroup ovag = new OpenViewActionGroup(this, this.getEditor());
        ovag.setEnableIncludeBrowser(true);
        return ovag;
    }

    protected ActionGroup createRefactoringActionGroup() {
        return new CRefactoringActionGroup(this);
    }

    protected ActionGroup createCustomFiltersActionGroup() {
        return new CustomFiltersActionGroup("org.eclipse.cdt.ui.COutlinePage", (StructuredViewer)this.getTreeViewer());
    }

    protected ActionGroup createMemberFilterActionGroup() {
        return new MemberFilterActionGroup((StructuredViewer)this.getTreeViewer(), "COutlineViewer");
    }
}

