/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CElementHyperlink;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.texteditor.ITextEditor;

public class CElementHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, final IRegion region, boolean canShowMultipleHyperlinks) {
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (region == null || !(textEditor instanceof CEditor)) {
            return null;
        }
        final IAction openAction = textEditor.getAction("OpenDeclarations");
        if (openAction == null) {
            return null;
        }
        try {
            String partitionType = TextUtilities.getContentType((IDocument)textViewer.getDocument(), (String)"___c_partitioning", (int)region.getOffset(), (boolean)false);
            if (!"__dftl_partition_content_type".equals(partitionType) && !"__c_preprocessor".equals(partitionType)) {
                return null;
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        IWorkingCopy workingCopy = CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(textEditor.getEditorInput());
        if (workingCopy == null) {
            return null;
        }
        final IHyperlink[] result = new IHyperlink[1];
        IStatus status = ASTProvider.getASTProvider().runOnAST((ICElement)workingCopy, ASTProvider.WAIT_ACTIVE_ONLY, null, new ASTCache.ASTRunnable(){

            public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) {
                if (ast != null) {
                    int offset = region.getOffset();
                    int length = Math.max(1, region.getLength());
                    IASTNodeSelector nodeSelector = ast.getNodeSelector(null);
                    IASTName selectedName = nodeSelector.findEnclosingName(offset, length);
                    IASTFileLocation linkLocation = null;
                    if (selectedName != null) {
                        linkLocation = selectedName.getParent() instanceof IASTPreprocessorIncludeStatement ? selectedName.getParent().getFileLocation() : selectedName.getFileLocation();
                    } else {
                        IASTNode cand = nodeSelector.findEnclosingNode(offset, length);
                        if (cand instanceof IASTPreprocessorIncludeStatement) {
                            linkLocation = cand.getFileLocation();
                        }
                    }
                    if (linkLocation != null) {
                        result[0] = new CElementHyperlink((IRegion)new Region(linkLocation.getNodeOffset(), linkLocation.getNodeLength()), openAction);
                    }
                }
                return Status.OK_STATUS;
            }
        });
        if (!status.isOK()) {
            CUIPlugin.log(status);
        }
        return result[0] == null ? null : result;
    }
}

