/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElseStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorEndifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfdefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.LineBackgroundPainter;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.internal.ui.text.ICReconcilingListener;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InactiveCodeHighlighting
implements ICReconcilingListener,
ITextInputListener {
    private LineBackgroundPainter fLineBackgroundPainter;
    private String fHighlightKey;
    private ITranslationUnit fTranslationUnit;
    private Job fUpdateJob;
    private Object fJobLock = new Object();
    private CEditor fEditor;
    private List<Position> fInactiveCodePositions = Collections.emptyList();
    private IDocument fDocument;

    public InactiveCodeHighlighting(String highlightKey) {
        this.fHighlightKey = highlightKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob() {
        Object object = this.fJobLock;
        synchronized (object) {
            if (this.fUpdateJob == null) {
                this.fUpdateJob = new Job(CEditorMessages.getString("InactiveCodeHighlighting_job")){

                    protected IStatus run(final IProgressMonitor monitor) {
                        IStatus result = Status.OK_STATUS;
                        if (InactiveCodeHighlighting.this.fTranslationUnit != null) {
                            ASTProvider astProvider = CUIPlugin.getDefault().getASTProvider();
                            result = astProvider.runOnAST((ICElement)InactiveCodeHighlighting.this.fTranslationUnit, ASTProvider.WAIT_IF_OPEN, monitor, new ASTCache.ASTRunnable(){

                                public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) {
                                    InactiveCodeHighlighting.this.reconciled(ast, true, monitor);
                                    return Status.OK_STATUS;
                                }
                            });
                        }
                        if (monitor.isCanceled()) {
                            result = Status.CANCEL_STATUS;
                        }
                        return result;
                    }
                };
                this.fUpdateJob.setPriority(50);
            }
            if (this.fUpdateJob.getState() == 0) {
                this.fUpdateJob.schedule();
            }
        }
    }

    public void install(CEditor editor, LineBackgroundPainter lineBackgroundPainter) {
        assert (this.fEditor == null);
        assert (editor != null && lineBackgroundPainter != null);
        this.fEditor = editor;
        this.fLineBackgroundPainter = lineBackgroundPainter;
        ICElement cElement = this.fEditor.getInputCElement();
        this.fTranslationUnit = cElement instanceof ITranslationUnit ? (ITranslationUnit)cElement : null;
        this.fDocument = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
        this.fEditor.getViewer().addTextInputListener((ITextInputListener)this);
        this.fEditor.addReconcileListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uninstall() {
        Object object = this.fJobLock;
        synchronized (object) {
            if (this.fUpdateJob != null && this.fUpdateJob.getState() == 4) {
                this.fUpdateJob.cancel();
            }
        }
        if (this.fLineBackgroundPainter != null && !this.fLineBackgroundPainter.isDisposed()) {
            this.fLineBackgroundPainter.removeHighlightPositions(this.fInactiveCodePositions);
            this.fInactiveCodePositions = Collections.emptyList();
            this.fLineBackgroundPainter = null;
        }
        if (this.fEditor != null) {
            this.fEditor.removeReconcileListener(this);
            if (this.fEditor.getViewer() != null) {
                this.fEditor.getViewer().removeTextInputListener((ITextInputListener)this);
            }
            this.fEditor = null;
            this.fTranslationUnit = null;
            this.fDocument = null;
        }
    }

    public void refresh() {
        this.scheduleJob();
    }

    @Override
    public void aboutToBeReconciled() {
    }

    @Override
    public void reconciled(IASTTranslationUnit ast, boolean force, IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return;
        }
        final List<Position> newInactiveCodePositions = this.collectInactiveCodePositions(ast);
        Runnable updater = new Runnable(){

            public void run() {
                if (InactiveCodeHighlighting.this.fEditor != null && InactiveCodeHighlighting.this.fLineBackgroundPainter != null && !InactiveCodeHighlighting.this.fLineBackgroundPainter.isDisposed()) {
                    InactiveCodeHighlighting.this.fLineBackgroundPainter.replaceHighlightPositions(InactiveCodeHighlighting.this.fInactiveCodePositions, newInactiveCodePositions);
                    InactiveCodeHighlighting.this.fInactiveCodePositions = newInactiveCodePositions;
                }
            }
        };
        if (this.fEditor != null) {
            Display.getDefault().asyncExec(updater);
        }
    }

    private List<Position> collectInactiveCodePositions(IASTTranslationUnit translationUnit) {
        IASTPreprocessorStatement[] preprocStmts;
        if (translationUnit == null) {
            return Collections.emptyList();
        }
        String fileName = translationUnit.getFilePath();
        if (fileName == null) {
            return Collections.emptyList();
        }
        ArrayList<Position> positions = new ArrayList<Position>();
        int inactiveCodeStart = -1;
        boolean inInactiveCode = false;
        Stack<Boolean> inactiveCodeStack = new Stack<Boolean>();
        IASTPreprocessorStatement[] iASTPreprocessorStatementArray = preprocStmts = translationUnit.getAllPreprocessorStatements();
        int n = preprocStmts.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPreprocessorStatement statement = iASTPreprocessorStatementArray[n2];
            IASTFileLocation floc = statement.getFileLocation();
            if (floc != null && fileName.equals(floc.getFileName())) {
                int inactiveCodeEnd;
                if (statement instanceof IASTPreprocessorIfStatement) {
                    IASTPreprocessorIfStatement ifStmt = (IASTPreprocessorIfStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = floc.getNodeOffset();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorIfdefStatement) {
                    IASTPreprocessorIfdefStatement ifdefStmt = (IASTPreprocessorIfdefStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifdefStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = floc.getNodeOffset();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorIfndefStatement) {
                    IASTPreprocessorIfndefStatement ifndefStmt = (IASTPreprocessorIfndefStatement)statement;
                    inactiveCodeStack.push(inInactiveCode);
                    if (!ifndefStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = floc.getNodeOffset();
                        inInactiveCode = true;
                    }
                } else if (statement instanceof IASTPreprocessorElseStatement) {
                    IASTPreprocessorElseStatement elseStmt = (IASTPreprocessorElseStatement)statement;
                    if (!elseStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = floc.getNodeOffset();
                        inInactiveCode = true;
                    } else if (elseStmt.taken() && inInactiveCode) {
                        inactiveCodeEnd = floc.getNodeOffset();
                        positions.add((Position)this.createHighlightPosition(inactiveCodeStart, inactiveCodeEnd, false, this.fHighlightKey));
                        inInactiveCode = false;
                    }
                } else if (statement instanceof IASTPreprocessorElifStatement) {
                    IASTPreprocessorElifStatement elifStmt = (IASTPreprocessorElifStatement)statement;
                    if (!elifStmt.taken() && !inInactiveCode) {
                        inactiveCodeStart = floc.getNodeOffset();
                        inInactiveCode = true;
                    } else if (elifStmt.taken() && inInactiveCode) {
                        inactiveCodeEnd = floc.getNodeOffset();
                        positions.add((Position)this.createHighlightPosition(inactiveCodeStart, inactiveCodeEnd, false, this.fHighlightKey));
                        inInactiveCode = false;
                    }
                } else if (statement instanceof IASTPreprocessorEndifStatement) {
                    try {
                        boolean wasInInactiveCode = (Boolean)inactiveCodeStack.pop();
                        if (inInactiveCode && !wasInInactiveCode) {
                            inactiveCodeEnd = floc.getNodeOffset() + floc.getNodeLength();
                            positions.add((Position)this.createHighlightPosition(inactiveCodeStart, inactiveCodeEnd, true, this.fHighlightKey));
                        }
                        inInactiveCode = wasInInactiveCode;
                    }
                    catch (EmptyStackException emptyStackException) {}
                }
            }
            ++n2;
        }
        if (inInactiveCode) {
            int inactiveCodeEnd = this.fDocument.getLength();
            positions.add((Position)this.createHighlightPosition(inactiveCodeStart, inactiveCodeEnd, true, this.fHighlightKey));
        }
        return positions;
    }

    private HighlightPosition createHighlightPosition(int startOffset, int endOffset, boolean inclusive, String key) {
        IDocument document = this.fDocument;
        try {
            if (document != null) {
                int start = document.getLineOfOffset(startOffset);
                int end = document.getLineOfOffset(endOffset);
                startOffset = document.getLineOffset(start);
                if (!inclusive) {
                    endOffset = document.getLineOffset(end);
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        return new HighlightPosition(startOffset, endOffset - startOffset, key);
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        if (this.fEditor != null && this.fLineBackgroundPainter != null && !this.fLineBackgroundPainter.isDisposed()) {
            this.fLineBackgroundPainter.removeHighlightPositions(this.fInactiveCodePositions);
            this.fInactiveCodePositions = Collections.emptyList();
        }
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        this.fDocument = newInput;
    }

    private static class HighlightPosition
    extends TypedPosition
    implements IRegion {
        public HighlightPosition(int offset, int length, String type) {
            super(offset, length, type);
        }

        public HighlightPosition(IRegion region, String type) {
            super(region.getOffset(), region.getLength(), type);
        }
    }
}

