/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor.asm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.IAsmLanguage;
import org.eclipse.cdt.internal.ui.text.AbstractCScanner;
import org.eclipse.cdt.internal.ui.text.CHeaderRule;
import org.eclipse.cdt.internal.ui.text.CWhitespaceRule;
import org.eclipse.cdt.internal.ui.text.PreprocessorRule;
import org.eclipse.cdt.internal.ui.text.util.CWordDetector;
import org.eclipse.cdt.ui.text.ITokenStoreFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsmPreprocessorScanner
extends AbstractCScanner {
    private static final String[] fgTokenProperties = new String[]{"c_single_line_comment", "pp_directive", "c_string", "pp_header", "pp_default"};
    private IAsmLanguage fAsmLanguage;

    public AsmPreprocessorScanner(ITokenStoreFactory factory, IAsmLanguage asmLanguage) {
        super(factory.createTokenStore(fgTokenProperties));
        Assert.isNotNull((Object)asmLanguage);
        this.fAsmLanguage = asmLanguage;
        this.setRules(this.createRules());
    }

    protected List<IRule> createRules() {
        ArrayList<IRule> rules = new ArrayList<IRule>();
        IToken defaultToken = this.getToken("pp_default");
        rules.add(new CWhitespaceRule(defaultToken));
        IToken token = this.getToken("pp_directive");
        PreprocessorRule preprocessorRule = new PreprocessorRule(new CWordDetector(), defaultToken, this.getToken("c_single_line_comment"));
        String[] ppKeywords = this.fAsmLanguage.getPreprocessorKeywords();
        int i = 0;
        while (i < ppKeywords.length) {
            String ppKeyword = ppKeywords[i];
            if (ppKeyword.length() > 1) {
                preprocessorRule.addWord(ppKeyword, token);
            }
            ++i;
        }
        preprocessorRule.addWord("##", token);
        rules.add((IRule)preprocessorRule);
        token = this.getToken("pp_header");
        CHeaderRule headerRule = new CHeaderRule(token);
        rules.add(headerRule);
        token = this.getToken("c_single_line_comment");
        EndOfLineRule lineCommentRule = new EndOfLineRule("#", token);
        rules.add((IRule)lineCommentRule);
        this.setDefaultReturnToken(defaultToken);
        return rules;
    }
}

