/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.cdt.internal.ui.preferences.OverlayPreferenceStore;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.preferences.ProposalFilterPreferencesUtil;
import org.eclipse.cdt.internal.ui.util.PixelConverter;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class AbstractPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected OverlayPreferenceStore fOverlayStore;
    private ArrayList<SelectionListener> fMasterSlaveListeners = new ArrayList();
    protected Map<Object, String> fTextFields = new HashMap<Object, String>();
    private ModifyListener fTextFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.widget;
            AbstractPreferencePage.this.fOverlayStore.setValue(AbstractPreferencePage.this.fTextFields.get(text), text.getText());
        }
    };
    protected Map<Object, String> fComboBoxes = new HashMap<Object, String>();
    private ModifyListener fComboBoxListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Combo combo = (Combo)e.widget;
            String state = ProposalFilterPreferencesUtil.comboStateAsString(combo);
            AbstractPreferencePage.this.fOverlayStore.setValue(AbstractPreferencePage.this.fComboBoxes.get(combo), state);
        }
    };
    protected Map<Object, String> fCheckBoxes = new HashMap<Object, String>();
    private SelectionListener fCheckBoxListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            AbstractPreferencePage.this.fOverlayStore.setValue(AbstractPreferencePage.this.fCheckBoxes.get(button), button.getSelection());
        }
    };
    protected ArrayList<Text> fNumberFields = new ArrayList();
    private ModifyListener fNumberFieldListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            AbstractPreferencePage.this.numberFieldChanged((Text)e.widget);
        }
    };
    protected Map<Object, String> fColorButtons = new HashMap<Object, String>();
    private SelectionListener fColorButtonListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            ColorSelector editor = (ColorSelector)e.widget.getData();
            PreferenceConverter.setValue((IPreferenceStore)AbstractPreferencePage.this.fOverlayStore, (String)AbstractPreferencePage.this.fColorButtons.get(editor), (RGB)editor.getColorValue());
        }
    };
    protected static final int NO_TEXT_LIMIT = -1;

    protected Button addRadioButton(Composite parent, String label, String key, int indentation) {
        Button radioButton = new Button(parent, 16);
        radioButton.setText(label);
        GridData gd = new GridData(768);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        radioButton.setLayoutData((Object)gd);
        radioButton.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(radioButton, key);
        return radioButton;
    }

    protected Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(768);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    protected Group addGroupBox(Composite parent, String label, int nColumns) {
        Group group = new Group(parent, 0);
        group.setText(label);
        GridLayout layout = new GridLayout();
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        layout.numColumns = nColumns;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gd);
        return group;
    }

    protected Control addTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        this.fTextFields.put(textControl, key);
        if (isNumber) {
            this.fNumberFields.add(textControl);
            textControl.addModifyListener(this.fNumberFieldListener);
        } else {
            textControl.addModifyListener(this.fTextFieldListener);
        }
        return textControl;
    }

    protected void addComboBox(Composite composite, String label, String key, int textLimit, int indentation) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Combo comboControl = new Combo(composite, 2060);
        gd = new GridData(128);
        if (textLimit != -1) {
            gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
            comboControl.setTextLimit(textLimit);
        }
        comboControl.setLayoutData((Object)gd);
        this.fComboBoxes.put(comboControl, key);
        comboControl.addModifyListener(this.fComboBoxListener);
    }

    protected void addFiller(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    protected void createDependency(final Button master, String masterKey, final Control slave) {
        this.indent(slave);
        boolean masterState = this.fOverlayStore.getBoolean(masterKey);
        slave.setEnabled(masterState);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                slave.setEnabled(master.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        master.addSelectionListener(listener);
        this.fMasterSlaveListeners.add(listener);
    }

    protected void numberFieldChanged(Text textControl) {
        String number = textControl.getText();
        IStatus status = this.validatePositiveNumber(number);
        if (!status.matches(4)) {
            this.fOverlayStore.setValue(this.fTextFields.get(textControl), number);
        }
        this.updateStatus(status);
    }

    private IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(PreferencesMessages.CEditorPreferencePage_empty_input);
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(NLS.bind((String)PreferencesMessages.CEditorPreferencePage_invalid_input, (Object)number));
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(NLS.bind((String)PreferencesMessages.CEditorPreferencePage_invalid_input, (Object)number));
            }
        }
        return status;
    }

    protected void updateStatus(IStatus status) {
        if (!status.matches(4)) {
            int i = 0;
            while (i < this.fNumberFields.size()) {
                Text text = this.fNumberFields.get(i);
                IStatus s = this.validatePositiveNumber(text.getText());
                status = StatusUtil.getMoreSevere(s, status);
                ++i;
            }
        }
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    protected void indent(Control control) {
        GridData gridData = new GridData();
        gridData.horizontalIndent = 20;
        control.setLayoutData((Object)gridData);
    }

    protected Control addColorButton(Composite parent, String label, String key, int indentation) {
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        gd = new GridData(768);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        ColorSelector editor = new ColorSelector(composite);
        Button button = editor.getButton();
        button.setData((Object)editor);
        gd = new GridData();
        gd.horizontalAlignment = 3;
        button.setLayoutData((Object)gd);
        button.addSelectionListener(this.fColorButtonListener);
        this.fColorButtons.put(editor, key);
        return composite;
    }

    public AbstractPreferencePage() {
        this.setPreferenceStore(PreferenceConstants.getPreferenceStore());
        this.fOverlayStore = new OverlayPreferenceStore(this.getPreferenceStore(), this.createOverlayStoreKeys());
    }

    protected abstract OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys();

    protected void initializeFields() {
        String key;
        for (ColorSelector colorSelector : this.fColorButtons.keySet()) {
            key = this.fColorButtons.get(colorSelector);
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
            colorSelector.setColorValue(rgb);
        }
        for (Button button : this.fCheckBoxes.keySet()) {
            key = this.fCheckBoxes.get(button);
            button.setSelection(this.fOverlayStore.getBoolean(key));
        }
        for (Text text : this.fTextFields.keySet()) {
            key = this.fTextFields.get(text);
            text.setText(this.fOverlayStore.getString(key));
        }
        for (Combo combo : this.fComboBoxes.keySet()) {
            key = this.fComboBoxes.get(combo);
            String state = this.fOverlayStore.getString(key);
            ProposalFilterPreferencesUtil.restoreComboFromString(combo, state);
        }
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        CUIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        super.performDefaults();
    }

    public void dispose() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }
}

