/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTVisibilityLabel;
import org.eclipse.cdt.internal.ui.refactoring.Messages;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.utils.VisibilityEnum;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddDeclarationNodeToClassChange {
    private final ICPPASTCompositeTypeSpecifier nodeClass;
    private final VisibilityEnum visibility;
    private ArrayList<IASTNode> fieldNodes = new ArrayList();
    private final ModificationCollector collector;

    public static void createChange(ICPPASTCompositeTypeSpecifier nodeClass, VisibilityEnum visibility, IASTNode fieldNodes, boolean isField, ModificationCollector collector) {
        new AddDeclarationNodeToClassChange(nodeClass, visibility, fieldNodes, collector, isField);
    }

    public static void createChange(ICPPASTCompositeTypeSpecifier nodeClass, VisibilityEnum visibility, ArrayList<IASTNode> fieldNodes, boolean isField, ModificationCollector collector) {
        new AddDeclarationNodeToClassChange(nodeClass, visibility, fieldNodes, collector, isField);
    }

    private AddDeclarationNodeToClassChange(ICPPASTCompositeTypeSpecifier nodeClass, VisibilityEnum visibility, ArrayList<IASTNode> fieldNodes, ModificationCollector collector, boolean isField) {
        this.fieldNodes = fieldNodes;
        this.nodeClass = nodeClass;
        this.visibility = visibility;
        this.collector = collector;
        this.createRewrites(isField);
    }

    private AddDeclarationNodeToClassChange(ICPPASTCompositeTypeSpecifier nodeClass, VisibilityEnum visibility, IASTNode fieldNodes, ModificationCollector collector, boolean isField) {
        this.nodeClass = nodeClass;
        this.visibility = visibility;
        this.fieldNodes.add(fieldNodes);
        this.collector = collector;
        this.createRewrites(isField);
    }

    private void createRewrites(boolean isField) {
        int lastFunctionDeclaration = -1;
        int lastFieldDeclaration = -1;
        IASTDeclaration[] members = this.nodeClass.getMembers();
        VisibilityEnum currentVisibility = VisibilityEnum.v_private;
        if (1 == this.nodeClass.getKey()) {
            currentVisibility = VisibilityEnum.v_public;
        }
        int i = 0;
        while (i < members.length) {
            IASTDeclaration declaration = members[i];
            if (declaration instanceof ICPPASTVisibilityLabel) {
                currentVisibility = VisibilityEnum.from((ICPPASTVisibilityLabel)declaration);
            }
            if (declaration instanceof IASTSimpleDeclaration) {
                IASTSimpleDeclaration simple = (IASTSimpleDeclaration)declaration;
                IASTDeclarator[] declarators = simple.getDeclarators();
                if (declarators.length > 0 && declarators[0] != null && declarators[0] instanceof IASTFunctionDeclarator) {
                    if (currentVisibility.equals((Object)this.visibility)) {
                        lastFunctionDeclaration = i;
                    }
                } else if (declarators.length > 0 && declarators[0] != null && currentVisibility.equals((Object)this.visibility)) {
                    lastFieldDeclaration = i;
                }
            }
            ++i;
        }
        IASTDeclaration nextFunctionDeclaration = null;
        if (lastFunctionDeclaration < members.length - 1 && lastFunctionDeclaration >= 0) {
            nextFunctionDeclaration = members[lastFunctionDeclaration + 1];
        }
        IASTDeclaration nextFieldDeclaration = null;
        if (lastFieldDeclaration < members.length - 1 && lastFieldDeclaration >= 0) {
            nextFieldDeclaration = members[lastFieldDeclaration + 1];
        }
        this.createInsert(isField, nextFunctionDeclaration, nextFieldDeclaration, currentVisibility);
    }

    private void createInsert(boolean isField, IASTDeclaration nextFunctionDeclaration, IASTDeclaration nextFieldDeclaration, VisibilityEnum currentVisibility) {
        if (isField) {
            if (nextFieldDeclaration != null) {
                this.insertBefore((IASTNode)nextFieldDeclaration);
            } else if (nextFunctionDeclaration != null) {
                this.insertBefore((IASTNode)nextFunctionDeclaration);
            } else {
                this.insertAtTheEnd(currentVisibility);
            }
        } else if (nextFunctionDeclaration != null) {
            this.insertBefore((IASTNode)nextFunctionDeclaration);
        } else if (nextFieldDeclaration != null) {
            this.insertBefore((IASTNode)nextFieldDeclaration);
        } else {
            this.insertAtTheEnd(currentVisibility);
        }
    }

    private void insertBefore(IASTNode nearestNode) {
        ASTRewrite rewrite = this.collector.rewriterForTranslationUnit(nearestNode.getTranslationUnit());
        for (IASTNode node : this.fieldNodes) {
            rewrite.insertBefore(nearestNode.getParent(), nearestNode, node, this.createEditDescription());
        }
    }

    private void insertAtTheEnd(VisibilityEnum currentVisibility) {
        ASTRewrite rewrite = this.collector.rewriterForTranslationUnit(this.nodeClass.getTranslationUnit());
        if (!currentVisibility.equals((Object)this.visibility)) {
            CPPASTVisibilityLabel label = new CPPASTVisibilityLabel(this.visibility.getICPPASTVisiblityLabelVisibility());
            rewrite.insertBefore((IASTNode)this.nodeClass, null, (IASTNode)label, this.createEditDescription());
        }
        for (IASTNode node : this.fieldNodes) {
            rewrite.insertBefore((IASTNode)this.nodeClass, null, node, this.createEditDescription());
        }
    }

    private TextEditGroup createEditDescription() {
        return new TextEditGroup(NLS.bind((String)Messages.AddDeclarationNodeToClassChange_AddDeclaration, (Object)this.nodeClass.getName()));
    }
}

