/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTArrayDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTArrayModifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.CPPASTVisitor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateTypeParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTArrayDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTParameterDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTReferenceOperator;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ASTWriter;
import org.eclipse.cdt.internal.ui.refactoring.Messages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeContainer {
    private final ArrayList<IASTNode> vec = new ArrayList();
    private final ArrayList<NameInformation> names = new ArrayList();

    public int size() {
        return this.vec.size();
    }

    public void add(IASTNode node) {
        this.vec.add(node);
    }

    public void findAllNames() {
        for (IASTNode node : this.vec) {
            node.accept((ASTVisitor)new CPPASTVisitor(){
                {
                    this.shouldVisitNames = true;
                }

                public int visit(IASTName name) {
                    IBinding bind = name.resolveBinding();
                    if (bind instanceof ICPPBinding && !(bind instanceof ICPPTemplateTypeParameter)) {
                        ICPPBinding cppBind = (ICPPBinding)bind;
                        try {
                            if (!cppBind.isGloballyQualified()) {
                                IASTName[] refs;
                                NameInformation nameInformation = new NameInformation(name);
                                IASTName[] iASTNameArray = refs = name.getTranslationUnit().getReferences(bind);
                                int n = refs.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IASTName ref = iASTNameArray[n2];
                                    nameInformation.addReference(ref);
                                    ++n2;
                                }
                                NodeContainer.this.names.add(nameInformation);
                            }
                        }
                        catch (DOMException e) {
                            ILog logger = CUIPlugin.getDefault().getLog();
                            Status status = new Status(2, "org.eclipse.cdt.ui", 0, e.getMessage(), (Throwable)e);
                            logger.log((IStatus)status);
                        }
                    }
                    return super.visit(name);
                }
            });
        }
        for (NameInformation nameInf : this.names) {
            IASTName[] decls;
            IASTName name = nameInf.getName();
            IASTTranslationUnit unit = name.getTranslationUnit();
            IASTName[] iASTNameArray = decls = unit.getDeclarationsInAST(name.resolveBinding());
            int n = decls.length;
            int n2 = 0;
            while (n2 < n) {
                IASTName declaration = iASTNameArray[n2];
                nameInf.setDeclaration(declaration);
                ++n2;
            }
        }
    }

    public ArrayList<NameInformation> getAllAfterUsedNames() {
        ArrayList<IASTName> declarations = new ArrayList<IASTName>();
        ArrayList<NameInformation> usedAfter = new ArrayList<NameInformation>();
        if (this.names.size() <= 0) {
            this.findAllNames();
        }
        for (NameInformation nameInf : this.names) {
            if (declarations.contains(nameInf.getDeclaration())) continue;
            declarations.add(nameInf.getDeclaration());
            if (!nameInf.isUsedAfterReferences()) continue;
            usedAfter.add(nameInf);
            nameInf.setReference(true);
        }
        return usedAfter;
    }

    public ArrayList<NameInformation> getAllAfterUsedNamesChoosenByUser() {
        ArrayList<IASTName> declarations = new ArrayList<IASTName>();
        ArrayList<NameInformation> usedAfter = new ArrayList<NameInformation>();
        for (NameInformation nameInf : this.names) {
            if (declarations.contains(nameInf.getDeclaration())) continue;
            declarations.add(nameInf.getDeclaration());
            if (!nameInf.isUserSetIsReference() && !nameInf.isUserSetIsReturnValue()) continue;
            usedAfter.add(nameInf);
        }
        return usedAfter;
    }

    public ArrayList<NameInformation> getUsedNamesUnique() {
        ArrayList<IASTName> declarations = new ArrayList<IASTName>();
        ArrayList<NameInformation> usedAfter = new ArrayList<NameInformation>();
        if (this.names.size() <= 0) {
            this.findAllNames();
        }
        for (NameInformation nameInf : this.names) {
            if (declarations.contains(nameInf.getDeclaration())) continue;
            declarations.add(nameInf.getDeclaration());
            usedAfter.add(nameInf);
        }
        return usedAfter;
    }

    public ArrayList<NameInformation> getAllDeclaredInScope() {
        ArrayList<IASTName> declarations = new ArrayList<IASTName>();
        ArrayList<NameInformation> usedAfter = new ArrayList<NameInformation>();
        for (NameInformation nameInf : this.names) {
            if (!nameInf.isDeclarationInScope() || declarations.contains(nameInf.getDeclaration()) || !nameInf.isUsedAfterReferences()) continue;
            declarations.add(nameInf.getDeclaration());
            usedAfter.add(nameInf);
            nameInf.setReturnValue(true);
            nameInf.setReference(false);
        }
        return usedAfter;
    }

    public List<IASTNode> getNodesToWrite() {
        return this.vec;
    }

    public int getStartOffset() {
        return this.getOffset(false);
    }

    public int getStartOffsetIncludingComments() {
        return this.getOffset(true);
    }

    private int getOffset(boolean includeComments) {
        int start = Integer.MAX_VALUE;
        for (IASTNode node : this.vec) {
            int nodeStart = Integer.MAX_VALUE;
            IASTNodeLocation[] nodeLocations = node.getNodeLocations();
            if (nodeLocations.length != 1) {
                IASTNodeLocation[] iASTNodeLocationArray = nodeLocations;
                int n = nodeLocations.length;
                int n2 = 0;
                while (n2 < n) {
                    int nodeOffset;
                    IASTNodeLocation location = iASTNodeLocationArray[n2];
                    if (location instanceof IASTMacroExpansionLocation) {
                        IASTMacroExpansionLocation macroLoc = (IASTMacroExpansionLocation)location;
                        nodeOffset = macroLoc.asFileLocation().getNodeOffset();
                    } else {
                        nodeOffset = node.getFileLocation().getNodeOffset();
                    }
                    if (nodeOffset < nodeStart) {
                        nodeStart = nodeOffset;
                    }
                    ++n2;
                }
            } else {
                nodeStart = node.getFileLocation().getNodeOffset();
            }
            if (nodeStart >= start) continue;
            start = nodeStart;
        }
        return start;
    }

    public int getEndOffset() {
        return this.getEndOffset(false);
    }

    public int getEndOffsetIncludingComments() {
        return this.getEndOffset(true);
    }

    private int getEndOffset(boolean includeComments) {
        int end = 0;
        for (IASTNode node : this.vec) {
            IASTNodeLocation[] nodeLocations;
            int fileOffset = 0;
            int length = 0;
            IASTNodeLocation[] iASTNodeLocationArray = nodeLocations = node.getNodeLocations();
            int n = nodeLocations.length;
            int n2 = 0;
            while (n2 < n) {
                int nodeLength;
                int nodeOffset;
                IASTNodeLocation location = iASTNodeLocationArray[n2];
                if (location instanceof IASTMacroExpansionLocation) {
                    IASTMacroExpansionLocation macroLoc = (IASTMacroExpansionLocation)location;
                    nodeOffset = macroLoc.asFileLocation().getNodeOffset();
                    nodeLength = macroLoc.asFileLocation().getNodeLength();
                } else {
                    nodeOffset = location.getNodeOffset();
                    nodeLength = location.getNodeLength();
                }
                if (fileOffset < nodeOffset) {
                    fileOffset = nodeOffset;
                    length = nodeLength;
                }
                ++n2;
            }
            int endNode = fileOffset + length;
            if (endNode <= end) continue;
            end = endNode;
        }
        return end;
    }

    public String toString() {
        return this.vec.toString();
    }

    public ArrayList<NameInformation> getNames() {
        return this.names;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NameInformation {
        private IASTName name;
        private IASTName declaration;
        private final ArrayList<IASTName> references;
        private ArrayList<IASTName> referencesAfterCached;
        private int lastCachedReferencesHash;
        private boolean isReference;
        private boolean isReturnValue;
        private boolean userSetIsReference;
        private boolean userSetIsReturnValue;
        private String userSetName;
        private int userOrder;

        public int getUserOrder() {
            return this.userOrder;
        }

        public void setUserOrder(int userOrder) {
            this.userOrder = userOrder;
        }

        public NameInformation(IASTName name) {
            this.name = name;
            this.references = new ArrayList();
        }

        public IASTName getDeclaration() {
            return this.declaration;
        }

        public void setDeclaration(IASTName declaration) {
            this.declaration = declaration;
        }

        public IASTName getName() {
            return this.name;
        }

        public void setName(IASTName name) {
            this.name = name;
        }

        public void addReference(IASTName name) {
            this.references.add(name);
        }

        public ArrayList<IASTName> getReferencesAfterSelection() {
            if (this.referencesAfterCached == null || this.lastCachedReferencesHash == this.references.hashCode()) {
                this.lastCachedReferencesHash = this.references.hashCode();
                this.referencesAfterCached = new ArrayList();
                for (IASTName ref : this.references) {
                    IASTFileLocation loc = ref.getFileLocation();
                    if (loc.getNodeOffset() < NodeContainer.this.getEndOffset()) continue;
                    this.referencesAfterCached.add(ref);
                }
            }
            return this.referencesAfterCached;
        }

        public boolean isUsedAfterReferences() {
            return this.getReferencesAfterSelection().size() > 0;
        }

        public ICPPASTParameterDeclaration getICPPASTParameterDeclaration(boolean isReference) {
            CPPASTDeclarator declarator;
            IASTSimpleDeclaration decl;
            CPPASTParameterDeclaration para = new CPPASTParameterDeclaration();
            IASTDeclarator sourceDeclarator = (IASTDeclarator)this.getDeclaration().getParent();
            if (sourceDeclarator.getParent() instanceof IASTSimpleDeclaration) {
                decl = (IASTSimpleDeclaration)sourceDeclarator.getParent();
                para.setDeclSpecifier(decl.getDeclSpecifier());
            } else if (sourceDeclarator.getParent() instanceof IASTParameterDeclaration) {
                decl = (IASTParameterDeclaration)sourceDeclarator.getParent();
                para.setDeclSpecifier(decl.getDeclSpecifier());
            }
            if (sourceDeclarator instanceof IASTArrayDeclarator) {
                IASTArrayModifier[] arrayModifiers;
                IASTArrayDeclarator arrDeclarator = (IASTArrayDeclarator)sourceDeclarator;
                declarator = new CPPASTArrayDeclarator();
                IASTArrayModifier[] iASTArrayModifierArray = arrayModifiers = arrDeclarator.getArrayModifiers();
                int n = arrayModifiers.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTArrayModifier arrayModifier = iASTArrayModifierArray[n2];
                    ((IASTArrayDeclarator)declarator).addArrayModifier(arrayModifier);
                    ++n2;
                }
            } else {
                declarator = new CPPASTDeclarator();
            }
            declarator.setName((IASTName)new CPPASTName(this.getDeclaration().toCharArray()));
            IASTPointerOperator[] iASTPointerOperatorArray = sourceDeclarator.getPointerOperators();
            int n = iASTPointerOperatorArray.length;
            int n3 = 0;
            while (n3 < n) {
                IASTPointerOperator pointerOp = iASTPointerOperatorArray[n3];
                declarator.addPointerOperator(pointerOp);
                ++n3;
            }
            if (isReference && !this.hasReferenceOperartor((IASTDeclarator)declarator)) {
                declarator.addPointerOperator((IASTPointerOperator)new CPPASTReferenceOperator());
            }
            declarator.setNestedDeclarator(sourceDeclarator.getNestedDeclarator());
            para.setDeclarator((IASTDeclarator)declarator);
            return para;
        }

        public boolean hasReferenceOperartor(IASTDeclarator declarator) {
            IASTPointerOperator[] iASTPointerOperatorArray = declarator.getPointerOperators();
            int n = iASTPointerOperatorArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTPointerOperator pOp = iASTPointerOperatorArray[n2];
                if (pOp instanceof ICPPASTReferenceOperator) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public String getType() {
            IASTSimpleDeclaration decl;
            IASTDeclSpecifier declSpec = null;
            IASTNode node = this.getDeclaration().getParent();
            if (node instanceof ICPPASTSimpleTypeTemplateParameter) {
                ICPPASTSimpleTypeTemplateParameter parameter = (ICPPASTSimpleTypeTemplateParameter)node;
                return parameter.getName().toString();
            }
            IASTDeclarator sourceDeclarator = (IASTDeclarator)node;
            if (sourceDeclarator.getParent() instanceof IASTSimpleDeclaration) {
                decl = (IASTSimpleDeclaration)sourceDeclarator.getParent();
                declSpec = decl.getDeclSpecifier();
            } else if (sourceDeclarator.getParent() instanceof IASTParameterDeclaration) {
                decl = (IASTParameterDeclaration)sourceDeclarator.getParent();
                declSpec = decl.getDeclSpecifier();
            }
            ASTWriter writer = new ASTWriter();
            return writer.write((IASTNode)declSpec);
        }

        public boolean isDeclarationInScope() {
            int declOffset = this.declaration.getFileLocation().getNodeOffset();
            return declOffset >= NodeContainer.this.getStartOffset() && declOffset <= NodeContainer.this.getEndOffset();
        }

        public String toString() {
            return String.valueOf(Messages.NodeContainer_Name) + this.name + ' ' + this.isDeclarationInScope();
        }

        public boolean isReference() {
            return this.isReference;
        }

        public void setReference(boolean isReference) {
            this.isReference = isReference;
        }

        public boolean isReturnValue() {
            return this.isReturnValue;
        }

        public void setReturnValue(boolean isReturnValue) {
            this.isReturnValue = isReturnValue;
        }

        public boolean isUserSetIsReference() {
            return this.userSetIsReference;
        }

        public void setUserSetIsReference(boolean userSetIsReference) {
            this.userSetIsReference = userSetIsReference;
        }

        public boolean isUserSetIsReturnValue() {
            return this.userSetIsReturnValue;
        }

        public void setUserSetIsReturnValue(boolean userSetIsReturnValue) {
            this.userSetIsReturnValue = userSetIsReturnValue;
        }

        public String getUserSetName() {
            return this.userSetName;
        }

        public void setUserSetName(String userSetName) {
            this.userSetName = userSetName;
        }
    }
}

