/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.cdt.internal.ui.text.IColorManagerExtension;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class CColorManager
implements IColorManager,
IColorManagerExtension {
    protected Map<String, RGB> fKeyTable = new HashMap<String, RGB>(10);
    protected Map<Display, Map<RGB, Color>> fDisplayTable = new HashMap<Display, Map<RGB, Color>>(2);
    private boolean fAutoDisposeOnDisplayDispose;

    public CColorManager() {
        this(true);
    }

    public CColorManager(boolean autoDisposeOnDisplayDispose) {
        this.fAutoDisposeOnDisplayDispose = autoDisposeOnDisplayDispose;
    }

    protected void dispose(Display display) {
        Map<RGB, Color> colorTable = this.fDisplayTable.get(display);
        if (colorTable != null) {
            Iterator<Color> e = colorTable.values().iterator();
            while (e.hasNext()) {
                e.next().dispose();
            }
        }
    }

    public Color getColor(RGB rgb) {
        Color color;
        if (rgb == null) {
            return null;
        }
        final Display display = Display.getCurrent();
        Map<RGB, Color> colorTable = this.fDisplayTable.get(display);
        if (colorTable == null) {
            colorTable = new HashMap<RGB, Color>(10);
            this.fDisplayTable.put(display, colorTable);
            if (this.fAutoDisposeOnDisplayDispose) {
                display.disposeExec(new Runnable(){

                    public void run() {
                        CColorManager.this.dispose(display);
                    }
                });
            }
        }
        if ((color = colorTable.get(rgb)) == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            colorTable.put(rgb, color);
        }
        return color;
    }

    public void dispose() {
        if (!this.fAutoDisposeOnDisplayDispose) {
            this.dispose(Display.getCurrent());
        }
    }

    public Color getColor(String key) {
        if (key == null) {
            return null;
        }
        RGB rgb = this.fKeyTable.get(key);
        return this.getColor(rgb);
    }

    public void bindColor(String key, RGB rgb) {
        RGB value = this.fKeyTable.get(key);
        if (value != null) {
            throw new UnsupportedOperationException();
        }
        this.fKeyTable.put(key, rgb);
    }

    public void unbindColor(String key) {
        this.fKeyTable.remove(key);
    }
}

