/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.actions;

import java.util.Iterator;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.ui.actions.BuildConfigAction;
import org.eclipse.cdt.ui.actions.ChangeBuildConfigActionBase;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.actions.BuildAction;

public class BuildActiveConfigMenuAction
extends ChangeBuildConfigActionBase
implements IWorkbenchWindowPulldownDelegate2,
ICProjectDescriptionListener {
    private BuildAction buildaction;
    private IAction actionMenuCache;

    public Menu getMenu(Menu parent) {
        Menu menu = new Menu(parent);
        this.addMenuListener(menu);
        return menu;
    }

    public Menu getMenu(Control parent) {
        Menu menu = new Menu(parent);
        this.addMenuListener(menu);
        return menu;
    }

    public void dispose() {
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        mngr.removeCProjectDescriptionListener((ICProjectDescriptionListener)this);
    }

    public void init(IWorkbenchWindow window) {
        this.buildaction = new BuildAction((IShellProvider)window, 10);
        ICProjectDescriptionManager mngr = CoreModel.getDefault().getProjectDescriptionManager();
        mngr.addCProjectDescriptionListener((ICProjectDescriptionListener)this, 16);
    }

    public void run(IAction action) {
        this.buildaction.selectionChanged((IStructuredSelection)new StructuredSelection(this.fProjects.toArray()));
        this.buildaction.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.actionMenuCache == null) {
            this.actionMenuCache = action;
        }
        this.onSelectionChanged(action, selection);
        this.updateBuildConfigMenuToolTip(action);
    }

    private void addMenuListener(Menu menu) {
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                BuildActiveConfigMenuAction.this.fillMenu((Menu)e.widget);
            }
        });
    }

    protected IAction makeAction(String sName, StringBuffer builder, int accel) {
        return new BuildConfigAction(this.fProjects, sName, builder.toString(), accel + 1, this.buildaction);
    }

    public void updateBuildConfigMenuToolTip(IAction action) {
        ICProjectDescription prjd;
        Iterator projIter;
        IProject prj;
        String toolTipText = ActionMessages.getString("BuildActiveConfigMenuAction_defaultTooltip");
        if (this.fProjects.size() == 1 && (prj = (IProject)(projIter = this.fProjects.iterator()).next()) != null && (prjd = CoreModel.getDefault().getProjectDescription(prj, false)) != null) {
            toolTipText = ActionMessages.getFormattedString("BuildActiveConfigMenuAction_buildConfigTooltip", new Object[]{prjd.getActiveConfiguration().getName(), prj.getName()});
        }
        action.setToolTipText(toolTipText);
    }

    public void handleEvent(CProjectDescriptionEvent event) {
        if (this.actionMenuCache != null) {
            this.updateBuildConfigMenuToolTip(this.actionMenuCache);
        }
    }
}

