/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.io.File;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractGNUBinaryParserPage
extends AbstractCOptionPage {
    public static final String PREF_ADDR2LINE_PATH = "org.eclipse.cdt.ui.addr2line";
    public static final String PREF_CPPFILT_PATH = "org.eclipse.cdt.ui.cppfilt";
    protected Text fAddr2LineCommandText;
    protected Text fCPPFiltCommandText;
    private String parserID = null;

    public void performApply(IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String addr2line = this.fAddr2LineCommandText.getText().trim();
        String cppfilt = this.fCPPFiltCommandText.getText().trim();
        monitor.beginTask(CUIMessages.getString("BinaryParserPage.task.savingAttributes"), 1);
        IProject proj = this.getContainer().getProject();
        if (proj != null) {
            ICExtensionReference[] cext = CCorePlugin.getDefault().getBinaryParserExtensions(proj);
            if (cext.length > 0) {
                this.initializeParserId();
                int i = 0;
                while (i < cext.length) {
                    if (cext[i].getID().equals(this.parserID)) {
                        String orig = cext[i].getExtensionData("addr2line");
                        if (orig == null || !orig.equals(addr2line)) {
                            cext[i].setExtensionData("addr2line", addr2line);
                        }
                        if ((orig = cext[i].getExtensionData("c++filt")) == null || !orig.equals(cppfilt)) {
                            cext[i].setExtensionData("c++filt", cppfilt);
                        }
                    }
                    ++i;
                }
            }
        } else {
            Preferences store = this.getContainer().getPreferences();
            if (store != null) {
                store.setValue(PREF_ADDR2LINE_PATH, addr2line);
                store.setValue(PREF_CPPFILT_PATH, cppfilt);
            }
        }
    }

    private void initializeParserId() {
        if (this.parserID == null) {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.ui", "BinaryParserPage");
            IConfigurationElement[] infos = point.getConfigurationElements();
            int i = 0;
            while (i < infos.length) {
                String id = infos[i].getAttribute("parserID");
                String clazz = infos[i].getAttribute("class");
                String ego = this.getRealBinaryParserPage().getClass().getName();
                if (clazz != null && clazz.equals(ego)) {
                    this.parserID = id;
                    return;
                }
                ++i;
            }
            this.parserID = "";
        }
    }

    protected abstract AbstractGNUBinaryParserPage getRealBinaryParserPage();

    public void performDefaults() {
        String addr2line = null;
        String cppfilt = null;
        IProject proj = this.getContainer().getProject();
        Preferences store = this.getContainer().getPreferences();
        if (store != null) {
            if (proj != null) {
                addr2line = store.getString(PREF_ADDR2LINE_PATH);
                cppfilt = store.getString(PREF_CPPFILT_PATH);
            } else {
                addr2line = store.getDefaultString(PREF_ADDR2LINE_PATH);
                cppfilt = store.getDefaultString(PREF_CPPFILT_PATH);
            }
            this.fAddr2LineCommandText.setText(addr2line == null || addr2line.length() == 0 ? "addr2line" : addr2line);
            this.fCPPFiltCommandText.setText(cppfilt == null || cppfilt.length() == 0 ? "c++filt" : cppfilt);
        }
    }

    public void createControl(Composite parent) {
        Group comp = new Group(parent, 16);
        comp.setText(CUIMessages.getString("BinaryParserBlock.binaryParserOptions"));
        comp.setLayout((Layout)new GridLayout(2, true));
        comp.setLayoutData((Object)new GridData(768));
        ((GridLayout)comp.getLayout()).makeColumnsEqualWidth = false;
        Label label = ControlFactory.createLabel((Composite)comp, CUIMessages.getString("BinaryParserPage.label.addr2lineCommand"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fAddr2LineCommandText = ControlFactory.createTextField((Composite)comp, 2052);
        this.fAddr2LineCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
            }
        });
        Button button = ControlFactory.createPushButton((Composite)comp, CUIMessages.getString("BinaryParserPage.label.browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleAddr2LineButtonSelected();
            }

            private void handleAddr2LineButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(AbstractGNUBinaryParserPage.this.getShell(), 0);
                dialog.setText(CUIMessages.getString("BinaryParserPage.label.addr2lineCommand"));
                String command = AbstractGNUBinaryParserPage.this.fAddr2LineCommandText.getText().trim();
                int lastSeparatorIndex = command.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(command.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                AbstractGNUBinaryParserPage.this.fAddr2LineCommandText.setText(res);
            }
        });
        label = ControlFactory.createLabel((Composite)comp, CUIMessages.getString("BinaryParserPage.label.cppfiltCommand"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.fCPPFiltCommandText = ControlFactory.createTextField((Composite)comp, 2052);
        gd = new GridData(768);
        this.fCPPFiltCommandText.setLayoutData((Object)gd);
        this.fCPPFiltCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
            }
        });
        button = ControlFactory.createPushButton((Composite)comp, CUIMessages.getString("BinaryParserPage.label.browse1"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                this.handleCPPFiltButtonSelected();
            }

            private void handleCPPFiltButtonSelected() {
                String res;
                FileDialog dialog = new FileDialog(AbstractGNUBinaryParserPage.this.getShell(), 0);
                dialog.setText(CUIMessages.getString("BinaryParserPage.label.cppfiltCommand"));
                String command = AbstractGNUBinaryParserPage.this.fCPPFiltCommandText.getText().trim();
                int lastSeparatorIndex = command.lastIndexOf(File.separator);
                if (lastSeparatorIndex != -1) {
                    dialog.setFilterPath(command.substring(0, lastSeparatorIndex));
                }
                if ((res = dialog.open()) == null) {
                    return;
                }
                AbstractGNUBinaryParserPage.this.fCPPFiltCommandText.setText(res);
            }
        });
        this.setControl((Control)comp);
        this.initialziedValues();
    }

    private void initialziedValues() {
        String cppfilt;
        String addr2line;
        block7: {
            addr2line = null;
            cppfilt = null;
            IProject proj = this.getContainer().getProject();
            if (proj != null) {
                try {
                    ICExtensionReference[] cext = CCorePlugin.getDefault().getBinaryParserExtensions(proj);
                    if (cext.length <= 0) break block7;
                    this.initializeParserId();
                    int i = 0;
                    while (i < cext.length) {
                        if (cext[i].getID().equals(this.parserID)) {
                            addr2line = cext[0].getExtensionData("addr2line");
                            cppfilt = cext[0].getExtensionData("c++filt");
                            break;
                        }
                        ++i;
                    }
                }
                catch (CoreException coreException) {}
            } else {
                Preferences store = this.getContainer().getPreferences();
                if (store != null) {
                    addr2line = store.getString(PREF_ADDR2LINE_PATH);
                    cppfilt = store.getString(PREF_CPPFILT_PATH);
                }
            }
        }
        this.fAddr2LineCommandText.setText(addr2line == null || addr2line.length() == 0 ? "addr2line" : addr2line);
        this.fCPPFiltCommandText.setText(cppfilt == null || cppfilt.length() == 0 ? "c++filt" : cppfilt);
    }
}

