/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers;

import org.eclipse.cdt.codan.core.cxx.CxxAstUtils;
import org.eclipse.cdt.codan.core.cxx.model.AbstractIndexAstChecker;
import org.eclipse.cdt.codan.core.model.IProblemWorkingCopy;
import org.eclipse.cdt.codan.internal.checkers.CheckersMessages;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTCompoundStatementExpression;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTBinaryExpression;
import org.eclipse.core.resources.IResource;

public class StatementHasNoEffectChecker
extends AbstractIndexAstChecker {
    public static final String ER_ID = "org.eclipse.cdt.codan.internal.checkers.StatementHasNoEffectProblem";
    public static final String PARAM_MACRO_ID = "macro";
    public static final String PARAM_EXCEPT_ARG_LIST = "exceptions";

    public void processAst(IASTTranslationUnit ast) {
        ast.accept((ASTVisitor)new CheckStmpVisitor());
    }

    public void initPreferences(IProblemWorkingCopy problem) {
        super.initPreferences(problem);
        this.addPreference(problem, PARAM_MACRO_ID, CheckersMessages.StatementHasNoEffectChecker_ParameterMacro, Boolean.TRUE);
        this.addListPreference(problem, PARAM_EXCEPT_ARG_LIST, CheckersMessages.GenericParameter_ParameterExceptions, CheckersMessages.GenericParameter_ParameterExceptionsItem);
    }

    public boolean isFilteredArg(String arg) {
        Object[] arr = (Object[])this.getPreference(this.getProblemById(ER_ID, (IResource)this.getFile()), PARAM_EXCEPT_ARG_LIST);
        int i = 0;
        while (i < arr.length) {
            String str = (String)arr[i];
            if (arg.equals(str)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean shouldReportInMacro() {
        return (Boolean)this.getPreference(this.getProblemById(ER_ID, (IResource)this.getFile()), PARAM_MACRO_ID);
    }

    public boolean isPossibleAssignment(IASTBinaryExpression expr) {
        switch (expr.getOperator()) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return true;
            }
        }
        if (expr instanceof CPPASTBinaryExpression) {
            CPPASTBinaryExpression cppBin = (CPPASTBinaryExpression)expr;
            ICPPFunction overload = cppBin.getOverload();
            if (overload != null) {
                return true;
            }
            IType expressionType = cppBin.getOperand1().getExpressionType();
            if (!(expressionType instanceof IBasicType)) {
                return true;
            }
        }
        return false;
    }

    class CheckStmpVisitor
    extends ASTVisitor {
        CheckStmpVisitor() {
            this.shouldVisitStatements = true;
        }

        public int visit(IASTStatement stmt) {
            if (stmt instanceof IASTExpressionStatement) {
                IASTExpression expression = ((IASTExpressionStatement)stmt).getExpression();
                if (this.hasNoEffect(expression)) {
                    boolean inMacro = CxxAstUtils.getInstance().isInMacro((IASTNode)expression);
                    boolean shouldReportInMacro = StatementHasNoEffectChecker.this.shouldReportInMacro();
                    if (inMacro && !shouldReportInMacro) {
                        return 1;
                    }
                    String arg = expression.getRawSignature();
                    if (!StatementHasNoEffectChecker.this.isFilteredArg(arg)) {
                        StatementHasNoEffectChecker.this.reportProblem(StatementHasNoEffectChecker.ER_ID, (IASTNode)stmt, new Object[]{arg});
                    }
                }
                return 1;
            }
            return 3;
        }

        private boolean hasNoEffect(IASTExpression e) {
            if (e instanceof IASTBinaryExpression) {
                IASTBinaryExpression binExpr = (IASTBinaryExpression)e;
                if (StatementHasNoEffectChecker.this.isPossibleAssignment(binExpr)) {
                    return false;
                }
                switch (binExpr.getOperator()) {
                    case 15: 
                    case 16: {
                        return this.hasNoEffect(binExpr.getOperand1()) && this.hasNoEffect(binExpr.getOperand2());
                    }
                }
                return true;
            }
            if (e instanceof IASTUnaryExpression) {
                IASTUnaryExpression unaryExpr = (IASTUnaryExpression)e;
                int operator = unaryExpr.getOperator();
                switch (operator) {
                    case 0: 
                    case 1: 
                    case 9: 
                    case 10: 
                    case 12: {
                        return false;
                    }
                    case 11: {
                        return this.hasNoEffect(unaryExpr.getOperand());
                    }
                }
                return true;
            }
            if (e instanceof IASTIdExpression) {
                IASTNode parent3;
                IASTNode parent2;
                IASTNode parent = e.getParent();
                return !(parent instanceof IASTExpressionStatement) || !((parent2 = parent.getParent()) instanceof IASTCompoundStatement) || !((parent3 = parent2.getParent()) instanceof IGNUASTCompoundStatementExpression);
            }
            return false;
        }
    }
}

