/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.cxx;

import org.eclipse.cdt.codan.core.cxx.Activator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;

public final class CxxAstUtils {
    private static CxxAstUtils instance;

    private CxxAstUtils() {
    }

    public static synchronized CxxAstUtils getInstance() {
        if (instance == null) {
            instance = new CxxAstUtils();
        }
        return instance;
    }

    public IType unwindTypedef(IType type) {
        if (!(type instanceof IBinding)) {
            return type;
        }
        IBinding typeName = (IBinding)type;
        try {
            while (typeName instanceof ITypedef) {
                IType t = ((ITypedef)typeName).getType();
                if (t instanceof IBinding) {
                    typeName = (IBinding)t;
                    continue;
                }
                return t;
            }
        }
        catch (Exception e) {
            Activator.log(e);
        }
        return (IType)typeName;
    }

    public boolean isInMacro(IASTNode node) {
        IASTFileLocation fileLocation;
        IASTNodeSelector nodeSelector = node.getTranslationUnit().getNodeSelector(node.getTranslationUnit().getFilePath());
        IASTPreprocessorMacroExpansion macro = nodeSelector.findEnclosingMacroExpansion((fileLocation = node.getFileLocation()).getNodeOffset(), fileLocation.getNodeLength());
        return macro != null;
    }
}

