/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.model;

import org.eclipse.cdt.codan.core.CodanRuntime;
import org.eclipse.cdt.codan.core.model.IChecker;
import org.eclipse.cdt.codan.core.model.IProblem;
import org.eclipse.cdt.codan.core.model.IProblemLocation;
import org.eclipse.cdt.codan.core.model.IProblemReporter;
import org.eclipse.cdt.codan.core.model.IRunnableInEditorChecker;
import org.eclipse.cdt.codan.internal.core.CheckersRegistry;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public abstract class AbstractChecker
implements IChecker {
    protected String name;

    public boolean enabledInContext(IResource res) {
        return true;
    }

    public void reportProblem(String id, IFile file, int lineNumber, Object ... args) {
        this.getProblemReporter().reportProblem(id, this.createProblemLocation(file, lineNumber), args);
    }

    public IProblem getProblemById(String id, IResource file) {
        IProblem problem = CheckersRegistry.getInstance().getResourceProfile(file).findProblem(id);
        if (problem == null) {
            throw new IllegalArgumentException("Id is not registered");
        }
        return problem;
    }

    public void reportProblem(String id, IFile file, int lineNumber) {
        this.getProblemReporter().reportProblem(id, this.createProblemLocation(file, lineNumber), new Object[0]);
    }

    protected IProblemReporter getProblemReporter() {
        return CodanRuntime.getInstance().getProblemReporter();
    }

    protected CodanRuntime getRuntime() {
        return CodanRuntime.getInstance();
    }

    protected IProblemLocation createProblemLocation(IFile file, int line) {
        return this.getRuntime().getProblemLocationFactory().createProblemLocation(file, line);
    }

    protected IProblemLocation createProblemLocation(IFile file, int startChar, int endChar) {
        return this.getRuntime().getProblemLocationFactory().createProblemLocation(file, startChar, endChar);
    }

    public boolean runInEditor() {
        return this instanceof IRunnableInEditorChecker;
    }

    public void reportProblem(String problemId, IProblemLocation loc, Object ... args) {
        this.getProblemReporter().reportProblem(problemId, loc, args);
    }
}

