/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.core;

import java.util.Map;
import org.eclipse.cdt.codan.core.CodanCorePlugin;
import org.eclipse.cdt.codan.core.CodanRuntime;
import org.eclipse.cdt.codan.core.Messages;
import org.eclipse.cdt.codan.core.model.IChecker;
import org.eclipse.cdt.codan.core.model.ICodanBuilder;
import org.eclipse.cdt.codan.core.model.IProblemReporter;
import org.eclipse.cdt.codan.core.model.IProblemReporterPersistent;
import org.eclipse.cdt.codan.core.model.IRunnableInEditorChecker;
import org.eclipse.cdt.codan.internal.core.CheckersRegistry;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class CodanBuilder
extends IncrementalProjectBuilder
implements ICodanBuilder {
    public static final String BUILDER_ID = "org.eclipse.cdt.codan.core.codanBuilder";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    public void processResource(IResource resource, IProgressMonitor monitor) {
        this.processResource(resource, monitor, null, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processResource(IResource resource, IProgressMonitor monitor, Object model, boolean inEditor) {
        CheckersRegistry chegistry = CheckersRegistry.getInstance();
        int checkers = chegistry.getCheckersSize();
        int memsize = 0;
        if (resource instanceof IContainer) {
            try {
                IResource[] members = ((IContainer)resource).members();
                memsize = members.length;
            }
            catch (CoreException e) {
                CodanCorePlugin.log(e);
            }
        }
        int tick = 1000;
        monitor.beginTask(String.valueOf(Messages.CodanBuilder_Code_Analysis_On) + resource, checkers + memsize * tick);
        try {
            IProblemReporter problemReporter = CodanRuntime.getInstance().getProblemReporter();
            for (IChecker checker : chegistry) {
                try {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    if (checker.enabledInContext(resource)) {
                        if (problemReporter instanceof IProblemReporterPersistent) {
                            ((IProblemReporterPersistent)problemReporter).deleteProblems(resource, checker);
                        }
                        if (chegistry.isCheckerEnabled(checker, resource)) {
                            if (inEditor) {
                                if (checker.runInEditor() && checker instanceof IRunnableInEditorChecker) {
                                    ((IRunnableInEditorChecker)((Object)checker)).processModel(model);
                                }
                            } else {
                                checker.processResource(resource);
                            }
                        }
                    }
                    monitor.worked(1);
                }
                catch (Throwable e) {
                    CodanCorePlugin.log(e);
                }
            }
            if (!(resource instanceof IContainer)) return;
            try {
                IResource[] members = ((IContainer)resource).members();
                int i = 0;
                while (i < members.length) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    IResource member = members[i];
                    this.processResource(member, (IProgressMonitor)new SubProgressMonitor(monitor, tick));
                    ++i;
                }
                return;
            }
            catch (CoreException e) {
                CodanCorePlugin.log(e);
                return;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        this.processResource((IResource)this.getProject(), monitor);
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new CodanDeltaVisitor(monitor));
    }

    public void runInEditor(Object model, IResource resource, IProgressMonitor monitor) {
        if (model == null) {
            return;
        }
        this.processResource(resource, monitor, model, true);
    }

    private class CodanDeltaVisitor
    implements IResourceDeltaVisitor {
        private IProgressMonitor monitor;

        public CodanDeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    CodanBuilder.this.processResource(resource, this.monitor);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    CodanBuilder.this.processResource(resource, this.monitor);
                }
            }
            return true;
        }
    }
}

