/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.ui;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.util.EditorUtility;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

public class CodanEditorUtility {
    public static void openFileURL(String fileUrl, IResource markerResource) throws PartInitException, BadLocationException {
        String file = CodanEditorUtility.getFileFromURL(fileUrl);
        IEditorPart part = CodanEditorUtility.openInEditor(file, markerResource);
        int line = CodanEditorUtility.getLineFromURL(fileUrl);
        CodanEditorUtility.revealLine(part, line);
    }

    public static int getLineFromURL(String fileUrl) {
        String sline = fileUrl.replaceAll(".*#(\\d+)$", "$1");
        int line = -1;
        try {
            line = Integer.parseInt(sline);
        }
        catch (NumberFormatException numberFormatException) {}
        return line;
    }

    public static String getFileFromURL(String link) {
        String file = link.replaceFirst("^file:", "");
        file = file.replaceAll("#\\d+$", "");
        return file;
    }

    public static void revealLine(IEditorPart part, int line) throws BadLocationException {
        if (line > 0 && part instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)part;
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)part.getEditorInput());
            textEditor.selectAndReveal(document.getLineOffset(line - 1), 0);
        }
    }

    public static IEditorPart openInEditor(String file, IResource markerResource) throws PartInitException {
        Path pfile = new Path(file);
        ICElement element = null;
        if (markerResource != null) {
            CoreModel.getDefault().create(markerResource);
        }
        IEditorPart part = EditorUtility.openInEditor((IPath)pfile, element);
        return part;
    }

    public static IEditorPart openInEditor(IMarker marker) throws PartInitException {
        String href = CodanEditorUtility.getLocationHRef(marker);
        String file = CodanEditorUtility.getFileFromURL(href);
        return CodanEditorUtility.openInEditor(file, marker.getResource());
    }

    public static String getLocationHRef(IMarker marker) {
        String loc = marker.getResource().getLocationURI().toString();
        String loc2 = marker.getAttribute("location", "");
        int line = marker.getAttribute("lineNumber", 0);
        if (loc2.length() > 0) {
            loc = "file:" + loc2.replaceAll("[^:]*: ", "");
        }
        String href = String.valueOf(loc) + "#" + line;
        return href;
    }
}

