/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.cdt.codan.internal.ui.CodanUIActivator;
import org.eclipse.cdt.codan.ui.AbstractCodanProblemDetailsProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemDetailsExtensions {
    public static final String ALL = "*";
    private static final String EXTENSION_POINT_NAME = "codanProblemDetails";
    private static boolean extensionsLoaded;
    private static HashMap<String, Collection<?>> map;

    static {
        map = new HashMap();
    }

    private static synchronized void readExtensions() {
        if (extensionsLoaded) {
            return;
        }
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.codan.ui", EXTENSION_POINT_NAME);
        if (ep == null) {
            return;
        }
        try {
            IConfigurationElement[] elements = ep.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement configurationElement = elements[i];
                ProblemDetailsExtensions.processDetails(configurationElement);
                ++i;
            }
        }
        finally {
            extensionsLoaded = true;
        }
    }

    private static void processDetails(IConfigurationElement configurationElement) {
        if (configurationElement.getName().equals("problemDetails")) {
            String id = configurationElement.getAttribute("problemId");
            if (id == null) {
                id = ALL;
            }
            ProblemDetailsExtensions.addExtension(id, configurationElement);
        }
    }

    public static AbstractCodanProblemDetailsProvider resolveClass(IConfigurationElement configurationElement) {
        AbstractCodanProblemDetailsProvider res;
        try {
            res = (AbstractCodanProblemDetailsProvider)configurationElement.createExecutableExtension("class");
        }
        catch (CoreException e) {
            CodanUIActivator.log(e);
            return null;
        }
        return res;
    }

    private static void addExtension(String id, IConfigurationElement configurationElement) {
        Collection collection = ProblemDetailsExtensions.getCollection(id);
        collection.add(configurationElement);
    }

    public static void removeExtension(String id, Object el) {
        Collection collection = ProblemDetailsExtensions.getCollection(id);
        collection.remove(el);
    }

    private static Collection getCollection(String id) {
        Collection<?> collection = map.get(id);
        if (collection == null) {
            collection = new ArrayList();
            map.put(id, collection);
        }
        return collection;
    }

    public static Collection<AbstractCodanProblemDetailsProvider> getProviders(String id) {
        ProblemDetailsExtensions.readExtensions();
        ArrayList<AbstractCodanProblemDetailsProvider> providers = new ArrayList<AbstractCodanProblemDetailsProvider>();
        Collection collection1 = ProblemDetailsExtensions.getCollection(id);
        Collection collection2 = ProblemDetailsExtensions.getCollection(ALL);
        providers.addAll(ProblemDetailsExtensions.resolveProviders(collection1));
        providers.addAll(ProblemDetailsExtensions.resolveProviders(collection2));
        return providers;
    }

    public static Collection<AbstractCodanProblemDetailsProvider> resolveProviders(Collection collection) {
        ArrayList res = new ArrayList(collection);
        for (Object object : res) {
            if (!(object instanceof IConfigurationElement)) continue;
            collection.remove(object);
            AbstractCodanProblemDetailsProvider provider = ProblemDetailsExtensions.resolveClass((IConfigurationElement)object);
            if (provider == null) continue;
            collection.add(provider);
        }
        return collection;
    }

    public static void addExtension(String id, AbstractCodanProblemDetailsProvider provider) {
        Collection collection = ProblemDetailsExtensions.getCollection(id);
        collection.add(provider);
    }
}

