/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.ui;

import org.eclipse.cdt.codan.internal.ui.CodanUIActivator;
import org.eclipse.cdt.codan.ui.CodanEditorUtility;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstarctCodanCMarkerResolution
implements IMarkerResolution {
    public int getOffset(IMarker marker, IDocument doc) {
        int position;
        int charStart = marker.getAttribute("charStart", -1);
        if (charStart > 0) {
            position = charStart;
        } else {
            int line = marker.getAttribute("lineNumber", -1) - 1;
            try {
                position = doc.getLineOffset(line);
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
        }
        return position;
    }

    public void run(IMarker marker) {
        IEditorPart editorPart;
        try {
            editorPart = CodanEditorUtility.openInEditor(marker);
        }
        catch (PartInitException e) {
            CodanUIActivator.log(e);
            return;
        }
        if (editorPart instanceof ITextEditor) {
            ITextEditor editor = (ITextEditor)editorPart;
            IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            this.apply(marker, doc);
        }
    }

    public abstract void apply(IMarker var1, IDocument var2);

    public boolean isApplicable(IMarker marker) {
        return true;
    }
}

