/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.lrparser.tests;

import java.util.ArrayList;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.core.runtime.CoreException;

public class ParseHelper {
    static int testsRun = 0;

    public static IASTTranslationUnit parse(String code, ILanguage lang, boolean expectNoProblems) {
        Options options = new Options().setCheckSyntaxProblems(expectNoProblems).setCheckPreprocessorProblems(expectNoProblems);
        return ParseHelper.parse(code.toCharArray(), lang, options);
    }

    public static IASTTranslationUnit parse(String code, ILanguage lang, Options options) {
        return ParseHelper.parse(code.toCharArray(), lang, options);
    }

    public static IASTTranslationUnit parse(char[] code, ILanguage lang, Options options) {
        return ParseHelper.parse(FileContent.create((String)"<testcode>", (char[])code), lang, (IScannerInfo)new ScannerInfo(), null, options);
    }

    public static IASTTranslationUnit parse(CodeReader codeReader, ILanguage language, IScannerInfo scanInfo, ICodeReaderFactory fileCreator, Options options) {
        IASTTranslationUnit tu;
        ++testsRun;
        try {
            int languageOptions = 0;
            if (options.skipTrivialInitializers) {
                languageOptions |= 0x10;
            }
            tu = language.getASTTranslationUnit(codeReader, scanInfo, fileCreator, null, languageOptions, ParserUtil.getParserLogService());
        }
        catch (CoreException e) {
            throw new AssertionFailedError(e.toString());
        }
        if (options.checkSyntaxProblems && CVisitor.getProblems((IASTTranslationUnit)tu).length != 0) {
            throw new AssertionFailedError(" CVisitor has AST Problems ");
        }
        if (options.checkPreprocessorProblems && tu.getPreprocessorProblems().length != 0) {
            throw new AssertionFailedError(String.valueOf(language.getName()) + " TranslationUnit has Preprocessor Problems ");
        }
        if (options.checkBindings) {
            NameResolver res = new NameResolver();
            tu.accept((ASTVisitor)res);
            if (res.problemBindings.size() != options.expectedProblemBindings) {
                throw new AssertionFailedError("Expected " + options.expectedProblemBindings + " problem(s), encountered " + res.problemBindings.size());
            }
            if (options.problems != null) {
                int i = 0;
                while (i < options.problems.length) {
                    String expected = options.problems[i];
                    String actual = res.problemBindings.get(i);
                    if (!expected.equals(actual)) {
                        throw new AssertionFailedError(String.format("Problem binding not equal, expected: %s, got: %s", expected, actual));
                    }
                    ++i;
                }
            }
        }
        return tu;
    }

    public static IASTTranslationUnit parse(FileContent fileContent, ILanguage language, IScannerInfo scanInfo, IncludeFileContentProvider fileContentProvider, Options options) {
        IASTTranslationUnit tu;
        ++testsRun;
        try {
            int languageOptions = 0;
            if (options.skipTrivialInitializers) {
                languageOptions |= 0x10;
            }
            tu = language.getASTTranslationUnit(fileContent, scanInfo, fileContentProvider, null, languageOptions, ParserUtil.getParserLogService());
        }
        catch (CoreException e) {
            throw new AssertionFailedError(e.toString());
        }
        if (options.checkSyntaxProblems && CVisitor.getProblems((IASTTranslationUnit)tu).length != 0) {
            throw new AssertionFailedError(" CVisitor has AST Problems ");
        }
        if (options.checkPreprocessorProblems && tu.getPreprocessorProblems().length != 0) {
            throw new AssertionFailedError(String.valueOf(language.getName()) + " TranslationUnit has Preprocessor Problems ");
        }
        if (options.checkBindings) {
            NameResolver res = new NameResolver();
            tu.accept((ASTVisitor)res);
            if (res.problemBindings.size() != options.expectedProblemBindings) {
                throw new AssertionFailedError("Expected " + options.expectedProblemBindings + " problem(s), encountered " + res.problemBindings.size());
            }
            if (options.problems != null) {
                int i = 0;
                while (i < options.problems.length) {
                    String expected = options.problems[i];
                    String actual = res.problemBindings.get(i);
                    if (!expected.equals(actual)) {
                        throw new AssertionFailedError(String.format("Problem binding not equal, expected: %s, got: %s", expected, actual));
                    }
                    ++i;
                }
            }
        }
        return tu;
    }

    public static IASTTranslationUnit commentParse(String code, ILanguage language) {
        IASTTranslationUnit tu;
        try {
            tu = language.getASTTranslationUnit(FileContent.create((String)"<testcode>", (char[])code.toCharArray()), (IScannerInfo)new ScannerInfo(), null, null, 2, ParserUtil.getParserLogService());
        }
        catch (CoreException e) {
            throw new AssertionFailedError(e.toString());
        }
        return tu;
    }

    public static IASTCompletionNode getCompletionNode(String code, ILanguage lang) {
        int offset = code.length();
        if (offset > 0 && '\n' == code.charAt(offset - 1)) {
            --offset;
        }
        return ParseHelper.getCompletionNode(code, lang, offset);
    }

    public static IASTCompletionNode getCompletionNode(String code, ILanguage language, int offset) {
        try {
            return language.getCompletionNode(FileContent.create((String)"<testcode>", (char[])code.toCharArray()), (IScannerInfo)new ScannerInfo(), null, null, ParserUtil.getParserLogService(), offset);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    protected static class NameResolver
    extends ASTVisitor {
        public List<IASTName> nameList;
        public List<String> problemBindings;
        public int numNullBindings;

        protected NameResolver() {
            this.shouldVisitNames = true;
            this.nameList = new ArrayList<IASTName>();
            this.problemBindings = new ArrayList<String>();
            this.numNullBindings = 0;
        }

        public int visit(IASTName name) {
            this.nameList.add(name);
            IBinding binding = name.resolveBinding();
            if (binding instanceof IProblemBinding) {
                this.problemBindings.add(name.toString());
            }
            if (binding == null) {
                ++this.numNullBindings;
            }
            return 3;
        }

        public IASTName getName(int idx) {
            if (idx < 0 || idx >= this.nameList.size()) {
                return null;
            }
            return this.nameList.get(idx);
        }

        public int size() {
            return this.nameList.size();
        }
    }

    public static class Options {
        boolean checkSyntaxProblems = true;
        boolean checkPreprocessorProblems = true;
        boolean checkBindings = false;
        int expectedProblemBindings;
        String[] problems;
        boolean skipTrivialInitializers;

        public Options setCheckSyntaxProblems(boolean checkSyntaxProblems) {
            this.checkSyntaxProblems = checkSyntaxProblems;
            return this;
        }

        public Options setCheckBindings(boolean checkBindings) {
            this.checkBindings = checkBindings;
            return this;
        }

        public Options setCheckPreprocessorProblems(boolean checkPreprocessorProblems) {
            this.checkPreprocessorProblems = checkPreprocessorProblems;
            return this;
        }

        public Options setExpectedProblemBindings(int expectedProblemBindings) {
            this.expectedProblemBindings = expectedProblemBindings;
            return this;
        }

        public Options setProblems(String[] problems) {
            this.problems = problems;
            this.setExpectedProblemBindings(problems.length);
            this.setCheckBindings(true);
            return this;
        }

        public Options setSkipTrivialInitializers(boolean skipTrivialInitializers) {
            this.skipTrivialInitializers = skipTrivialInitializers;
            return this;
        }
    }
}

