/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.xlc.tests;

import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.parser.xlc.tests.XlcTestBase;

public class VectorExtensionsTest
extends XlcTestBase {
    public VectorExtensionsTest() {
    }

    public VectorExtensionsTest(String name) {
        super(name);
    }

    public void testVector1() {
        String code = "int test() {  \n   vector unsigned int a = {1,2,3,4};  \n   vector unsigned int b = {2,4,6,8};  \n   vector unsigned int c = a + b;      \n   int e = b > a;                      \n   int f = a[2];                       \n   vector unsigned int d = ++a;        \n}\n";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
        this.parse(code, (ILanguage)this.getCPPLanguage(), true);
    }

    public void testVectorDeclarations() {
        String code = "vector unsigned char a;\t  \nvector signed char b;  \nvector bool char c;\t  \nvector unsigned short d; \t  \nvector unsigned short int e;  \nvector signed short f;  \nvector signed short int g;  \nvector bool short h;\t  \nvector bool short int i;  \nvector unsigned int j;  \nvector unsigned long k;  \nvector unsigned long int l;  \nvector signed int m;  \nvector signed long n;  \nvector signed long int o;  \nvector bool int p;  \nvector bool long q;  \nvector bool long int r;  \nvector float s;  \nvector pixel t;  \n__vector __pixel u;  \n";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
        this.parse(code, (ILanguage)this.getCPPLanguage(), true);
    }

    public void testReservedWords() {
        String code = "int pixel; int bool;  ";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
        this.parse(code, (ILanguage)this.getCPPLanguage(), true);
    }

    public void testVectorLiterals() {
        String code = "int test() {    (vector unsigned int)(10);     (vector unsigned int)(14, 82, 73, 700);     (vector pixel)(14, 82, 73, 700);     (vector bool int)(10); }";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
        this.parse(code, (ILanguage)this.getCPPLanguage(), true);
    }

    public void testVectorInitializers() {
        String code = "int test() {    vector unsigned int v3 = {1,2,3,4}; }";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
        this.parse(code, (ILanguage)this.getCPPLanguage(), true);
    }

    public void testVectorTypedefs() {
        String code = "int test() {     typedef vector pixel vint16;      vint16 v1;}";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
        this.parse(code, (ILanguage)this.getCPPLanguage(), true);
    }

    public void testVectorCompoundLiterals() {
        String code = "int test() {    (vector unsigned int){10};     (vector unsigned int){14, 82, 73, 700};     (vector pixel){14, 82, 73, 700};     (vector bool int){10}; }";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
        this.parse(code, (ILanguage)this.getCPPLanguage(), true);
    }

    public void testVectorAlignof() {
        String code = "int test() {   vector unsigned int v1 = (vector unsigned int)(10);  \n   vector unsigned int *pv1 = &v1;  \n   __alignof__(v1); \n   __alignof__(&v1);  \n   __alignof__(*pv1);  \n   __alignof__(pv1);  \n   __alignof__(vector signed char);  \n}";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
        this.parse(code, (ILanguage)this.getCPPLanguage(), true);
    }

    public void testVectorTypeof() {
        String code = "int test() {   vector unsigned int v1 = (vector unsigned int)(10);  \n   vector unsigned int *pv1 = &v1;  \n   __typeof__(v1); \n   __typeof__(&v1);  \n   __typeof__(*pv1);  \n   __typeof__(pv1);  \n   __typeof__(vector signed char);  \n}";
        this.parse(code, (ILanguage)this.getCLanguage(), true);
        this.parse(code, (ILanguage)this.getCPPLanguage(), true);
    }

    public void _testOverloads() {
        String code = "void foo(int); \nvoid foo(vector unsigned int); \nvoid foo(vector pixel) \nint test() { \n    int x; \n    vector unsigned int y; \n    vector pixel z; \n    foo(x); \n    foo(y); \n    foo(z); \n} \n";
        IASTTranslationUnit tu = this.parse(code, (ILanguage)this.getCPPLanguage(), true);
        IASTDeclaration[] decls = tu.getDeclarations();
        IASTName foo1 = ((IASTSimpleDeclaration)decls[0]).getDeclarators()[0].getName();
        IASTName foo2 = ((IASTSimpleDeclaration)decls[1]).getDeclarators()[0].getName();
        IASTName foo3 = ((IASTSimpleDeclaration)decls[2]).getDeclarators()[0].getName();
        IASTFunctionDefinition func = (IASTFunctionDefinition)decls[4];
        IASTStatement[] stats = ((IASTCompoundStatement)func.getBody()).getStatements();
        IASTName fooCall1 = ((IASTIdExpression)((IASTFunctionCallExpression)((IASTExpressionStatement)stats[3]).getExpression()).getFunctionNameExpression()).getName();
        IASTName fooCall2 = ((IASTIdExpression)((IASTFunctionCallExpression)((IASTExpressionStatement)stats[4]).getExpression()).getFunctionNameExpression()).getName();
        IASTName fooCall3 = ((IASTIdExpression)((IASTFunctionCallExpression)((IASTExpressionStatement)stats[5]).getExpression()).getFunctionNameExpression()).getName();
        VectorExtensionsTest.assertSame((Object)foo1.resolveBinding(), (Object)fooCall1.resolveBinding());
        VectorExtensionsTest.assertSame((Object)foo2.resolveBinding(), (Object)fooCall2.resolveBinding());
        VectorExtensionsTest.assertSame((Object)foo3.resolveBinding(), (Object)fooCall3.resolveBinding());
    }
}

