/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.cdtvariables;

import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.cdtvariables.CdtVariableManager;
import org.eclipse.cdt.internal.core.cdtvariables.ICoreVariableContextInfo;
import org.eclipse.cdt.utils.cdtvariables.ICdtVariableSupplier;
import org.eclipse.cdt.utils.cdtvariables.IVariableContextInfo;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;

public class DefaultVariableContextInfo
implements ICoreVariableContextInfo {
    private ICdtVariableSupplier[] fSuppliers;
    private int fType;
    private Object fData;

    public DefaultVariableContextInfo(int type, Object data) {
        this.fType = type;
        this.fData = data;
    }

    protected DefaultVariableContextInfo(int type, Object data, ICdtVariableSupplier[] suppliers) {
        this.fType = type;
        this.fData = data;
        this.fSuppliers = suppliers;
    }

    protected ICdtVariableSupplier[] getSuppliers(int type, Object data) {
        switch (type) {
            case 3: {
                if (!(data instanceof ICConfigurationDescription)) break;
                return new ICdtVariableSupplier[]{CdtVariableManager.fUserDefinedMacroSupplier, CdtVariableManager.fBuildSystemVariableSupplier, CdtVariableManager.fEnvironmentMacroSupplier, CdtVariableManager.fCdtMacroSupplier};
            }
            case 5: {
                if (data != null && !(data instanceof IWorkspace)) break;
                return new ICdtVariableSupplier[]{CdtVariableManager.fUserDefinedMacroSupplier, CdtVariableManager.fEnvironmentMacroSupplier, CdtVariableManager.fCdtMacroSupplier, CdtVariableManager.fEclipseVariablesMacroSupplier};
            }
            case 6: {
                if (data != null) break;
                return new ICdtVariableSupplier[]{CdtVariableManager.fCdtMacroSupplier};
            }
            case 7: {
                if (data != null) break;
                return new ICdtVariableSupplier[]{CdtVariableManager.fEnvironmentMacroSupplier};
            }
        }
        return null;
    }

    public int getContextType() {
        return this.fType;
    }

    public Object getContextData() {
        return this.fData;
    }

    public ICdtVariableSupplier[] getSuppliers() {
        if (this.fSuppliers == null) {
            this.fSuppliers = this.getSuppliers(this.fType, this.fData);
        }
        return this.fSuppliers;
    }

    public IVariableContextInfo getNext() {
        switch (this.fType) {
            case 3: {
                IWorkspace wsp;
                if (!(this.fData instanceof ICConfigurationDescription) || (wsp = ResourcesPlugin.getWorkspace()) == null) break;
                return new DefaultVariableContextInfo(5, wsp);
            }
            case 5: {
                if (!(this.fData instanceof IWorkspace)) break;
                return new DefaultVariableContextInfo(6, null);
            }
            case 6: {
                if (this.fData != null) break;
                return new DefaultVariableContextInfo(7, null);
            }
            case 7: {
                if (this.fData != null) break;
                return null;
            }
        }
        return null;
    }
}

