/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorUndefStatement;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.parser.scanner.CharArray;
import org.eclipse.cdt.internal.core.parser.scanner.MacroDefinitionParser;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMFile;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroContainer;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMMacroDefinitionName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class PDOMMacro
implements IIndexMacro,
IPDOMBinding,
IASTFileLocation {
    private static final int CONTAINER = 0;
    private static final int FILE = 4;
    private static final int PARAMETERS = 8;
    private static final int EXPANSION = 12;
    private static final int NEXT_IN_FILE = 16;
    private static final int NEXT_IN_CONTAINER = 20;
    private static final int PREV_IN_CONTAINER = 24;
    private static final int NAME_OFFSET = 28;
    private static final int NAME_LENGTH = 32;
    private static final int RECORD_SIZE = 34;
    private static final char[][] UNINITIALIZED = new char[0][];
    private static final char[] UNINITIALIZED1 = new char[0];
    private final PDOMLinkage fLinkage;
    private final long fRecord;
    private char[][] fParameterList = UNINITIALIZED;
    private char[] fExpansion = UNINITIALIZED1;
    private PDOMMacroContainer fContainer;
    private PDOMMacroDefinitionName fDefinition;

    public PDOMMacro(PDOMLinkage linkage, long record) {
        this.fLinkage = linkage;
        this.fRecord = record;
    }

    public PDOMMacro(PDOMLinkage linkage, PDOMMacroContainer container, IASTPreprocessorMacroDefinition macro, PDOMFile file) throws CoreException {
        this(linkage, container, file, macro.getName());
        IASTName name = macro.getName();
        IMacroBinding binding = (IMacroBinding)name.getBinding();
        char[][] params = binding.getParameterList();
        Database db = linkage.getDB();
        db.putRecPtr(this.fRecord + 12L, db.newString(binding.getExpansionImage()).getRecord());
        if (params != null) {
            StringBuilder buf = new StringBuilder();
            char[][] cArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                char[] param = cArray[n2];
                buf.append(param);
                buf.append(',');
                ++n2;
            }
            db.putRecPtr(this.fRecord + 8L, db.newString(buf.toString().toCharArray()).getRecord());
        }
    }

    public PDOMMacro(PDOMLinkage linkage, PDOMMacroContainer container, IASTPreprocessorUndefStatement undef, PDOMFile file) throws CoreException {
        this(linkage, container, file, undef.getMacroName());
    }

    private PDOMMacro(PDOMLinkage linkage, PDOMMacroContainer container, PDOMFile file, IASTName name) throws CoreException {
        Database db = linkage.getDB();
        this.fLinkage = linkage;
        this.fRecord = db.malloc(34);
        this.fContainer = container;
        IASTFileLocation fileloc = name.getFileLocation();
        db.putRecPtr(this.fRecord + 0L, container.getRecord());
        db.putRecPtr(this.fRecord + 4L, file.getRecord());
        db.putInt(this.fRecord + 28L, fileloc.getNodeOffset());
        db.putShort(this.fRecord + 32L, (short)fileloc.getNodeLength());
        container.addDefinition(this);
    }

    public PDOM getPDOM() {
        return this.fLinkage.getPDOM();
    }

    public long getRecord() {
        return this.fRecord;
    }

    public void delete(PDOMLinkage linkage) throws CoreException {
        IString params;
        IString expansion;
        PDOMMacro prevName = this.getPrevInContainer();
        PDOMMacro nextName = this.getNextInContainer();
        if (prevName != null) {
            prevName.setNextInContainer(nextName);
        } else {
            PDOMMacroContainer container = this.getContainer();
            container.setFirstDefinition(nextName);
            if (nextName == null && container.isOrphaned()) {
                container.delete(linkage);
            }
        }
        if (nextName != null) {
            nextName.setPrevInContainer(prevName);
        }
        if ((expansion = this.getExpansionInDB()) != null) {
            expansion.delete();
        }
        if ((params = this.getParamListInDB()) != null) {
            params.delete();
        }
    }

    public PDOMMacroContainer getContainer() throws CoreException {
        if (this.fContainer == null) {
            this.fContainer = new PDOMMacroContainer(this.fLinkage, this.fLinkage.getDB().getRecPtr(this.fRecord + 0L));
        }
        return this.fContainer;
    }

    private IString getExpansionInDB() throws CoreException {
        Database db = this.fLinkage.getDB();
        long rec = db.getRecPtr(this.fRecord + 12L);
        return rec == 0L ? null : db.getString(rec);
    }

    private IString getParamListInDB() throws CoreException {
        Database db = this.fLinkage.getDB();
        long rec = db.getRecPtr(this.fRecord + 8L);
        return rec == 0L ? null : db.getString(rec);
    }

    public PDOMMacro getNextMacro() throws CoreException {
        long rec = this.fLinkage.getDB().getRecPtr(this.fRecord + 16L);
        return rec != 0L ? new PDOMMacro(this.fLinkage, rec) : null;
    }

    public void setNextMacro(PDOMMacro macro) throws CoreException {
        this.setNextMacro(macro != null ? macro.getRecord() : 0L);
    }

    private void setNextMacro(long rec) throws CoreException {
        this.fLinkage.getDB().putRecPtr(this.fRecord + 16L, rec);
    }

    private PDOMMacro getPrevInContainer() throws CoreException {
        return this.getMacroField(24);
    }

    void setPrevInContainer(PDOMMacro macro) throws CoreException {
        this.setMacroField(24, macro);
    }

    public PDOMMacro getNextInContainer() throws CoreException {
        return this.getMacroField(20);
    }

    void setNextInContainer(PDOMMacro macro) throws CoreException {
        this.setMacroField(20, macro);
    }

    private void setMacroField(int offset, PDOMMacro macro) throws CoreException {
        long namerec = macro != null ? macro.getRecord() : 0L;
        this.fLinkage.getDB().putRecPtr(this.fRecord + (long)offset, namerec);
    }

    private PDOMMacro getMacroField(int offset) throws CoreException {
        long namerec = this.fLinkage.getDB().getRecPtr(this.fRecord + (long)offset);
        return namerec != 0L ? new PDOMMacro(this.fLinkage, namerec) : null;
    }

    public char[][] getParameterList() {
        if (this.fParameterList == UNINITIALIZED) {
            this.fParameterList = null;
            try {
                IString plist = this.getParamListInDB();
                if (plist != null) {
                    ArrayList<char[]> paramList = new ArrayList<char[]>();
                    char[] cplist = plist.getChars();
                    int end = cplist.length;
                    int from = 0;
                    int to = CharArrayUtils.indexOf(',', cplist, from, end);
                    while (to > from) {
                        paramList.add(CharArrayUtils.extract(cplist, from, to - from));
                        from = to + 1;
                        to = CharArrayUtils.indexOf(',', cplist, from, end);
                    }
                    this.fParameterList = (char[][])paramList.toArray((T[])new char[paramList.size()][]);
                }
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return this.fParameterList;
    }

    public boolean isMacroDefinition() throws CoreException {
        if (this.fExpansion == UNINITIALIZED1) {
            return this.fLinkage.getDB().getRecPtr(this.fRecord + 12L) != 0L;
        }
        return this.fExpansion != null;
    }

    public char[] getExpansionImage() {
        if (this.fExpansion == UNINITIALIZED1) {
            try {
                IString expansionInDB = this.getExpansionInDB();
                this.fExpansion = expansionInDB == null ? null : expansionInDB.getChars();
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                this.fExpansion = CharArrayUtils.EMPTY;
            }
        }
        return this.fExpansion;
    }

    public char[] getNameCharArray() {
        try {
            return this.getContainer().getNameCharArray();
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return new char[]{' '};
        }
    }

    public String getName() {
        return new String(this.getNameCharArray());
    }

    public PDOMFile getFile() throws CoreException {
        long filerec = this.fLinkage.getDB().getRecPtr(this.fRecord + 4L);
        return filerec != 0L ? new PDOMFile(this.fLinkage, filerec) : null;
    }

    public long getFileRecord() throws CoreException {
        return this.fLinkage.getDB().getRecPtr(this.fRecord + 4L);
    }

    void setFile(PDOMFile file) throws CoreException {
        this.fLinkage.getDB().putRecPtr(this.fRecord + 4L, file != null ? file.getRecord() : 0L);
    }

    public int getEndingLineNumber() {
        return 0;
    }

    public String getFileName() {
        PDOMFile file;
        block3: {
            try {
                file = this.getFile();
                if (file != null) break block3;
                return null;
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                return null;
            }
        }
        IPath location = IndexLocationFactory.getAbsolutePath(file.getLocation());
        return location != null ? location.toOSString() : null;
    }

    public int getStartingLineNumber() {
        return 0;
    }

    public IASTFileLocation asFileLocation() {
        return this;
    }

    public IASTFileLocation getFileLocation() {
        return this;
    }

    public int getNodeLength() {
        try {
            return this.fLinkage.getDB().getShort(this.fRecord + 32L);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    public int getNodeOffset() {
        try {
            return this.fLinkage.getDB().getInt(this.fRecord + 28L);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return 0;
        }
    }

    public char[] getExpansion() {
        char[] expansionImage = this.getExpansionImage();
        return MacroDefinitionParser.getExpansion(new CharArray(expansionImage), 0, expansionImage.length);
    }

    public char[][] getParameterPlaceholderList() {
        char[] lastParam;
        char[][] params = this.getParameterList();
        if (params != null && params.length > 0 && CharArrayUtils.equals(lastParam = params[params.length - 1], 0, Keywords.cpELLIPSIS.length, Keywords.cpELLIPSIS)) {
            char[][] result = new char[params.length][];
            System.arraycopy(params, 0, result, 0, params.length - 1);
            result[params.length - 1] = lastParam.length == Keywords.cpELLIPSIS.length ? Keywords.cVA_ARGS : CharArrayUtils.extract(lastParam, Keywords.cpELLIPSIS.length, lastParam.length - Keywords.cpELLIPSIS.length);
            return result;
        }
        return params;
    }

    public boolean isFunctionStyle() {
        return this.getParameterList() != null;
    }

    public boolean isDynamic() {
        return false;
    }

    public PDOMLinkage getLinkage() throws CoreException {
        return this.getFile().getLinkage();
    }

    public IIndexScope getScope() {
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(PDOMMacro.class)) {
            return this;
        }
        return null;
    }

    public IIndexFragmentName getDefinition() throws CoreException {
        if (!this.isMacroDefinition()) {
            return null;
        }
        if (this.fDefinition == null) {
            this.fDefinition = new PDOMMacroDefinitionName(this);
        }
        return this.fDefinition;
    }

    public IIndexFile getLocalToFile() throws CoreException {
        return null;
    }

    public String[] getQualifiedName() {
        return new String[]{this.getName()};
    }

    public boolean isFileLocal() throws CoreException {
        return false;
    }

    public int getBindingConstant() {
        return 4;
    }

    public IIndexFragment getFragment() {
        return this.fLinkage.getPDOM();
    }

    public boolean hasDeclaration() throws CoreException {
        return false;
    }

    public boolean hasDefinition() throws CoreException {
        return true;
    }

    public IIndexFragmentBinding getOwner() {
        return null;
    }

    public void accept(IPDOMVisitor visitor) {
    }

    public long getBindingID() {
        return this.fRecord;
    }
}

