/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.c;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCAnnotation;
import org.eclipse.cdt.internal.core.pdom.dom.c.PDOMCParameter;
import org.eclipse.core.runtime.CoreException;

class PDOMCFunction
extends PDOMBinding
implements IFunction {
    public static final int NUM_PARAMS = 28;
    public static final int FIRST_PARAM = 32;
    private static final int FUNCTION_TYPE = 36;
    private static final int ANNOTATIONS = 42;
    public static final int RECORD_SIZE = 43;

    public PDOMCFunction(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    public PDOMCFunction(PDOMLinkage linkage, PDOMNode parent, IFunction function) throws CoreException {
        super(linkage, parent, function.getNameCharArray());
        byte annotations;
        IParameter[] parameters;
        IFunctionType type;
        try {
            type = function.getType();
            parameters = function.getParameters();
            annotations = PDOMCAnnotation.encodeAnnotation(function);
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
        this.setType((PDOMLinkage)this.getLinkage(), type);
        this.setParameters(parameters);
        this.getDB().putByte(this.record + 42L, annotations);
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof IFunction) {
            byte newAnnotation;
            IParameter[] newParams;
            IFunctionType newType;
            IFunction func = (IFunction)newBinding;
            try {
                newType = func.getType();
                newParams = func.getParameters();
                newAnnotation = PDOMCAnnotation.encodeAnnotation(func);
            }
            catch (DOMException e) {
                throw new CoreException(Util.createStatus(e));
            }
            this.setType(linkage, newType);
            PDOMCParameter oldParams = this.getFirstParameter(null);
            this.setParameters(newParams);
            if (oldParams != null) {
                oldParams.delete(linkage);
            }
            this.getDB().putByte(this.record + 42L, newAnnotation);
        }
    }

    private void setType(PDOMLinkage linkage, IFunctionType ft) throws CoreException {
        linkage.storeType(this.record + 36L, ft);
    }

    private void setParameters(IParameter[] params) throws CoreException {
        ILinkage linkage = this.getLinkage();
        Database db = this.getDB();
        db.putInt(this.record + 28L, params.length);
        db.putRecPtr(this.record + 32L, 0L);
        PDOMNode next = null;
        int i = params.length - 1;
        while (i >= 0) {
            next = new PDOMCParameter((PDOMLinkage)linkage, this, params[i], (PDOMCParameter)next);
            --i;
        }
        db.putRecPtr(this.record + 32L, next == null ? 0L : next.getRecord());
    }

    public PDOMCParameter getFirstParameter(IType t) throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 32L);
        return rec != 0L ? new PDOMCParameter((PDOMLinkage)this.getLinkage(), rec, t) : null;
    }

    protected int getRecordSize() {
        return 43;
    }

    public int getNodeType() {
        return 7;
    }

    public IFunctionType getType() {
        try {
            return (IFunctionType)((PDOMLinkage)this.getLinkage()).loadType(this.record + 36L);
        }
        catch (CoreException ce) {
            CCorePlugin.log(ce);
            return null;
        }
    }

    public boolean isStatic() throws DOMException {
        return this.getBit(this.getByte(this.record + 42L), 4);
    }

    public boolean isExtern() throws DOMException {
        return this.getBit(this.getByte(this.record + 42L), 1);
    }

    public IParameter[] getParameters() throws DOMException {
        try {
            ILinkage linkage = this.getLinkage();
            Database db = this.getDB();
            IFunctionType ft = this.getType();
            IType[] ptypes = ft == null ? IType.EMPTY_TYPE_ARRAY : ft.getParameterTypes();
            int n = db.getInt(this.record + 28L);
            IParameter[] result = new IParameter[n];
            long next = db.getRecPtr(this.record + 32L);
            int i = 0;
            while (i < n && next != 0L) {
                IType type = i < ptypes.length ? ptypes[i] : null;
                PDOMCParameter par = new PDOMCParameter((PDOMLinkage)linkage, next, type);
                next = par.getNextPtr();
                result[i] = par;
                ++i;
            }
            return result;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return IParameter.EMPTY_PARAMETER_ARRAY;
        }
    }

    public boolean isAuto() throws DOMException {
        return false;
    }

    public boolean isRegister() throws DOMException {
        return false;
    }

    public boolean isInline() throws DOMException {
        return this.getBit(this.getByte(this.record + 42L), 2);
    }

    public boolean takesVarArgs() throws DOMException {
        return this.getBit(this.getByte(this.record + 42L), 5);
    }

    public IScope getFunctionScope() throws DOMException {
        return null;
    }
}

