/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVariableReadWriteFlags;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMValue;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotation;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPVariable
extends PDOMCPPBinding
implements ICPPVariable {
    private static final int TYPE_OFFSET = 28;
    private static final int VALUE_OFFSET = 34;
    protected static final int ANNOTATIONS = 38;
    protected static final int RECORD_SIZE = 39;

    public PDOMCPPVariable(PDOMLinkage linkage, PDOMNode parent, IVariable variable) throws CoreException {
        super(linkage, parent, variable.getNameCharArray());
        try {
            Database db = this.getDB();
            this.setType(parent.getLinkage(), variable.getType());
            db.putByte(this.record + 38L, this.encodeFlags(variable));
            this.setValue(db, variable);
        }
        catch (DOMException e) {
            throw new CoreException(Util.createStatus(e));
        }
    }

    private void setValue(Database db, IVariable variable) throws CoreException {
        IValue val = variable.getInitialValue();
        long valueRec = PDOMValue.store(db, (PDOMLinkage)this.getLinkage(), val);
        db.putRecPtr(this.record + 34L, valueRec);
    }

    public void update(PDOMLinkage linkage, IBinding newBinding) throws CoreException {
        if (newBinding instanceof IVariable) {
            Database db = this.getDB();
            IVariable var = (IVariable)newBinding;
            long valueRec = db.getRecPtr(this.record + 34L);
            try {
                IType newType = var.getType();
                this.setType(linkage, newType);
                db.putByte(this.record + 38L, this.encodeFlags(var));
                this.setValue(db, var);
                PDOMValue.delete(db, valueRec);
            }
            catch (DOMException e) {
                throw new CoreException(Util.createStatus(e));
            }
        }
    }

    private void setType(PDOMLinkage linkage, IType newType) throws CoreException {
        linkage.storeType(this.record + 28L, newType);
    }

    protected byte encodeFlags(IVariable variable) throws DOMException {
        return PDOMCPPAnnotation.encodeAnnotation(variable);
    }

    public PDOMCPPVariable(PDOMLinkage linkage, long record) {
        super(linkage, record);
    }

    protected int getRecordSize() {
        return 39;
    }

    public int getNodeType() {
        return 6;
    }

    public boolean isMutable() throws DOMException {
        return false;
    }

    public IType getType() {
        try {
            return ((PDOMLinkage)this.getLinkage()).loadType(this.record + 28L);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public IValue getInitialValue() {
        try {
            Database db = this.getDB();
            long valRec = db.getRecPtr(this.record + 34L);
            return PDOMValue.restore(db, (PDOMLinkage)this.getLinkage(), valRec);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    public boolean isAuto() throws DOMException {
        return this.getBit(this.getByte(this.record + 38L), 0);
    }

    public boolean isExtern() throws DOMException {
        return this.getBit(this.getByte(this.record + 38L), 1);
    }

    public boolean isExternC() throws DOMException {
        return this.getBit(this.getByte(this.record + 38L), 6);
    }

    public boolean isRegister() throws DOMException {
        return this.getBit(this.getByte(this.record + 38L), 3);
    }

    public boolean isStatic() throws DOMException {
        return this.getBit(this.getByte(this.record + 38L), 4);
    }

    public int getAdditionalNameFlags(int standardFlags, IASTName name) {
        if ((standardFlags & 3) == 3) {
            return CPPVariableReadWriteFlags.getReadWriteFlags(name);
        }
        return 0;
    }
}

